/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import Sirius.navigator.tools.MetaObjectCache;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class ModelLoader
extends SwingWorker<CidsBean[], Void> {
    private static final Logger LOG = Logger.getLogger(ModelLoader.class);
    private final String catalogueName;
    private final JComboBox cBox;
    private final String criterium;

    public ModelLoader(String catalogueName, JComboBox cBox, String criterium) {
        this.catalogueName = catalogueName;
        this.cBox = cBox;
        this.criterium = criterium;
    }

    @Override
    protected CidsBean[] doInBackground() throws Exception {
        MetaClass lstMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)("dlm25w." + this.catalogueName));
        if (lstMc != null) {
            ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
            String queryRk = "select " + lstMc.getID() + ", " + lstMc.getPrimaryKey() + " from " + lstMc.getTableName() + " where " + this.criterium;
            MetaObject[] mos = MetaObjectCache.getInstance().getMetaObjectsByQuery(queryRk, "DLM25W");
            if (mos != null) {
                for (MetaObject mo : mos) {
                    beans.add(mo.getBean());
                }
            }
            return beans.toArray(new CidsBean[beans.size()]);
        }
        return new CidsBean[0];
    }

    @Override
    protected void done() {
        try {
            this.cBox.setModel(new DefaultComboBoxModel<Object>((Object[])this.get()));
        }
        catch (Exception e) {
            LOG.error((Object)("Error while initializing the model of the catalogue " + this.catalogueName), (Throwable)e);
        }
    }
}

