/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import de.cismet.cids.utils.interfaces.DefaultMetaTreeNodeVisualizationService;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanelEvent;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanelListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.GetFeatureInfoMultiGeomListener;
import de.cismet.cismap.commons.interaction.events.GetFeatureInfoEvent;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class WatergisTreeNodeVisualizationService
implements DefaultMetaTreeNodeVisualizationService,
FeatureInfoPanelListener {
    private static final Logger LOG = Logger.getLogger(WatergisTreeNodeVisualizationService.class);
    private static List<Feature> visualisedFeatures = new ArrayList<Feature>();

    public void removeVisualization(DefaultMetaTreeNode dmtn) throws Exception {
        if (dmtn instanceof ObjectTreeNode) {
            ObjectTreeNode oNode = (ObjectTreeNode)dmtn;
            CidsFeature feature = new CidsFeature(oNode.getMetaObject());
            ArrayList<CidsFeature> featureList = new ArrayList<CidsFeature>();
            featureList.add(feature);
            AppBroker.getInstance().getMappingComponent().removeFeatures(featureList);
        }
    }

    public void removeVisualization(Collection<DefaultMetaTreeNode> c) throws Exception {
        for (DefaultMetaTreeNode tmp : c) {
            this.removeVisualization(tmp);
        }
    }

    public void addVisualization(DefaultMetaTreeNode defaultMetaTreeNode) throws Exception {
        if (defaultMetaTreeNode instanceof ObjectTreeNode) {
            ObjectTreeNode oNode = (ObjectTreeNode)defaultMetaTreeNode;
            CidsFeature feature = new CidsFeature(oNode.getMetaObject());
            ArrayList<CidsFeature> featureList = new ArrayList<CidsFeature>();
            featureList.add(feature);
            visualisedFeatures.add((Feature)feature);
            AppBroker.getInstance().getMappingComponent().addFeaturesToMap(new Feature[]{feature});
            ArrayList<DefaultFeatureServiceFeature> featureToZoom = new ArrayList<DefaultFeatureServiceFeature>();
            DefaultFeatureServiceFeature featureZoom = new DefaultFeatureServiceFeature();
            XBoundingBox box = new XBoundingBox(feature.getGeometry());
            if (AppBroker.getInstance().getProblemFeatureGeometryIncrease() > 0) {
                box.increase(AppBroker.getInstance().getProblemFeatureGeometryIncrease() * 100);
            }
            featureZoom.setGeometry(box.getGeometry());
            featureToZoom.add(featureZoom);
            AppBroker.getInstance().getMappingComponent().zoomToAFeatureCollection(featureToZoom, false, false);
            AppBroker.getInstance().getInfoWindowAction().showDialog();
            AppBroker.getInstance().getInfoWindowAction().addFeatureInfoPanelListener(this);
            AppBroker.getInstance().getInfoWindowAction().showAllFeature();
            this.addFeatureToFeatureInfoDialog(oNode);
        }
    }

    private void addFeatureToFeatureInfoDialog(final ObjectTreeNode oNode) throws Exception {
        final CidsFeature feature = new CidsFeature(oNode.getMetaObject());
        WaitingDialogThread<List<DefaultFeatureServiceFeature>> wdt = new WaitingDialogThread<List<DefaultFeatureServiceFeature>>((Frame)AppBroker.getInstance().getWatergisApp(), true, NbBundle.getMessage(WatergisTreeNodeVisualizationService.class, (String)"WatergisTreeNodeVisualizationService.addFeatureToFeatureInfoDialog.text"), null, 100){

            protected List<DefaultFeatureServiceFeature> doInBackground() throws Exception {
                CidsLayer layer = new CidsLayer(oNode.getMetaClass());
                layer.initAndWait();
                return layer.getFeatureFactory().createFeatures((Object)layer.getQuery(), (BoundingBox)new XBoundingBox(feature.getGeometry()), null, 0, 0, null);
            }

            protected void done() {
                try {
                    GetFeatureInfoMultiGeomListener l = (GetFeatureInfoMultiGeomListener)AppBroker.getInstance().getMappingComponent().getInputListener("FEATURE_INFO_MULTI_GEOM");
                    ArrayList<DefaultFeatureServiceFeature> featureList = new ArrayList<DefaultFeatureServiceFeature>();
                    GetFeatureInfoEvent event = new GetFeatureInfoEvent((Object)this, feature.getGeometry());
                    List features = (List)this.get();
                    DefaultFeatureServiceFeature cidsFeature = null;
                    for (DefaultFeatureServiceFeature f : features) {
                        if (f.getId() != feature.getMetaObject().getId()) continue;
                        cidsFeature = f;
                        break;
                    }
                    featureList.add(cidsFeature);
                    event.setFeatures(featureList);
                    l.fireGetFeatureInfoEvent(event);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while loading feature with id ", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    public void addVisualization(Collection<DefaultMetaTreeNode> c) throws Exception {
        for (DefaultMetaTreeNode tmp : c) {
            this.addVisualization(tmp);
        }
    }

    public void featureSaved(FeatureInfoPanelEvent evt) {
        AppBroker.getInstance().getMappingComponent().removeFeatures(visualisedFeatures);
        AppBroker.getInstance().getInfoWindowAction().removeFeatureInfoPanelListener(this);
        visualisedFeatures.clear();
    }

    public void dispose(FeatureInfoPanelEvent evt) {
        AppBroker.getInstance().getMappingComponent().removeFeatures(visualisedFeatures);
        AppBroker.getInstance().getInfoWindowAction().removeFeatureInfoPanelListener(this);
        visualisedFeatures.clear();
    }

    public static void removeVisualisedFeatures() {
        AppBroker.getInstance().getMappingComponent().removeFeatures(visualisedFeatures);
        visualisedFeatures.clear();
    }
}

