/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.watergis.gui.dialog;

import org.openide.util.Lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

import javax.swing.DefaultComboBoxModel;

import de.cismet.cids.search.QuerySearch;
import de.cismet.cids.search.QuerySearchMethod;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.rasterservice.MapService;

import de.cismet.connectioncontext.ConnectionContext;

import de.cismet.watergis.broker.AppBroker;

import de.cismet.watergis.gui.components.location.SelectionMethodInterface;

import de.cismet.watergis.utils.AddToSelectionQuerySearchMethod;
import de.cismet.watergis.utils.RemoveFromSelectionQuerySearchMethod;
import de.cismet.watergis.utils.SelectFromSelectionQuerySearchMethod;
import de.cismet.watergis.utils.SelectQuerySearchMethod;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class QuerySearchDialog extends javax.swing.JDialog {

    //~ Instance fields --------------------------------------------------------

    final SelectionMethodInterface[] smArray;

    private ActiveLayerModel model;
    private AbstractFeatureService[] choosenLayer;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.search.QuerySearch querySearch1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form QuerySearchDialog.
     *
     * @param  parent  DOCUMENT ME!
     * @param  modal   DOCUMENT ME!
     * @param  model   DOCUMENT ME!
     */
    public QuerySearchDialog(final java.awt.Frame parent, final boolean modal, final ActiveLayerModel model) {
        super(parent, modal);
        this.model = model;

        final Collection<? extends SelectionMethodInterface> selectionMethod = Lookup.getDefault()
                    .lookupAll(SelectionMethodInterface.class);
        smArray = selectionMethod.toArray(new SelectionMethodInterface[selectionMethod.size()]);
        final ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent()
                    .getMappingModel();
        final List<AbstractFeatureService> sourceLayer = new ArrayList<AbstractFeatureService>();
        final TreeMap<Integer, MapService> serviceMap = layerModel.getMapServices();
        final List<Integer> keyList = new ArrayList<Integer>(serviceMap.keySet());
        Collections.sort(keyList, Collections.reverseOrder());
        Arrays.sort(smArray, new Comparator<SelectionMethodInterface>() {

                @Override
                public int compare(final SelectionMethodInterface o1, final SelectionMethodInterface o2) {
                    return o1.getOrderId().compareTo(o2.getOrderId());
                }
            });

        for (final Integer key : keyList) {
            final MapService service = serviceMap.get(key);

            if (service instanceof AbstractFeatureService) {
                sourceLayer.add((AbstractFeatureService)service);
            }
        }

        choosenLayer = sourceLayer.toArray(new AbstractFeatureService[sourceLayer.size()]);

        initComponents();
        querySearch1.initWithConnectionContext(ConnectionContext.createDummy());
        querySearch1.enableLineWrap(true);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        querySearch1 = new QuerySearch((ActiveLayerModel)AppBroker.getInstance().getMappingComponent()
                        .getMappingModel(),
                new String[] {},
                choosenLayer,
                new QuerySearchMethod[] {
                    new SelectQuerySearchMethod(),
                    new AddToSelectionQuerySearchMethod(),
                    new RemoveFromSelectionQuerySearchMethod(),
                    new SelectFromSelectionQuerySearchMethod()
                });

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(QuerySearchDialog.class, "QuerySearchDialog.title")); // NOI18N
        setPreferredSize(new java.awt.Dimension(430, 500));
        getContentPane().setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(querySearch1, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        /*
         * Set the Nimbus look and feel
         */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /*
         * If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel. For details see
         * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (final javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(QuerySearchDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(QuerySearchDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(QuerySearchDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(QuerySearchDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /*
         * Create and display the dialog
         */
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    final QuerySearchDialog dialog = new QuerySearchDialog(new javax.swing.JFrame(), true, null);
                    dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                            @Override
                            public void windowClosing(final java.awt.event.WindowEvent e) {
                                System.exit(0);
                            }
                        });
                    dialog.setVisible(true);
                }
            });
    }
}
