/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.watergis.gui.panels;

import org.apache.log4j.Logger;

import javax.swing.JFileChooser;

import de.cismet.tools.gui.RestrictedFileSystemView;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class DocumentPanel extends javax.swing.JPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(DocumentPanel.class);

    //~ Instance fields --------------------------------------------------------

    private String lastPath;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton butFile;
    private javax.swing.JTextField txtFile;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DocumentPanel.
     */
    public DocumentPanel() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        txtFile = new javax.swing.JTextField();
        butFile = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        txtFile.setText(org.openide.util.NbBundle.getMessage(
                DocumentPanel.class,
                "DocumentPanel.txtFile.text",
                new Object[] {})); // NOI18N
        txtFile.setEnabled(false);
        txtFile.setMinimumSize(new java.awt.Dimension(16, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(txtFile, gridBagConstraints);

        butFile.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/watergis/res/icons16/icon-importfile.png"))); // NOI18N
        butFile.setMinimumSize(new java.awt.Dimension(16, 16));
        butFile.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    butFileActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(butFile, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void butFileActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_butFileActionPerformed
        JFileChooser fc;
        String path = lastPath;

        if ((txtFile.getText() != null) && !txtFile.getText().equals("") && !txtFile.getText().startsWith("http")) {
            if (txtFile.getText().contains("/")) {
                path = txtFile.getText().substring(0, txtFile.getText().lastIndexOf("/"));
            } else if (txtFile.getText().contains("\\")) {
                path = txtFile.getText().substring(0, txtFile.getText().lastIndexOf("\\"));
            }
        }

        try {
            fc = new JFileChooser(path);
        } catch (Exception bug) {
            // Bug Workaround http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6544857
            fc = new JFileChooser(path, new RestrictedFileSystemView());
        }

        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fc.setAcceptAllFileFilterUsed(true);

        final int ans = fc.showSaveDialog(this);

        if (ans == JFileChooser.APPROVE_OPTION) {
            lastPath = fc.getSelectedFile().getParent();
            txtFile.setText(fc.getSelectedFile().getAbsolutePath());
        }
    } //GEN-LAST:event_butFileActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public String getFile() {
        return txtFile.getText();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  file  DOCUMENT ME!
     */
    public void setValue(final String file) {
        txtFile.setText(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public String getValue() {
        return txtFile.getText();
    }
}
