/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * DownloadManagerOptionsPanel.java
 *
 * Created on 09.08.2011, 15:10:48
 */
package de.cismet.watergis.gui.panels;

import org.apache.log4j.Logger;

import org.jdom.Element;

import org.openide.util.NbBundle;
import org.openide.util.lookup.ServiceProvider;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;

import de.cismet.tools.configuration.NoWriteError;

import de.cismet.watergis.broker.AppBroker;

/**
 * DOCUMENT ME!
 *
 * @author   Gilles Baatz
 * @version  $Revision$, $Date$
 */
@ServiceProvider(
    service = OptionsPanelController.class,
    supersedes = { "de.cismet.cids.custom.wrrl_db_mv.util.WrrlMapOptionsPanel" }
)
public class WatergisOptionsPanel extends AbstractOptionsPanel implements OptionsPanelController {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(WatergisOptionsPanel.class);

    private static final String OPTION_NAME = NbBundle.getMessage(
            WatergisOptionsPanel.class,
            "WatergisOptionsPanel.OPTION_NAME");

    //~ Instance fields --------------------------------------------------------

    private int maxShownRecentlyOpenedLocalConfigFiles = 5;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.Box.Filler filler2;
    private javax.swing.JLabel lblLocalConfigFiles;
    private javax.swing.JSpinner spnShownLocalConfigFiles;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DownloadManagerOptionsPanel.
     */
    public WatergisOptionsPanel() {
        super(OPTION_NAME, WatergisOptionsCategory.class);

        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        filler2 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 32767));
        lblLocalConfigFiles = new javax.swing.JLabel();
        spnShownLocalConfigFiles = new javax.swing.JSpinner();

        setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(filler2, gridBagConstraints);

        lblLocalConfigFiles.setText(org.openide.util.NbBundle.getMessage(
                WatergisOptionsPanel.class,
                "WatergisOptionsPanel.lblLocalConfigFiles.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 10);
        add(lblLocalConfigFiles, gridBagConstraints);

        spnShownLocalConfigFiles.setModel(new javax.swing.SpinnerNumberModel(5, 1, 50, 1));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(spnShownLocalConfigFiles, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     */
    @Override
    public void update() {
        maxShownRecentlyOpenedLocalConfigFiles = AppBroker.getInstance().getRecentlyOpenedFilesList().getMaxAmount();

        spnShownLocalConfigFiles.setValue(maxShownRecentlyOpenedLocalConfigFiles);
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    public void applyChanges() {
        maxShownRecentlyOpenedLocalConfigFiles = (Integer)spnShownLocalConfigFiles.getValue();

        AppBroker.getInstance().getRecentlyOpenedFilesList().setMaxAmount(maxShownRecentlyOpenedLocalConfigFiles);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public boolean isChanged() {
        boolean result = false;

        result = (maxShownRecentlyOpenedLocalConfigFiles != ((Integer)spnShownLocalConfigFiles.getValue()).intValue());

        return result;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public String getTooltip() {
        return NbBundle.getMessage(WatergisOptionsPanel.class,
                "WatergisOptionsPanel.tooltip");
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  NoWriteError  DOCUMENT ME!
     */
    @Override
    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  parent  DOCUMENT ME!
     */
    @Override
    public void configure(final Element parent) {
    }

    /**
     * DOCUMENT ME!
     *
     * @param  parent  DOCUMENT ME!
     */
    @Override
    public void masterConfigure(final Element parent) {
    }
}
