/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.permissions.dlm25w;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.permissions.dlm25w.WatergisPermissionProvider;
import de.cismet.cids.custom.watergis.server.search.QpWwgrByNr;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerPermissionProvider;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Dlm25wQpGafPpPermissionProvider
extends WatergisPermissionProvider
implements CidsLayerPermissionProvider {
    private static final Logger LOG = Logger.getLogger(Dlm25wQpGafPpPermissionProvider.class);

    @Override
    protected CidsBean getWwGrBean() {
        try {
            String qpNr = String.valueOf(this.cidsBean.getProperty("qp_nr"));
            QpWwgrByNr search = new QpWwgrByNr(qpNr);
            User user = SessionManager.getSession().getUser();
            ArrayList nrList = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
            if (nrList != null && nrList.size() == 1) {
                return ((MetaObject)nrList.get(0)).getBean();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot determine upload user for qp.", (Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    protected CidsBean getWwGrfromFeature(CidsLayerFeature feature) {
        try {
            String qpNr = String.valueOf(feature.getProperty("qp_nr"));
            QpWwgrByNr search = new QpWwgrByNr(qpNr);
            User user = SessionManager.getSession().getUser();
            ArrayList nrList = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
            if (nrList != null && nrList.size() == 1) {
                return ((MetaObject)nrList.get(0)).getBean();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot determine upload user for qp.", (Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    protected String getWwGrPropertyName() {
        return "ww_gr";
    }

    @Override
    public boolean getCustomWritePermissionDecisionforUser(User u) {
        if (u.getUserGroup().getName().equalsIgnoreCase("administratoren") || u.getUserGroup().getName().equalsIgnoreCase("admin_edit")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"member of admin group. permission is granted");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean getCustomCidsLayerWritePermissionDecisionforUser(User u, CidsLayerFeature feature) {
        if (u.getUserGroup().getName().equalsIgnoreCase("administratoren") || u.getUserGroup().getName().equalsIgnoreCase("admin_edit")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"member of admin group. permission is granted");
            }
            return true;
        }
        return false;
    }
}

