/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.table.TableModel;

public class Alkis43000RuleSet
extends WatergisDefaultRuleSet {
    public Alkis43000RuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("oid", new WatergisDefaultRuleSet.Varchar(16, false, true));
        this.typeMap.put("objart", new WatergisDefaultRuleSet.Numeric(5, 0, false, true));
        this.typeMap.put("veg", new WatergisDefaultRuleSet.Varchar(4, false, true));
        this.typeMap.put("fkt", new WatergisDefaultRuleSet.Varchar(4, false, true));
        this.typeMap.put("ofm", new WatergisDefaultRuleSet.Varchar(4, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            Long flaeche = Math.round(geom.getArea());
            feature.getProperties().put("flaeche", flaeche);
        }
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", false);
        c.setMinArea(1.0E-4);
        return c;
    }
}

