/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.exception.ConnectionException;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.SimpleAttributeTableModel;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class EzgDetailRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(EzgDetailRuleSet.class);

    public EzgDetailRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("gbk_lawa", new WatergisDefaultRuleSet.Catalogue("k_gbk_lawa", false, true, true, new WatergisDefaultRuleSet.Numeric(15, 0, false, false)));
        this.typeMap.put("gbk_lawa_k", new WatergisDefaultRuleSet.Catalogue("k_gbk_lawa", false, true, new WatergisDefaultRuleSet.Numeric(15, 0, false, false)));
        this.typeMap.put("gwk_lawa", new WatergisDefaultRuleSet.Catalogue("k_gwk_lawa", false, true, true, new WatergisDefaultRuleSet.Numeric(15, 0, false, false)));
        this.typeMap.put("gwk_gn", new WatergisDefaultRuleSet.Catalogue("k_gwk_lawa", false, true, new WatergisDefaultRuleSet.Varchar(60, false, false)));
        this.typeMap.put("gbk_von", new WatergisDefaultRuleSet.Catalogue("k_gbk_lawa", false, true, new WatergisDefaultRuleSet.Varchar(100, false, false)));
        this.typeMap.put("gbk_bis", new WatergisDefaultRuleSet.Catalogue("k_gbk_lawa", false, true, new WatergisDefaultRuleSet.Varchar(100, false, false)));
        this.typeMap.put("gbk_ordn", new WatergisDefaultRuleSet.Catalogue("k_gbk_lawa", false, true, new WatergisDefaultRuleSet.Numeric(2, 0, false, false)));
        this.typeMap.put("gbk_pl", new WatergisDefaultRuleSet.Catalogue("k_gbk_lawa", false, true, new WatergisDefaultRuleSet.Numeric(10, 0, false, false)));
        this.typeMap.put("ezg_fl", new WatergisDefaultRuleSet.Numeric(12, 0, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        if (column.equals("gbk_lawa") && newValue != null) {
            CidsLayerFeature cf = (CidsLayerFeature)feature;
            Object o = cf.getCatalogueCombo("gbk_lawa").getSelectedItem();
            if (o instanceof CidsLayerFeature) {
                CidsLayerFeature layerFeature = (CidsLayerFeature)o;
                feature.setProperty("gbk_lawa_k", (Object)layerFeature.getBean());
                feature.setProperty("gbk_von", (Object)layerFeature.getBean());
                feature.setProperty("gbk_bis", (Object)layerFeature.getBean());
                feature.setProperty("gbk_ordn", (Object)layerFeature.getBean());
                feature.setProperty("gbk_pl", (Object)layerFeature.getBean());
                try {
                    ((CidsLayerFeature)feature).getCatalogueCombo("gbk_lawa_k").setSelectedItem((Object)layerFeature);
                    ((CidsLayerFeature)feature).getCatalogueCombo("gbk_von").setSelectedItem((Object)layerFeature);
                    ((CidsLayerFeature)feature).getCatalogueCombo("gbk_bis").setSelectedItem((Object)layerFeature);
                    ((CidsLayerFeature)feature).getCatalogueCombo("gbk_ordn").setSelectedItem((Object)layerFeature);
                    ((CidsLayerFeature)feature).getCatalogueCombo("gbk_pl").setSelectedItem((Object)layerFeature);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot set dependent properties", (Throwable)e);
                }
            }
            return newValue;
        }
        if (column.equals("gwk_lawa") && newValue != null) {
            CidsLayerFeature cf = (CidsLayerFeature)feature;
            Object o = cf.getCatalogueCombo("gwk_lawa").getSelectedItem();
            if (o instanceof CidsLayerFeature) {
                CidsLayerFeature layerFeature = (CidsLayerFeature)o;
                feature.setProperty("gwk_gn", (Object)layerFeature.getBean());
                try {
                    ((CidsLayerFeature)feature).getCatalogueCombo("gwk_gn").setSelectedItem((Object)layerFeature);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot set dependent properties", (Throwable)e);
                }
            }
            return newValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("flaeche") && !columnName.equals("geom") && !columnName.equals("id") && !columnName.equals("gbk_lawa_k") && !columnName.equals("gbk_von") && !columnName.equals("gbk_bis") && !columnName.equals("gbk_pl") && !columnName.equals("gbk_ordn") && !columnName.equals("gwk_gn");
    }

    @Override
    public FeatureServiceFeature cloneFeature(FeatureServiceFeature feature) {
        DefaultFeatureServiceFeature newFeature = (DefaultFeatureServiceFeature)feature.getLayerProperties().getFeatureService().getFeatureFactory().createNewFeature();
        HashMap properties = feature.getProperties();
        CidsBean bean = ((CidsLayerFeature)feature).getBean();
        for (String propertyKey : properties.keySet()) {
            Object value;
            CidsLayerFeature clf;
            if (propertyKey.equalsIgnoreCase("gbk_lawa_k") || propertyKey.equalsIgnoreCase("gbk_von") || propertyKey.equalsIgnoreCase("gbk_bis") || propertyKey.equalsIgnoreCase("gbk_pl") || propertyKey.equalsIgnoreCase("gbk_ordn")) {
                clf = (CidsLayerFeature)feature;
                value = clf.getPropertyObject("gbk_lawa");
                if (value instanceof CidsLayerFeature) {
                    value = ((CidsLayerFeature)value).getBean();
                }
                newFeature.setProperty(propertyKey, value);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("gwk_gn")) {
                clf = (CidsLayerFeature)feature;
                value = clf.getPropertyObject("gwk_lawa");
                if (value instanceof CidsLayerFeature) {
                    value = ((CidsLayerFeature)value).getBean();
                }
                newFeature.setProperty(propertyKey, value);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("id") || propertyKey.equals(feature.getIdExpression()) || propertyKey.equalsIgnoreCase("obj_nr")) continue;
            if (bean.getProperty(propertyKey) == null) {
                newFeature.setProperty(propertyKey, feature.getProperty(propertyKey));
                continue;
            }
            if (bean.getProperty(propertyKey) instanceof CidsBean && bean.getProperty(propertyKey).getClass().getName().equals("de.cismet.cids.dynamics.Geom")) {
                newFeature.setProperty(propertyKey, (Object)feature.getGeometry());
                continue;
            }
            newFeature.setProperty(propertyKey, bean.getProperty(propertyKey));
        }
        newFeature.setGeometry(feature.getGeometry());
        return newFeature;
    }

    @Override
    public TableCellRenderer getCellRenderer(final String columnName) {
        if (columnName.equals("gbk_lawa_k") || columnName.equals("gbk_von") || columnName.equals("gbk_bis") || columnName.equals("gbk_pl") || columnName.equals("gbk_ordn") || columnName.equals("gwk_gn")) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c;
                    Object val = value;
                    if (table.getModel() instanceof SimpleAttributeTableModel) {
                        SimpleAttributeTableModel model = (SimpleAttributeTableModel)table.getModel();
                        val = model.getFeatureServiceFeature(table.convertRowIndexToModel(row)).getProperty(columnName);
                    }
                    if (val instanceof CidsBean) {
                        val = columnName.equals("gwk_gn") ? ((CidsBean)val).getProperty("la_gn") : ((CidsBean)val).getProperty(columnName);
                    }
                    if ((c = super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column)) instanceof JLabel && !columnName.equals("gwk_gn") && !columnName.equals("gbk_von") && !columnName.equals("gbk_bis")) {
                        ((JLabel)c).setHorizontalAlignment(4);
                        ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                    }
                    return c;
                }
            };
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("gbk_lawa")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(2), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    Object result = bean.getProperty("gbk_lawa");
                    if (result != null) {
                        return result.toString();
                    }
                    return null;
                }
            });
            return editor;
        }
        if (columnName.equals("gwk_lawa")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(2), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    Object result = bean.getProperty("la_cd");
                    if (result != null) {
                        return result.toString();
                    }
                    return null;
                }
            });
            return editor;
        }
        return super.getCellEditor(columnName);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
        super.beforeSave(feature);
    }

    public void afterSave(TableModel model) {
        try {
            this.refreshTemplate("RefreshDrainBasin");
            this.refreshTemplate("RefreshEzgKrl");
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Cannot refresh template", (Throwable)ex);
        }
        super.afterSave(model);
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }
}

