/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.HashMap;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FgBaBbefRuleSet
extends WatergisDefaultRuleSet {
    private static final HashMap<String, String[]> allowedMaterial = new HashMap();

    public FgBaBbefRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("l_rl", new WatergisDefaultRuleSet.Catalogue("k_l_rl", true, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("bbef", new WatergisDefaultRuleSet.Catalogue("k_bbef", true, true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(FgBaBbefRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("esw", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_d_o", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("ho_d_u", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.minBaLength = 0.5;
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("laenge") && !columnName.equals("ww_gr") && !columnName.equals("ba_cd") && !columnName.equals("geom") && !columnName.equals("obj_nr") && !columnName.equals("id");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        String[] allowedMaterialVArray;
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaBbefRuleSet.isValueEmpty(newValue) && (column.equals("l_rl") || column.equals("bbef"))) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        if (column.equals("br") && !this.checkRange(column, newValue, 0, 15, 0, 30, true, false, true)) {
            return oldValue;
        }
        if (column.equals("ho_d_o") && !this.checkRange(column, newValue, 0, 10, 0, 15, true, false, true)) {
            return oldValue;
        }
        if (column.equals("ho_d_u") && !this.checkRange(column, newValue, 0, 10, 0, 15, true, true, false)) {
            return oldValue;
        }
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, FgBaBbefRuleSet.getCurrentYear(), 1800, FgBaBbefRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("bbef") && !FgBaBbefRuleSet.isValueEmpty(newValue) && (allowedMaterialVArray = allowedMaterial.get(newValue.toString())) != null && !FgBaBbefRuleSet.isValueEmpty(feature.getProperty("material")) && !FgBaBbefRuleSet.arrayContains(allowedMaterialVArray, feature.getProperty("material") != null ? feature.getProperty("material").toString() : null)) {
            this.showMessage("Wenn das Attribut bbef = " + newValue.toString() + ", dann muss das Attribut material " + FgBaBbefRuleSet.arrayToString(allowedMaterialVArray) + " sein.", column);
            return oldValue;
        }
        if (column.equals("material") && !FgBaBbefRuleSet.isValueEmpty(newValue) && (allowedMaterialVArray = allowedMaterial.get(feature.getProperty("bbef").toString())) != null && !FgBaBbefRuleSet.arrayContains(allowedMaterialVArray, newValue.toString())) {
            this.showMessage("Wenn das Attribut bbef = " + newValue + ", dann muss das Attribut material " + FgBaBbefRuleSet.arrayToString(allowedMaterialVArray) + " sein.", column);
            return oldValue;
        }
        if (column.equals("ho_d_o") && newValue != null && FgBaBbefRuleSet.isNumberOrNull(newValue) && feature.getProperty("ho_d_u") != null && ((Number)newValue).doubleValue() <= ((Number)feature.getProperty("ho_d_u")).doubleValue()) {
            this.showMessage("Das Attribut ho_d_o muss gr\u00f6\u00dfer als das Attribut ho_d_u sein.", column);
            return oldValue;
        }
        if (column.equals("ho_d_u") && newValue != null && FgBaBbefRuleSet.isNumberOrNull(newValue) && feature.getProperty("ho_d_o") != null && ((Number)feature.getProperty("ho_d_o")).doubleValue() <= ((Number)newValue).doubleValue()) {
            this.showMessage("Das Attribut ho_d_o muss gr\u00f6\u00dfer als das Attribut ho_d_u sein.", column);
            return oldValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_rl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), this.createCidsLayerFeatureFilter("bbef"));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_rl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("bbef")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("bbef") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("material")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), this.createCidsLayerFeatureFilter("bbef"));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("material") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return super.getCellEditor(columnName);
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            String[] allowedMaterialVArray;
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaBbefRuleSet.isValueEmpty(feature.getProperty("l_rl"))) {
                this.showMessage("Das Attribut l_rl darf nicht leer sein", "l_rl");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "l_rl");
            }
            if (FgBaBbefRuleSet.isValueEmpty(feature.getProperty("bbef"))) {
                this.showMessage("Das Attribut bbef darf nicht leer sein", "bbef");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bbef");
            }
            if (!this.checkRange("br", feature.getProperty("br"), 0, 15, 0, 30, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br");
            }
            if (!this.checkRange("ho_d_o", feature.getProperty("ho_d_o"), 0, 10, 0, 15, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_d_o");
            }
            if (!this.checkRange("ho_d_u", feature.getProperty("ho_d_u"), 0, 10, 0, 15, true, true, false)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_d_u");
            }
            if (!this.checkRangeBetweenOrEqual("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, FgBaBbefRuleSet.getCurrentYear() + 2, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (feature.getProperty("bbef") != null && feature.getProperty("bbef").toString().equals("Rin") && Math.abs(FgBaBbefRuleSet.toNumber(feature.getProperty("ba_st_von")).doubleValue() - FgBaBbefRuleSet.toNumber(feature.getProperty("ba_st_bis")).doubleValue()) > 10.0) {
                this.showMessage("Bei Rin darf die Geometrie nicht l\u00e4nger als 10 m sein.", "ba_st_bis");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ba_st_bis");
            }
            if (feature.getProperty("ho_d_o") != null && feature.getProperty("ho_d_u") != null && ((Number)feature.getProperty("ho_d_o")).doubleValue() <= ((Number)feature.getProperty("ho_d_u")).doubleValue()) {
                this.showMessage("Das Attribut ho_d_o muss gr\u00f6\u00dfer als das Attribut ho_d_u sein.", "ho_d_o");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_d_o");
            }
            if (feature.getProperty("bbef") == null || (allowedMaterialVArray = allowedMaterial.get(feature.getProperty("bbef").toString())) == null || FgBaBbefRuleSet.isValueEmpty(feature.getProperty("material")) || FgBaBbefRuleSet.arrayContains(allowedMaterialVArray, feature.getProperty("material") != null ? feature.getProperty("material").toString() : null)) continue;
            this.showMessage("Wenn das Attribut bbef = " + feature.getProperty("bbef").toString() + ", dann muss das Attribut material " + FgBaBbefRuleSet.arrayToString(allowedMaterialVArray) + " sein.", "material");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "material");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationLineCreator creator = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper(), 0.5f);
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            FgBaBbefRuleSet.downloadDocumentFromWebDav(FgBaBbefRuleSet.getWbblPath(), FgBaBbefRuleSet.addExtension(value.toString(), "pdf"));
        }
    }

    static {
        allowedMaterial.put("Berme", new String[]{null});
        allowedMaterial.put("Fa", new String[]{"H-Rsg", "Kok", "H"});
        allowedMaterial.put("SP", new String[]{"Ste", "Ste-Fs", "Ste-Gab", "Ste-Wb"});
        allowedMaterial.put("Gtr", new String[]{"B", "K", "Ste-Fs"});
        allowedMaterial.put("Mte", new String[]{"Ste-Gab", "Vl"});
        allowedMaterial.put("Pfl", new String[]{"B"});
        allowedMaterial.put("Pfr", new String[]{"B", "H", "K", "St"});
        allowedMaterial.put("Pl", new String[]{"B"});
        allowedMaterial.put("Rin", new String[]{"B", "St-B", "Ste", "Ste-Fs", "Ste-Mw", "Ste-Wb"});
        allowedMaterial.put("Spreit", new String[]{"H"});
    }
}

