/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.DateCellEditor;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.FgBaEaRuleSet;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.tools.BrowserLauncher;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class FgBaDocRuleSet
extends WatergisDefaultRuleSet {
    private static final String docTemplate = "http://bender.cismet.de/watergis/dokumente/%s";
    private static final Logger LOG = Logger.getLogger(FgBaEaRuleSet.class);

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("laenge") && !columnName.equals("id");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaDocRuleSet.isValueEmpty(newValue) && (column.equals("titel") || column.equals("doc"))) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        return newValue;
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("doc")) {
            return new LinkTableCellRenderer();
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("datum")) {
            return new DateCellEditor();
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaDocRuleSet.isValueEmpty(feature.getProperty("titel"))) {
                this.showMessage("Das Attribut titel darf nicht leer sein", "titel");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "titel");
            }
            if (!FgBaDocRuleSet.isValueEmpty(feature.getProperty("doc"))) continue;
            this.showMessage("Das Attribut doc darf nicht leer sein", "doc");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "doc");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        StationLineCreator creator = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper(), 0.5f, 100.0f);
        creator.setProperties(this.getDefaultValues());
        return creator;
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (AppBroker.getInstance().getOwnWwGr() != null) {
            properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        } else {
            properties.put("ww_gr", AppBroker.getInstance().getNiemandWwGr());
        }
        return properties;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("doc") && value instanceof String && clickCount == 1) {
            try {
                URL u = new URL(String.format(docTemplate, value.toString()));
                try {
                    BrowserLauncher.openURL((String)u.toString());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Cannot open the url:" + u), (Throwable)ex);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

