/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.watergis.server.search.FgBaCdCheck;
import de.cismet.cids.custom.watergis.server.search.RemoveUnnusedRoute;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.SimpleAttributeTableModel;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.watergis.broker.AppBroker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class FgBaDuvRuleSet
extends WatergisDefaultRuleSet {
    private static final Random RANDOM = new Random(new Date().getTime());
    private static final Logger LOG = Logger.getLogger(FgBaDuvRuleSet.class);

    public FgBaDuvRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(false, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("ba_gn", new WatergisDefaultRuleSet.Varchar(50, false));
        this.typeMap.put("wdm", new WatergisDefaultRuleSet.Numeric(4, 0, false));
        this.typeMap.put("gu_zust", new WatergisDefaultRuleSet.Varchar(2, false));
        this.typeMap.put("gu_cd", new WatergisDefaultRuleSet.Varchar(50, false));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("laenge") && !columnName.equals("id") && !columnName.equals("fis_g_date") && !columnName.equals("fis_g_user");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
        feature.setProperty("ba_st_von", (Object)0.0);
        if (feature.getGeometry() != null) {
            feature.setProperty("ba_st_bis", (Object)feature.getGeometry().getLength());
        }
    }

    public void afterSave(TableModel model) {
        List removedFeatures;
        if (model instanceof SimpleAttributeTableModel && (removedFeatures = ((SimpleAttributeTableModel)model).getRemovedFeature()) != null && !removedFeatures.isEmpty()) {
            ArrayList selectedFeaturesToRemove = new ArrayList();
            for (FeatureServiceFeature feature : removedFeatures) {
                try {
                    RemoveUnnusedRoute nodesSearch = new RemoveUnnusedRoute(feature.getId(), 6);
                    SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)nodesSearch);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while removing unused stations", (Throwable)e);
                }
            }
        }
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator creator = new PrimitiveGeometryCreator("LINESTRING", this.getDefaultValues());
        creator.setMinLength(0.01);
        return creator;
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        String baCd = String.valueOf(AppBroker.getInstance().getOwnWwGr().getProperty("praefix")) + ":";
        Random r = new Random(new Date().getTime());
        baCd = baCd + r.nextInt();
        properties.put("ba_cd", baCd);
        return properties;
    }

    @Override
    public FeatureServiceFeature cloneFeature(FeatureServiceFeature feature) {
        boolean unique;
        FeatureServiceFeature newFeature = super.cloneFeature(feature);
        CidsBean wwGr = (CidsBean)feature.getProperty("original:ww_gr");
        String prefix = String.valueOf(wwGr.getProperty("praefix"));
        String baCd = (String)newFeature.getProperty("ba_cd");
        do {
            unique = true;
            try {
                HashMap<Integer, String> baCdMap = new HashMap<Integer, String>();
                baCd = prefix + ":" + String.valueOf(Math.abs(RANDOM.nextInt()));
                baCdMap.put(-1, baCd);
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new FgBaCdCheck(baCdMap));
                if (attributes == null || attributes.isEmpty()) continue;
                unique = false;
            }
            catch (Exception e) {
                LOG.error((Object)"Error checking baCd", (Throwable)e);
            }
        } while (!unique);
        newFeature.setProperty("ba_cd", (Object)baCd);
        return newFeature;
    }
}

