/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.util.List;
import java.util.TreeSet;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class FgBaFgskRuleSet
extends WatergisDefaultRuleSet
implements AttributeTableExtendedRuleSet {
    private final Logger LOG = Logger.getLogger(FgBaFgskRuleSet.class);
    private TreeSet<FeatureServiceFeature> changedBaCdObjects;

    public FgBaFgskRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("fgsk_id", new WatergisDefaultRuleSet.Varchar(20, true, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("wk_nr", new WatergisDefaultRuleSet.Varchar(10, false, true));
        this.typeMap.put("typ_lawa", new WatergisDefaultRuleSet.Numeric(2, 0, false, true));
        this.typeMap.put("vorkart", new WatergisDefaultRuleSet.BooleanAsInteger(true, true));
        this.typeMap.put("sonderfall", new WatergisDefaultRuleSet.Varchar(10, false, true));
        this.typeMap.put("seeausfl", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("wasserf", new WatergisDefaultRuleSet.Varchar(2, false, true));
        this.typeMap.put("gu_status", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gk_sohle", new WatergisDefaultRuleSet.Numeric(1, 0, false, true, 0.0, 5.0));
        this.typeMap.put("gk_ufer", new WatergisDefaultRuleSet.Numeric(1, 0, false, true, 0.0, 5.0));
        this.typeMap.put("gk_land", new WatergisDefaultRuleSet.Numeric(1, 0, false, true, 0.0, 5.0));
        this.typeMap.put("gk_gesamt", new WatergisDefaultRuleSet.Numeric(1, 0, false, true, 0.0, 5.0));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("laenge") && !columnName.equals("ba_cd") && !columnName.equals("geom");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaFgskRuleSet.isValueEmpty(newValue) && (column.equals("fgsk_id") || column.equals("vorkart"))) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        if ((column.equals("gk_sohle") || column.equals("gk_ufer") || column.equals("gk_land") || column.equals("gk_gesamt")) && !this.checkRange(column, newValue, 0, 5, false, true, true)) {
            return oldValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("wk_nr")) {
            return new LinkTableCellRenderer();
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaFgskRuleSet.isValueEmpty(feature.getProperty("fgsk_id"))) {
                this.showMessage("Das Attribut fgsk_id darf nicht leer sein", "fgsk_id");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "fgsk_id");
            }
            if (FgBaFgskRuleSet.isValueEmpty(feature.getProperty("vorkart"))) {
                this.showMessage("Das Attribut vorkart darf nicht leer sein", "vorkart");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "vorkart");
            }
            if (!this.checkRange("gk_sohle", feature.getProperty("gk_sohle"), 0, 5, false, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "gk_sohle");
            }
            if (!this.checkRange("gk_ufer", feature.getProperty("gk_ufer"), 0, 5, false, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "gk_ufer");
            }
            if (!this.checkRange("gk_land", feature.getProperty("gk_land"), 0, 5, false, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "gk_land");
            }
            if (this.checkRange("gk_gesamt", feature.getProperty("gk_gesamt"), 0, 5, false, true, true)) continue;
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "gk_gesamt");
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return 5;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationLineCreator creator = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper());
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wk_nr") && value instanceof String && clickCount == 1) {
            FgBaFgskRuleSet.downloadDocumentFromWebDav(WK_FG_WEBDAV_PATH, FgBaFgskRuleSet.addExtension(value.toString().toUpperCase(), "pdf"));
        }
    }
}

