/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.reports.GewaesserReportAction;
import de.cismet.watergis.gui.dialog.GewaesserReportDialog;
import de.cismet.watergis.reports.GewaesserReport;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class FgBaRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(FgBaRuleSet.class);

    public FgBaRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(false, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("ba_gn", new WatergisDefaultRuleSet.Varchar(50, false));
        this.typeMap.put("wdm", new WatergisDefaultRuleSet.Numeric(4, 0, false));
        this.typeMap.put("gu_zust", new WatergisDefaultRuleSet.Varchar(2, false));
        this.typeMap.put("gu_cd", new WatergisDefaultRuleSet.Varchar(50, false));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return false;
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("ba_cd")) {
            return new LinkTableCellRenderer();
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("ba_cd") && value instanceof String && clickCount == 1) {
            this.createGuReport(value.toString());
        }
    }

    private void createGuReport(String bacd) {
        GewaesserReportAction action = new GewaesserReportAction();
        action.actionPerformed(null);
    }

    public static void createReport(final String bacd) {
        try {
            StaticSwingTools.showDialog((JDialog)GewaesserReportDialog.getInstance());
            if (!GewaesserReportDialog.getInstance().isCancelled()) {
                WaitingDialogThread<Boolean> wdt = new WaitingDialogThread<Boolean>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Steckbriefe", null, 100, true){

                    protected Boolean doInBackground() throws Exception {
                        GewaesserReport gr = new GewaesserReport();
                        gr.createReport(bacd);
                        gr.cleanup();
                        return true;
                    }

                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while performing the gewaesser report.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating gewaesser report", (Throwable)ex);
        }
    }
}

