/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.tools.BrowserLauncher;
import de.cismet.watergis.gui.actions.reports.WkFgReportAction;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class FgBakWkRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(FgBakWkRuleSet.class);
    private static final String URL_TEMPLATE = "https://fis-wasser-mv.de/charts/steckbriefe/rw/rw_wk.php?schema=reporting_bp3&fg=%1s";
    private static final String URL_TEMPLATE_BB = "https://mluk.brandenburg.de/w/Steckbriefe/WRRL2021/RWBODY/DERW_%1s.pdf";
    private static final String URL_TEMPLATE_NS = "https://geoportal.bafg.de/birt_viewer/frameset?__report=RW_WKSB_21P1.rptdesign&param_wasserkoerper=DERW_DENI_%1s&agreeToDisclaimer=true";
    private static final String URL_TEMPLATE_SH = "https://geoportal.bafg.de/birt_viewer/frameset?__report=RW_WKSB_21P1.rptdesign&param_wasserkoerper=DERW_DESH_%1s&agreeToDisclaimer=true";

    public FgBakWkRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("bak_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("bak_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("bak_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("wk_nr", new WatergisDefaultRuleSet.Catalogue("k_wk_fg", true, true, new WatergisDefaultRuleSet.Varchar(50, false, false)));
        this.typeMap.put("wk_fedfue", new WatergisDefaultRuleSet.Catalogue("k_wk_fg", false, false, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("wk_ordnung", new WatergisDefaultRuleSet.Numeric(1, 0, false, false));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("laenge_wk", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("laenge") && !columnName.equals("geom") && !columnName.equals("ba_cd") && !columnName.equals("id") && !columnName.equals("laenge_wk") && !columnName.equals("wk_fedfue") && !columnName.equals("wk_ordnung");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("wk_nr")) {
            return new LinkTableCellRenderer();
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("bak_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("bak_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("wk_nr")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("wk_nr");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
        try {
            this.refreshTemplate("RefreshRwSegGeom");
            this.refreshTemplate("RefreshEzgKrl");
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Cannot refresh templates", (Throwable)ex);
        }
        super.afterSave(model);
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -4;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak");
        StationLineCreator creator = new StationLineCreator("bak_st", routeMc, "Basisgew\u00e4sser/komplett (FG/k)", (LinearReferencingHelper)new LinearReferencingWatergisHelper());
        return creator;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wk_nr") && value instanceof String && clickCount == 1) {
            String urlTemplate = URL_TEMPLATE;
            String ff = (String)feature.getProperty("wk_fedfue");
            if (ff != null) {
                if (ff.equals("Brandenburg")) {
                    urlTemplate = URL_TEMPLATE_BB;
                } else if (ff.equals("Schleswig-Holstein")) {
                    urlTemplate = URL_TEMPLATE_SH;
                } else if (ff.equals("Niedersachsen")) {
                    urlTemplate = URL_TEMPLATE_NS;
                }
            }
            try {
                URL u = new URL(String.format(urlTemplate, value.toString()));
                try {
                    BrowserLauncher.openURL((String)u.toString());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Cannot open the url:" + u), (Throwable)ex);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public static void createReport(String bacd) {
        WkFgReportAction action = new WkFgReportAction();
        action.actionPerformed(null);
    }
}

