/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class GuWiweRuleSet
extends WatergisDefaultRuleSet {
    private static final HashMap<String, String[]> allowedMaterial = new HashMap();
    private final Logger LOG = Logger.getLogger(GuWiweRuleSet.class);
    private double lastLength = -1.0;

    public GuWiweRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", true, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("wiwe", new WatergisDefaultRuleSet.Catalogue("k_wiwe", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("laenge") && !columnName.equals("ba_cd") && !columnName.equals("geom") && !columnName.equals("obj_nr");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        String[] allowedMaterialArray;
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, GuWiweRuleSet.getCurrentYear(), 1800, GuWiweRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("br") && !this.checkRange(column, newValue, 0, 10, 0, 30, true, false, true)) {
            return oldValue;
        }
        if (newValue instanceof Geometry) {
            Geometry g = (Geometry)newValue;
            if (g.getLength() < 1.0 && g.getLength() != this.lastLength) {
                this.showMessage("Die L\u00e4nge der Geometry darf nicht kleiner als 1m sein.", column);
                return oldValue;
            }
            this.lastLength = g.getLength();
        }
        if (column.equals("wiwe") && newValue != null && !GuWiweRuleSet.isValueEmpty(feature.getProperty("material")) && (allowedMaterialArray = allowedMaterial.get(newValue.toString())) != null && (GuWiweRuleSet.isValueEmpty(feature.getProperty("material")) || !GuWiweRuleSet.arrayContains(allowedMaterialArray, feature.getProperty("material").toString()))) {
            this.showMessage("Wenn das Attribut wiwe = " + newValue.toString() + ", dann muss das Attribut material " + GuWiweRuleSet.arrayToString(allowedMaterialArray) + " sein.", column);
            return oldValue;
        }
        if (column.equals("material") && newValue != null && feature.getProperty("wiwe") != null && (allowedMaterialArray = allowedMaterial.get(feature.getProperty("wiwe").toString())) != null && (GuWiweRuleSet.isValueEmpty(newValue) || !GuWiweRuleSet.arrayContains(allowedMaterialArray, newValue.toString()))) {
            this.showMessage("Wenn das Attribut wiwe = " + feature.getProperty("wiwe").toString() + ", dann muss das Attribut material " + GuWiweRuleSet.arrayToString(allowedMaterialArray) + " sein.", column);
            return oldValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            CidsLayerReferencedComboEditor ed = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true));
            ed.setNullable(false);
            return ed;
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("wiwe")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("wiwe") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("material")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("wiwe");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("material") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            String[] allowedMaterialArray;
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (!this.checkRange("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, GuWiweRuleSet.getCurrentYear() + 2, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (!this.checkRange("br", feature.getProperty("br"), 0, 30, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br");
            }
            if (feature.getProperty("wiwe") == null || (allowedMaterialArray = allowedMaterial.get(feature.getProperty("wiwe").toString())) == null || !GuWiweRuleSet.isValueEmpty(feature.getProperty("material")) && GuWiweRuleSet.arrayContains(allowedMaterialArray, feature.getProperty("material").toString())) continue;
            this.showMessage("Wenn das Attribut wiwe = " + feature.getProperty("wiwe").toString() + ", dann muss das Attribut material " + GuWiweRuleSet.arrayToString(allowedMaterialArray) + " sein.", "material");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "material");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator creator = new PrimitiveGeometryCreator("LINESTRING", this.getDefaultValues());
        creator.setMinLength(0.01);
        return creator;
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        return properties;
    }

    @Override
    public FeatureServiceFeature cloneFeature(FeatureServiceFeature feature) {
        return super.cloneFeature(feature);
    }

    static {
        allowedMaterial.put("Decke", new String[]{"As", "B", "Kies", "Kies-wg", "Rec", "Rec-wg", "Sand", "Sand-wg", "Scho", "Scho-wg"});
        allowedMaterial.put("Decke-Pfl", new String[]{"B"});
        allowedMaterial.put("Decke-Pl", new String[]{"B"});
        allowedMaterial.put("Decke-Rg", new String[]{"B"});
        allowedMaterial.put("Spur", new String[]{"As", "B"});
        allowedMaterial.put("Spur-Pfl", new String[]{"B"});
        allowedMaterial.put("Spur-Pl", new String[]{"B"});
        allowedMaterial.put("Spur-Rg", new String[]{"B"});
    }
}

