/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class HaltungRuleSet
extends WatergisDefaultRuleSet {
    public HaltungRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("pk", new WatergisDefaultRuleSet.Varchar(100, false, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("gu_cd", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("anf_obj", new WatergisDefaultRuleSet.Numeric(10, 0, false, false));
        this.typeMap.put("end_obj", new WatergisDefaultRuleSet.Numeric(10, 0, false, false));
        this.typeMap.put("obj_reihf", new WatergisDefaultRuleSet.Varchar(30, false, false));
        this.typeMap.put("rl_mat", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("rl_br_dm", new WatergisDefaultRuleSet.Numeric(8, 3, false, false));
        this.typeMap.put("d_mat", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("d_br_dm", new WatergisDefaultRuleSet.Numeric(8, 3, false, false));
        this.typeMap.put("doc", new WatergisDefaultRuleSet.Document(false, true, "doc"));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return columnName.equals("bemerkung") || columnName.equals("doc");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return super.getCellEditor(columnName);
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -1;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        return null;
    }
}

