/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.table.TableModel;

public class LfkFbRuleSet
extends WatergisDefaultRuleSet {
    public LfkFbRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("fbid", new WatergisDefaultRuleSet.Varchar(16, false, true));
        this.typeMap.put("id", new WatergisDefaultRuleSet.Numeric(10, 0, false, true));
        this.typeMap.put("area_ha", new WatergisDefaultRuleSet.Numeric(12, 4, false, true));
        this.typeMap.put("bodennutzu", new WatergisDefaultRuleSet.Varchar(4, false, true));
        this.typeMap.put("groesse_p", new WatergisDefaultRuleSet.Numeric(12, 4, false, true));
        this.typeMap.put("dgl_jahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("erwind_cc", new WatergisDefaultRuleSet.Varchar(9, false, true));
        this.typeMap.put("erwater_cc", new WatergisDefaultRuleSet.Varchar(9, false, true));
        this.typeMap.put("oeko", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("oeko_ha", new WatergisDefaultRuleSet.Numeric(12, 4, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -1;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }
}

