/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MnGwPegelRuleSet
extends WatergisDefaultRuleSet {
    public MnGwPegelRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ms_nr", new WatergisDefaultRuleSet.Varchar(20, true, true));
        this.typeMap.put("ms_name", new WatergisDefaultRuleSet.Varchar(50, true, true));
        this.typeMap.put("re", new WatergisDefaultRuleSet.Numeric(11, 2, true, true));
        this.typeMap.put("ho", new WatergisDefaultRuleSet.Numeric(10, 2, true, true));
        this.typeMap.put("baujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("h_gel", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("h_mp", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("fl_von", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("fl_bis", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("pn", new WatergisDefaultRuleSet.Numeric(5, 0, true, true));
        this.typeMap.put("pn_von", new WatergisDefaultRuleSet.Varchar(10, false, true));
        this.typeMap.put("pn_bis", new WatergisDefaultRuleSet.Varchar(10, false, true));
        this.typeMap.put("pn_von_h", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("pn_bis_h", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature f : features) {
            this.idOfCurrentlyCheckedFeature = f.getId();
            if (!MnGwPegelRuleSet.isNumberOrNull(f.getProperty("pn")) || f.getProperty("pn") == null) continue;
            if (((Number)f.getProperty("pn")).intValue() == 0) {
                if (f.getProperty("pn_von") == null && f.getProperty("pn_bis") == null && f.getProperty("pn_von_h") == null && f.getProperty("pn_bis_h") == null) continue;
                this.showMessage("Die Attribute  pn_von / pn_bis / pn_von_h / pn_bis_h m\u00fcssen NULL sein, wenn pn = 0.", "pn_von / pn_bis / pn_von_h / pn_bis_h");
                if (f.getProperty("pn_von") != null) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(f, "pn_von");
                }
                if (f.getProperty("pn_bis") != null) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(f, "pn_bis");
                }
                if (f.getProperty("pn_von_h") != null) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(f, "pn_von_h");
                }
                return new AttributeTableExtendedRuleSet.ErrorDetails(f, "pn_bis_h");
            }
            if (f.getProperty("pn") == null || ((Number)f.getProperty("pn")).intValue() <= 0 || !MnGwPegelRuleSet.isValueEmpty(f.getProperty("pn_von")) && !MnGwPegelRuleSet.isValueEmpty(f.getProperty("pn_bis")) && !MnGwPegelRuleSet.isValueEmpty(f.getProperty("pn_von_h")) && !MnGwPegelRuleSet.isValueEmpty(f.getProperty("pn_bis_h"))) continue;
            this.showMessage("Die Attribute  pn_von / pn_bis / pn_von_h / pn_bis_h d\u00fcrfen nicht NULL sein, wenn pn > 0.", "pn_von / pn_bis / pn_von_h / pn_bis_h");
            if (MnGwPegelRuleSet.isValueEmpty(f.getProperty("pn_von"))) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(f, "pn_von");
            }
            if (MnGwPegelRuleSet.isValueEmpty(f.getProperty("pn_bis"))) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(f, "pn_bis");
            }
            if (MnGwPegelRuleSet.isValueEmpty(f.getProperty("pn_von_h"))) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(f, "pn_von_h");
            }
            return new AttributeTableExtendedRuleSet.ErrorDetails(f, "pn_bis_h");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        return new PrimitiveGeometryCreator("POINT");
    }
}

