/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class QpModellRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(QpModellRuleSet.class);
    private static final String[] ALLOWED_PRIO_VALUES = new String[]{"\u00fc", "sehr hoch", "hoch", "moderat"};
    private static final String[] ALLOWED_M_DIM_VALUES = new String[]{"1D", "2D", "3D", "1D/2D", "1D/3D", "2D/3D", "1D/2D/3D"};
    private static final String[] ALLOWED_BOOL_VALUES = new String[]{"-", "x"};
    private static final String[] ALLOWED_M_TIME_VALUES = new String[]{"instation\u00e4r", "station\u00e4r"};

    public QpModellRuleSet() {
        this.minLaLength = 10.0;
        this.maxLaLength = 999999.0;
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("la_cd", new WatergisDefaultRuleSet.Numeric(15, 0, true, false));
        this.typeMap.put("la_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("la_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("la_cd_k", new WatergisDefaultRuleSet.Numeric(15, 0, false, false));
        this.typeMap.put("la_gn", new WatergisDefaultRuleSet.Varchar(75, true, false));
        this.typeMap.put("m_traeger", new WatergisDefaultRuleSet.Catalogue("k_m_traeger", false, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, true));
        this.typeMap.put("abschnitt", new WatergisDefaultRuleSet.Varchar(100, true, false));
        this.typeMap.put("jahr", new WatergisDefaultRuleSet.Varchar(20, false, false));
        this.typeMap.put("m_plan", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("m_ergeb", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("m_kosten", new WatergisDefaultRuleSet.Numeric(6, 2, false, false, 1.0, 9999.0));
        this.typeMap.put("suchraum", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("prio", new WatergisDefaultRuleSet.Catalogue("k_prio", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("m_obsolet", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("m_software", new WatergisDefaultRuleSet.Varchar(20, false, true));
        this.typeMap.put("m_exist", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("m_dim", new WatergisDefaultRuleSet.Catalogue("k_m_dim", false, true, new WatergisDefaultRuleSet.Varchar(20, false, false)));
        this.typeMap.put("m_time", new WatergisDefaultRuleSet.Catalogue("k_m_time", false, true, new WatergisDefaultRuleSet.Varchar(20, false, false)));
        this.typeMap.put("flood_area", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("m_hw_hq10", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("m_hw_hq100", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("m_hw_hq200", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("m_mnq", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("m_mq", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("m_q330", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("m_mhq", new WatergisDefaultRuleSet.Catalogue("k_geschehen", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("ba_gn", new WatergisDefaultRuleSet.Varchar(100, false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("id") && !columnName.equals("la_cd") && !columnName.equals("la_cd_k") && !columnName.equals("la_gn") && !columnName.equals("obj_nr") && !columnName.equals("laenge") && !columnName.equals("ww_gr");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("m_traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("m_traeger", String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("traeger");
                }
            });
            return editor;
        }
        if (columnName.equals("prio")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("prio", String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("prio");
                }
            });
            return editor;
        }
        if (columnName.equals("m_dim")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("m_dim", String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("dim");
                }
            });
            return editor;
        }
        if (columnName.equals("m_time")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("m_time", String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("time");
                }
            });
            return editor;
        }
        if (columnName.equals("m_obsolet") || columnName.equals("flood_area") || columnName.equals("m_hw_hq10") || columnName.equals("m_hw_hq100") || columnName.equals("m_hw_hq200") || columnName.equals("m_mnq") || columnName.equals("m_mq") || columnName.equals("m_q330") || columnName.equals("m_mhq") || columnName.equals("m_exist")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("geschehen");
                }
            });
            return editor;
        }
        if (columnName.equals("la_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("la_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("LINESTRING", true);
        return c;
    }
}

