/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.commons.security.WebDavClient;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.panels.Photo;
import de.cismet.watergis.profile.QpNplDownload;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.FeatureServiceHelper;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class QpNplRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(QpNplRuleSet.class);
    private static final String[] ALLOWED_CALC_VALUES = new String[]{"calc"};

    public QpNplRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("la_cd", new WatergisDefaultRuleSet.Numeric(15, 0, true, false));
        this.typeMap.put("la_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("stat", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("re", new WatergisDefaultRuleSet.Numeric(11, 2, false, false));
        this.typeMap.put("ho", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("qp_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("qp_hist", new WatergisDefaultRuleSet.Catalogue("k_hist", false, true, new WatergisDefaultRuleSet.Varchar(1, false, false)));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("l_bezug", new WatergisDefaultRuleSet.Catalogue("k_l_bezug", false, true, new WatergisDefaultRuleSet.Numeric(5, 0, false, false)));
        this.typeMap.put("h_bezug", new WatergisDefaultRuleSet.Catalogue("k_h_bezug", false, true, new WatergisDefaultRuleSet.Numeric(5, 0, false, false)));
        this.typeMap.put("l_calc", new WatergisDefaultRuleSet.Varchar(4, false, false, ALLOWED_CALC_VALUES));
        this.typeMap.put("upl_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("upl_name", new WatergisDefaultRuleSet.Varchar(50, true, false));
        this.typeMap.put("upl_datum", new WatergisDefaultRuleSet.Varchar(10, true, false));
        this.typeMap.put("upl_zeit", new WatergisDefaultRuleSet.Varchar(8, true, false));
        this.typeMap.put("aufn_name", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("aufn_datum", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("aufn_zeit", new WatergisDefaultRuleSet.Varchar(8, false, false));
        this.typeMap.put("freigabe", new WatergisDefaultRuleSet.Catalogue("k_freigabe", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("titel", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("beschreib", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return columnName.equalsIgnoreCase("bemerkung") || columnName.equalsIgnoreCase("qp_hist");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("qp_nr")) {
            return new LinkTableCellRenderer(4);
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("qp_hist")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("qp_hist", String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("hist");
                }
            });
            return editor;
        }
        return super.getCellEditor(columnName);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
        this.reloadService("qp_pkte");
    }

    public FeatureCreator getFeatureCreator() {
        return null;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("qp_nr") && value instanceof Integer && clickCount == 1 && feature instanceof CidsLayerFeature && DownloadManagerDialog.showAskingForUserTitle((Component)AppBroker.getInstance().getRootWindow())) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            ArrayList<FeatureServiceFeature> features = new ArrayList<FeatureServiceFeature>();
            features.add(feature);
            WebDavClient webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), Photo.WEB_DAV_USER, Photo.WEB_DAV_PASSWORD, true);
            File f = new File(DownloadManager.instance().getDestinationDirectory(), jobname);
            DownloadManager.instance().add((Download)new QpNplDownload(webDavClient, f.getAbsolutePath(), "Download Profil", features));
        }
    }

    public boolean hasCustomExportFeaturesMethod() {
        return true;
    }

    public void exportFeatures() {
        try {
            List<AbstractFeatureService> services;
            List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp_npl");
            if ((features == null || features.isEmpty()) && (services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp_npl")) != null && !services.isEmpty()) {
                features = FeatureServiceHelper.getFeatures(services.get(0), false);
            }
            if (features == null || features.isEmpty()) {
                LOG.warn((Object)"No qp_npl objects found to create qp_npl export");
            }
            if (!features.isEmpty() && DownloadManagerDialog.showAskingForUserTitle((Component)AppBroker.getInstance().getRootWindow())) {
                String jobname = DownloadManagerDialog.getInstance().getJobName();
                WebDavClient webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), Photo.WEB_DAV_USER, Photo.WEB_DAV_PASSWORD, true);
                File f = new File(DownloadManager.instance().getDestinationDirectory(), jobname);
                DownloadManager.instance().add((Download)new QpNplDownload(webDavClient, f.getAbsolutePath(), "Download NPL", features));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating qp_npl export", (Throwable)e);
        }
    }
}

