/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.DateCellEditor;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.SimpleAttributeTableModel;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.RouteTableCellEditor;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.gaf.ReportAction;
import de.cismet.watergis.gui.panels.GafProf;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class QpRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(QpRuleSet.class);
    public static final BufferedImage ARROW;
    public static final BufferedImage SELECTED_ARROW;

    public QpRuleSet() {
        WatergisDefaultRuleSet.DateType date = new WatergisDefaultRuleSet.DateType(false, true);
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", true, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("la_cd", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("la_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("re", new WatergisDefaultRuleSet.Numeric(11, 2, true, false));
        this.typeMap.put("ho", new WatergisDefaultRuleSet.Numeric(10, 2, true, false));
        this.typeMap.put("qp_nr", new WatergisDefaultRuleSet.Numeric(20, 0, true, false));
        this.typeMap.put("upl_name", new WatergisDefaultRuleSet.Varchar(50, true, false));
        this.typeMap.put("upl_datum", new WatergisDefaultRuleSet.Varchar(10, true, false));
        this.typeMap.put("upl_zeit", new WatergisDefaultRuleSet.Varchar(8, true, false));
        this.typeMap.put("aufn_name", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("aufn_datum", date);
        this.typeMap.put("aufn_zeit", new WatergisDefaultRuleSet.Time(false, true));
        this.typeMap.put("freigabe", new WatergisDefaultRuleSet.Catalogue("k_freigabe", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("titel", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("beschreib", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        if (columnName.equals("ww_gr")) {
            return AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren");
        }
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("id") && !columnName.equals("ho") && !columnName.equals("re") && !columnName.equals("qp_nr") && !columnName.equals("la_st") && !columnName.equals("la_cd") && !columnName.equals("upl_name") && !columnName.equals("upl_datum") && !columnName.equals("upl_zeit") && !columnName.equals("ba_cd") && !columnName.equals("ba_st");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (column.equals("aufn_datum") && newValue != null && newValue instanceof Date) {
            Date d = (Date)newValue;
            if (d.getYear() < 0 || d.after(new Date())) {
                this.showMessage("Es sind nur Datumseingaben zwischen dem 01.01.1900 und heute erlaubt", column);
                return oldValue;
            }
            if (d.getYear() >= 0 && d.getYear() < 50 && !this.showSecurityQuestion("Wert au\u00dferhalb Standardbereich (01.01.1950 .. heute) --> verwenden ?", column, newValue)) {
                return oldValue;
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("qp_nr")) {
            return new LinkTableCellRenderer(4);
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_cd")) {
            RouteTableCellEditor editor = new RouteTableCellEditor("dlm25w.fg_ba", "ba_st", false);
            String filterString = this.getRouteFilter();
            if (filterString != null) {
                editor.setRouteQuery(filterString);
            }
            return editor;
        }
        if (columnName.equals("ba_st")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("freigabe")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("freigabe") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("ba_st")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("aufn_datum")) {
            return new DateCellEditor();
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
        List removedFeatures;
        if (model instanceof SimpleAttributeTableModel && (removedFeatures = ((SimpleAttributeTableModel)model).getRemovedFeature()) != null && !removedFeatures.isEmpty()) {
            ArrayList<Feature> selectedFeaturesToRemove = new ArrayList<Feature>();
            for (FeatureServiceFeature feature : removedFeatures) {
                List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures();
                for (Feature f : selectedFeatures) {
                    Integer deletedFeatureBaCd;
                    Integer selectedFeatureBaCd;
                    CidsLayerFeature clf;
                    if (!(f instanceof CidsLayerFeature) || (clf = (CidsLayerFeature)f).getProperty("qp_nr") == null || feature.getProperty("qp_nr") == null || !(selectedFeatureBaCd = (Integer)clf.getProperty("qp_nr")).equals(deletedFeatureBaCd = (Integer)feature.getProperty("qp_nr"))) continue;
                    selectedFeaturesToRemove.add(f);
                }
            }
            if (!selectedFeaturesToRemove.isEmpty()) {
                SelectionManager.getInstance().removeSelectedFeatures(selectedFeaturesToRemove);
            }
        }
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"re", "ho"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("re")) {
            return 8;
        }
        if (name.equals("ho")) {
            return 9;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = feature.getGeometry();
        if (geom instanceof Point) {
            if (propertyName.equals("re")) {
                value = ((Point)geom).getX();
            } else if (propertyName.equals("ho")) {
                value = ((Point)geom).getY();
            }
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("re")) {
            return "st_x(geom)";
        }
        if (propertyName.equals("ho")) {
            return "st_y(geom)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        return null;
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (AppBroker.getInstance().getOwnWwGr() != null) {
            properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        } else {
            properties.put("ww_gr", AppBroker.getInstance().getNiemandWwGr());
        }
        return properties;
    }

    public boolean isCatThree() {
        return true;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("qp_nr") && value instanceof Integer && clickCount == 1 && feature instanceof CidsLayerFeature) {
            ReportAction action = new ReportAction();
            action.actionPerformed(null);
        }
    }

    public FeatureAnnotationSymbol getPointAnnotationSymbol(FeatureServiceFeature feature) {
        FeatureAnnotationSymbol symb = GafProf.selectedFeature != null && GafProf.selectedFeature.getId() == feature.getId() ? new FeatureAnnotationSymbol((Image)SELECTED_ARROW) : new FeatureAnnotationSymbol((Image)ARROW);
        symb.setSweetSpotX(0.5);
        symb.setSweetSpotY(0.5);
        return symb;
    }

    public boolean hasCustomExportFeaturesMethod() {
        return true;
    }

    public void exportFeatures() {
        AppBroker.getInstance().getGafExport().actionPerformed(null);
    }

    public boolean hasCustomPrintFeaturesMethod() {
        return true;
    }

    public void printFeatures() {
        AppBroker.getInstance().getGafPrint().actionPerformed(null);
    }

    static {
        try {
            URL arrowUrl = QpRuleSet.class.getResource("/de/cismet/watergis/res/icons16/angle.png");
            ARROW = ImageIO.read(arrowUrl);
            URL arrowSelectedUrl = QpRuleSet.class.getResource("/de/cismet/watergis/res/icons16/angleSelected.png");
            SELECTED_ARROW = ImageIO.read(arrowSelectedUrl);
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

