/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.DateCellEditor;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.FormattedTextCellEditor;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.commons.security.WebDavClient;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.panels.Photo;
import de.cismet.watergis.profile.QpUplDownload;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.awt.Component;
import java.io.File;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class QpUplRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(QpUplRuleSet.class);
    private static final String[] ALLOWED_CALC_VALUES = new String[]{"calc", "-"};

    public QpUplRuleSet() {
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", true, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_hyk", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("l_bezug", new WatergisDefaultRuleSet.Catalogue("k_l_bezug", false, true, new WatergisDefaultRuleSet.Numeric(5, 0, false, false)));
        this.typeMap.put("h_bezug", new WatergisDefaultRuleSet.Catalogue("k_h_bezug", false, true, new WatergisDefaultRuleSet.Numeric(5, 0, false, false)));
        this.typeMap.put("l_calc", new WatergisDefaultRuleSet.Varchar(4, false, false, ALLOWED_CALC_VALUES));
        this.typeMap.put("upl_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("upl_name", new WatergisDefaultRuleSet.Varchar(50, true, false));
        this.typeMap.put("upl_datum", new WatergisDefaultRuleSet.Varchar(10, true, false));
        this.typeMap.put("upl_zeit", new WatergisDefaultRuleSet.Varchar(8, true, false));
        this.typeMap.put("aufn_name", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("aufn_datum", new WatergisDefaultRuleSet.DateType(false, true));
        this.typeMap.put("aufn_zeit", new WatergisDefaultRuleSet.Varchar(8, false, false));
        this.typeMap.put("freigabe", new WatergisDefaultRuleSet.Catalogue("k_freigabe", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("titel", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("beschreib", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("upl_name") && !columnName.equals("upl_datum") && !columnName.equals("upl_zeit") && !columnName.equals("upl_nr") && !columnName.equals("l_bezug") && !columnName.equals("h_bezug") && !columnName.equals("l_calc");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (!this.isUploader(feature)) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Das Attribut " + column + " darf nur von Uploader ge\u00e4ndert werden");
            return oldValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    public void afterSave(TableModel model) {
        this.reloadService("qp_npl");
        this.reloadService("qp_pkte");
    }

    private boolean isUploader(FeatureServiceFeature feature) {
        return SessionManager.getSession().getUser().getUserGroup().getName().equalsIgnoreCase("administratoren") || feature.getProperty("upl_name").equals(SessionManager.getSession().getUser().getName());
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("upl_nr")) {
            return new LinkTableCellRenderer(4);
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = new CidsLayerFeatureFilter(){

                public boolean accept(CidsLayerFeature bean) {
                    if (bean == null) {
                        return true;
                    }
                    return bean.getProperty("qp") != null && (Boolean)bean.getProperty("qp") != false;
                }
            };
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("l_st", String.valueOf(12), true), filter);
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("l_st");
                }
            });
            return editor;
        }
        if (columnName.equals("l_bezug")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("l_bezug", String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("l_bezug");
                }
            });
            return editor;
        }
        if (columnName.equals("h_bezug")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("h_bezug", String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("h_bezug");
                }
            });
            return editor;
        }
        if (columnName.equals("freigabe")) {
            CidsLayerFeatureFilter filter = new CidsLayerFeatureFilter(){

                public boolean accept(CidsLayerFeature bean) {
                    if (bean == null) {
                        return true;
                    }
                    return bean.getProperty("qp") != null && (Boolean)bean.getProperty("qp") != false;
                }
            };
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("freigabe", String.valueOf(12), true), filter);
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("freigabe");
                }
            });
            return editor;
        }
        if (columnName.equals("aufn_datum")) {
            return new DateCellEditor();
        }
        if (columnName.equals("aufn_zeit")) {
            return new FormattedTextCellEditor((Format)new WatergisDefaultRuleSet.TimeFormatter());
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public FeatureCreator getFeatureCreator() {
        return null;
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        return properties;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("upl_nr") && value instanceof Integer && clickCount == 1 && feature instanceof CidsLayerFeature && DownloadManagerDialog.showAskingForUserTitle((Component)AppBroker.getInstance().getRootWindow())) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            ArrayList<FeatureServiceFeature> features = new ArrayList<FeatureServiceFeature>();
            features.add(feature);
            WebDavClient webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), Photo.WEB_DAV_USER, Photo.WEB_DAV_PASSWORD, true);
            File f = new File(DownloadManager.instance().getDestinationDirectory(), jobname);
            DownloadManager.instance().add((Download)new QpUplDownload(webDavClient, f.getAbsolutePath(), "Download Profil", features));
        }
    }

    public boolean hasCustomExportFeaturesMethod() {
        return true;
    }

    public void exportFeatures() {
        AppBroker.getInstance().getGafExport().actionPerformed(null);
    }
}

