/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SgSeeEffLbRuleSet
extends WatergisDefaultRuleSet {
    public SgSeeEffLbRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("see_sp", new WatergisDefaultRuleSet.Varchar(8, true, true));
        this.typeMap.put("distanz", new WatergisDefaultRuleSet.Numeric(10, 2, true, false));
        this.typeMap.put("winkel", new WatergisDefaultRuleSet.Numeric(5, 1, true, true));
        this.typeMap.put("typ", new WatergisDefaultRuleSet.Varchar(1, true, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("distanz") && !columnName.equals("id");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return super.getCellEditor(columnName);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"distanz"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("distanz")) {
            return -5;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator creator = new PrimitiveGeometryCreator("LINESTRING");
        creator.setMinLength(0.01);
        return creator;
    }
}

