/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.watergis.broker.AppBroker;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SonstHwEnFRuleSet
extends WatergisDefaultRuleSet {
    public SonstHwEnFRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("nr", new WatergisDefaultRuleSet.Numeric(16, 0, false, true));
        this.typeMap.put("wann", new WatergisDefaultRuleSet.Varchar(16, false, false));
        this.typeMap.put("wer", new WatergisDefaultRuleSet.Varchar(250, true, true));
        this.typeMap.put("firma", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("vorwahl", new WatergisDefaultRuleSet.Varchar(10, false, true));
        this.typeMap.put("nummer", new WatergisDefaultRuleSet.Varchar(20, false, true));
        this.typeMap.put("mail", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("text", new WatergisDefaultRuleSet.Varchar(250, true, true));
        this.typeMap.put("gewaesser", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("station", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("koord_rw", new WatergisDefaultRuleSet.Numeric(11, 2, false, true));
        this.typeMap.put("koord_hw", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("bearb_wann", new WatergisDefaultRuleSet.Varchar(16, false, true));
        this.typeMap.put("bearb_wer", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("bearb_komm", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        if (columnName.equals("ww_gr")) {
            return AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren");
        }
        if (columnName.equals("bearb_wann") || columnName.equals("bearb_wer") || columnName.equals("bearb_komm")) {
            return SessionManager.getSession().getUser().getUserGroup().getName().equalsIgnoreCase("Administratoren");
        }
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("nr") && !columnName.equals("wann") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            Object filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature feature) {
                        return feature != null;
                    }
                };
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), filter);
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (!SonstHwEnFRuleSet.isValueEmpty(feature.getProperty("mail")) || !SonstHwEnFRuleSet.isValueEmpty(feature.getProperty("vorwahl")) && !SonstHwEnFRuleSet.isValueEmpty(feature.getProperty("nummer"))) continue;
            this.showMessage("Es muss immer entweder das Mail-Feld oder das Vorwahl- und Nummer-Feld gesetzt sein.", "mail");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "mail");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        HashMap<String, String> properties = new HashMap<String, String>();
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        properties.put("wann", formatter.format(new Date()));
        if (AppBroker.getInstance().getOwnWwGr() != null) {
            properties.put("ww_gr", (String)AppBroker.getInstance().getOwnWwGr());
        } else {
            properties.put("ww_gr", (String)AppBroker.getInstance().getNiemandWwGr());
        }
        PrimitiveGeometryCreator creator = new PrimitiveGeometryCreator("POLYGON", properties);
        creator.setMinArea(1.0E-4);
        return creator;
    }
}

