/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class VwAlkGmdRuleSet
extends WatergisDefaultRuleSet {
    public VwAlkGmdRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("gmd_nr", new WatergisDefaultRuleSet.Numeric(8, 0, true, true, "gmd_nr", "vw_alk_gmd"));
        this.typeMap.put("gmd_name", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("amt_nr", new WatergisDefaultRuleSet.Numeric(4, 0, true));
        this.typeMap.put("amt_name", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("kreis_nr", new WatergisDefaultRuleSet.Numeric(5, 0, true));
        this.typeMap.put("kreis_name", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("gmd_fl", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("gmd_wbv_01", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_02", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_04", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_05", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_06", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_07", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_08", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_09", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_10", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_11", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_12", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_13", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_14", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_15", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_16", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_17", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_18", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_19", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_20", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_22", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_23", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_24", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_25", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_27", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_28", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_30", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("gmd_wbv_31", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if ((column.equals("gmd_nr") || column.equals("kreis_nr") || column.equals("amt_nr")) && newValue instanceof String) {
            try {
                newValue = Integer.parseInt((String)newValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("gmd_fl") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("kreis_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        if (columnName.equals("amt_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        if (columnName.equals("gmd_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"gmd_fl"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("gmd_fl")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("gmd_fl")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }
}

