/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WhgRuleSet
extends WatergisDefaultRuleSet {
    public WhgRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("fb_id", new WatergisDefaultRuleSet.Numeric(12, 0, true));
        this.typeMap.put("bokq_fg_id", new WatergisDefaultRuleSet.Numeric(12, 0, true));
        this.typeMap.put("bokq_see_id", new WatergisDefaultRuleSet.Numeric(12, 0, true));
        this.typeMap.put("hn", new WatergisDefaultRuleSet.Numeric(5, 2, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(5, 0, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return false;
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return super.getCellEditor(columnName);
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }
}

