/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.tools.BrowserLauncher;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class WrSgWsgInternRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(WrSgWsgInternRuleSet.class);

    public WrSgWsgInternRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("kopplung", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zone", new WatergisDefaultRuleSet.Varchar(3, false, true));
        this.typeMap.put("wsg_zone", new WatergisDefaultRuleSet.Varchar(4, false, true));
        this.typeMap.put("wsg_nr", new WatergisDefaultRuleSet.Varchar(14, false, true));
        this.typeMap.put("wsg_name", new WatergisDefaultRuleSet.Varchar(75, false, true));
        this.typeMap.put("kreisalt", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("kreisneu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("beschlussn", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("beschlussd", new WatergisDefaultRuleSet.Varchar(12, false, true));
        this.typeMap.put("beschlusn2", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("beschlusd2", new WatergisDefaultRuleSet.Varchar(12, false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(WrSgWsgInternRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("pruef_uwb", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("pruef_alk", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("src_erfass", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("src_quelle", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("recht", new WatergisDefaultRuleSet.Link(250, false, true));
        this.typeMap.put("info", new WatergisDefaultRuleSet.Link(250, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("uk", new WatergisDefaultRuleSet.Numeric(2, 0, false, true));
        this.typeMap.put("lk", new WatergisDefaultRuleSet.Numeric(2, 0, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("flaeche") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("info") || columnName.equals("recht")) {
            return new LinkTableCellRenderer();
        }
        if (columnName.equals("uk") || columnName.equals("lk")) {
            return new LinkTableCellRenderer(4);
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("recht") || columnName.equals("info")) {
            if (value instanceof String && clickCount == 1) {
                try {
                    URL u = new URL(value.toString());
                    try {
                        BrowserLauncher.openURL((String)u.toString());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Cannot open the url:" + u), (Throwable)ex);
                    }
                }
                catch (MalformedURLException u) {}
            }
        } else if (columnName.equals("uk") || columnName.equals("lk")) {
            Object wbbl = feature.getProperty("wbbl");
            if (value instanceof String && !value.equals("") && wbbl instanceof String && !wbbl.equals("") && clickCount == 1) {
                String linkBase = columnName.equals("uk") ? "https://files.cismet.de/remote.php/webdav/watergis/watergis/wr_sg_wsg_uk/" : "https://files.cismet.de/remote.php/webdav/watergis/watergis/wr_sg_wsg_lk/";
                String linkExt = columnName.equals("uk") ? "_uk" : "_lk";
                WrSgWsgInternRuleSet.downloadDocumentFromWebDav(linkBase, wbbl.toString() + linkExt + ".zip");
            }
        } else if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            WrSgWsgInternRuleSet.downloadDocumentFromWebDav(WrSgWsgInternRuleSet.getWbblPath(), WrSgWsgInternRuleSet.addExtension(value.toString(), "pdf"));
        }
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -5;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }
}

