/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.download;

import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class ImageDownload
extends AbstractDownload
implements Cancellable {
    private static final Logger LOG = Logger.getLogger(ImageDownload.class);
    String extension;
    Future<Image> futureImage;

    public ImageDownload(String filename, String extension, File fileToSaveTo, Future<Image> futureImage) {
        this.extension = extension;
        this.futureImage = futureImage;
        this.title = NbBundle.getMessage(ImageDownload.class, (String)"ImageDownload.title");
        this.status = Download.State.WAITING;
        this.fileToSaveTo = fileToSaveTo;
    }

    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        Image image = null;
        if (this.futureImage != null) {
            try {
                if (!Thread.interrupted()) {
                    image = this.futureImage.get();
                } else {
                    this.deleteFile();
                }
            }
            catch (InterruptedException ex) {
                this.deleteFile();
                return;
            }
            catch (ExecutionException ex) {
                LOG.error((Object)"Error while getting the image.", (Throwable)ex);
                this.status = Download.State.COMPLETED_WITH_ERROR;
                this.stateChanged();
                this.deleteFile();
                return;
            }
        }
        if (image != null && !Thread.interrupted()) {
            try {
                ImageIO.write((RenderedImage)this.removeTransparency(image), this.extension, this.fileToSaveTo);
            }
            catch (IOException ex) {
                LOG.error((Object)"Error while saving the image", (Throwable)ex);
                this.status = Download.State.COMPLETED_WITH_ERROR;
                this.stateChanged();
                this.deleteFile();
                return;
            }
        } else {
            this.status = Download.State.COMPLETED_WITH_ERROR;
            this.stateChanged();
            this.deleteFile();
            return;
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage removeTransparency(Image transparentImage) {
        BufferedImage whiteBackgroundImage = new BufferedImage(transparentImage.getWidth(null), transparentImage.getHeight(null), 1);
        Graphics2D g2 = null;
        try {
            g2 = whiteBackgroundImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, whiteBackgroundImage.getWidth(), whiteBackgroundImage.getHeight());
            g2.drawImage(transparentImage, 0, 0, whiteBackgroundImage.getWidth(), whiteBackgroundImage.getHeight(), null);
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
        return whiteBackgroundImage;
    }

    public boolean cancel() {
        boolean cancelled = true;
        if (this.downloadFuture != null) {
            cancelled = this.downloadFuture.cancel(true);
        }
        if (cancelled) {
            this.status = Download.State.ABORTED;
            this.stateChanged();
        }
        return cancelled;
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.extension != null ? this.extension.hashCode() : 0);
        hash = 37 * hash + (this.futureImage != null ? this.futureImage.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ImageDownload other = (ImageDownload)((Object)obj);
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        return this.futureImage == other.futureImage || this.futureImage != null && this.futureImage.equals(other.futureImage);
    }
}

