/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.watergis.gui.GafInfoPHandle;
import de.cismet.watergis.gui.dialog.GafOptionsDialog;
import de.cismet.watergis.gui.panels.GafProfEditor;
import de.cismet.watergis.profile.WPROFReader;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GafInfoPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(GafInfoPanel.class);
    private static CidsLayer ppLayer = null;
    private static final int IMAGE_HEIGHT = 200;
    private static final int IMAGE_WIDTH = 400;
    private CidsLayerFeature feature;
    private List<DefaultFeatureServiceFeature> gafFeatures;
    private Timer timer;
    private ImageResizeWorker currentResizeWorker;
    private Dimension lastDims;
    private GafInfoPHandle handle;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel labImage;
    private JLabel labTime;
    private JXBusyLabel lblBusy;
    private JPanel panData;
    private JPanel panImage;

    public GafInfoPanel(GafInfoPHandle handle) {
        this.handle = handle;
        this.initComponents();
        this.panImage.setSize(GafOptionsDialog.getInstance().getImageSize());
        this.timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GafInfoPanel.this.currentResizeWorker != null) {
                    GafInfoPanel.this.currentResizeWorker.cancel(true);
                }
                GafInfoPanel.this.currentResizeWorker = new ImageResizeWorker();
                CismetConcurrency.getInstance((String)"qp").getDefaultExecutor().execute(GafInfoPanel.this.currentResizeWorker);
            }
        });
        this.timer.setRepeats(false);
    }

    private void initComponents() {
        this.panImage = new JPanel();
        this.labImage = new JLabel();
        this.lblBusy = new JXBusyLabel(new Dimension(75, 75));
        this.panData = new JPanel();
        this.labTime = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.panImage.setMinimumSize(new Dimension(300, 300));
        this.panImage.setPreferredSize(new Dimension(300, 300));
        this.panImage.setLayout(new CardLayout());
        this.labImage.setHorizontalAlignment(0);
        this.panImage.add((Component)this.labImage, "image");
        this.lblBusy.setHorizontalAlignment(0);
        this.lblBusy.setMaximumSize(new Dimension(140, 40));
        this.lblBusy.setMinimumSize(new Dimension(140, 40));
        this.lblBusy.setPreferredSize(new Dimension(140, 40));
        this.panImage.add((Component)this.lblBusy, "busy");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panImage, gridBagConstraints);
        this.panData.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTime, (String)NbBundle.getMessage(GafInfoPanel.class, (String)"GafInfoPanel.labTime.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panData.add((Component)this.labTime, gridBagConstraints);
        this.jPanel1.setMaximumSize(new Dimension(250, 32));
        this.jPanel1.setPreferredSize(new Dimension(250, 32));
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GafInfoPanel.class, (String)"GafInfoPanel.jLabel1.text", (Object[])new Object[0]));
        this.jPanel1.add((Component)this.jLabel1, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panData.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.panData, gridBagConstraints);
    }

    public CidsLayerFeature getFeature() {
        return this.feature;
    }

    public void setImageSize() {
        this.setSize(GafOptionsDialog.getInstance().getImageSize());
        this.setFeature(null);
    }

    public void setFeature(CidsLayerFeature feature) {
        if (feature != null && this.feature != feature) {
            this.feature = feature;
            this.jLabel1.setText("<html>" + this.obj2String(feature.getProperty("titel")) + "</html>");
            this.labTime.setText(GafInfoPanel.dateTime2String(feature.getProperty("aufn_datum"), (String)feature.getProperty("aufn_zeit")));
            this.loadFoto();
        } else {
            this.feature = feature;
        }
    }

    private String obj2String(Object o) {
        if (o == null) {
            return "";
        }
        return String.valueOf(o);
    }

    private String obj2Time(Object o) {
        if (o == null) {
            return "";
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            return format.format(o);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Not a date", (Throwable)e);
            return "";
        }
    }

    private static String dateTime2String(Object date, String time) {
        if (date == null && time == null) {
            return "";
        }
        if (date == null) {
            return time;
        }
        if (time == null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                return format.format(date);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Not a date", (Throwable)e);
                return "";
            }
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            return format.format(date) + " " + time;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Not a date", (Throwable)e);
            return "";
        }
    }

    private void loadFoto() {
        Object qpNr = this.feature.getProperty("qp_nr");
        boolean cacheHit = false;
        if (qpNr != null) {
            List<DefaultFeatureServiceFeature> features;
            SoftReference<List<DefaultFeatureServiceFeature>> cachedImageRef = GafProfEditor.FEATURE_CACHE.get(qpNr);
            if (cachedImageRef != null && (features = cachedImageRef.get()) != null) {
                cacheHit = true;
                this.gafFeatures = features;
                this.showWait(true);
                this.timer.restart();
            }
            if (!cacheHit) {
                CismetConcurrency.getInstance((String)"qp").getDefaultExecutor().execute(new LoadImageWorker(qpNr));
            }
        }
    }

    private void indicateError(String error) {
        this.labImage.setToolTipText(error);
    }

    private void showWait(boolean wait) {
        if (wait) {
            if (!this.lblBusy.isBusy()) {
                CardLayout cardLayout = (CardLayout)this.panImage.getLayout();
                cardLayout.show(this.panImage, "busy");
                this.labImage.setIcon(null);
                this.lblBusy.setBusy(true);
            }
        } else {
            CardLayout cardLayout = (CardLayout)this.panImage.getLayout();
            cardLayout.show(this.panImage, "image");
            this.lblBusy.setBusy(false);
        }
    }

    static {
        MetaClass mc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp_pkte");
        if (mc != null) {
            ppLayer = new CidsLayer(mc);
        }
    }

    final class ImageResizeWorker
    extends SwingWorker<ImageIcon, Void> {
        @Override
        protected ImageIcon doInBackground() throws Exception {
            if (GafInfoPanel.this.gafFeatures != null && GafInfoPanel.this.gafFeatures.size() > 0) {
                WPROFReader reader = new WPROFReader(GafInfoPanel.this.gafFeatures);
                BufferedImage image = (BufferedImage)reader.createImage(reader.getProfiles().toArray(new Double[1])[0], 400, 200);
                ImageIcon result = new ImageIcon(this.adjustScale(image, GafInfoPanel.this.panImage, 20, 20));
                return result;
            }
            return null;
        }

        private Image adjustScale(BufferedImage bi, JComponent component, int insetX, int insetY) {
            double scaley;
            double scalex = (double)component.getWidth() / (double)bi.getWidth();
            double scale = Math.min(scalex, scaley = (double)component.getHeight() / (double)bi.getHeight());
            if (scale <= 1.0) {
                return bi.getScaledInstance((int)((double)bi.getWidth() * scale) - insetX, (int)((double)bi.getHeight() * scale) - insetY, 4);
            }
            return bi;
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    ImageIcon result = (ImageIcon)this.get();
                    GafInfoPanel.this.labImage.setIcon(result);
                    GafInfoPanel.this.labImage.setText("");
                    GafInfoPanel.this.labImage.setToolTipText(null);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    GafInfoPanel.this.labImage.setText("Fehler beim Skalieren!");
                }
                finally {
                    GafInfoPanel.this.showWait(false);
                    if (GafInfoPanel.this.currentResizeWorker == this) {
                        GafInfoPanel.this.currentResizeWorker = null;
                    }
                    GafInfoPanel.this.handle.repaint();
                }
            }
        }
    }

    final class LoadImageWorker
    extends SwingWorker<List<DefaultFeatureServiceFeature>, Void> {
        private final Object qpNr;

        public LoadImageWorker(Object qpNr) {
            this.qpNr = qpNr;
        }

        @Override
        protected List<DefaultFeatureServiceFeature> doInBackground() throws Exception {
            ppLayer.initAndWait();
            List features = ppLayer.getFeatureFactory().createFeatures((Object)("qp_nr = " + this.qpNr.toString()), null, null, 0, 0, null);
            return features;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                GafInfoPanel.this.gafFeatures = (List)this.get();
                if (GafInfoPanel.this.gafFeatures != null) {
                    GafProfEditor.FEATURE_CACHE.put(this.qpNr, new SoftReference<List>(GafInfoPanel.this.gafFeatures));
                    GafInfoPanel.this.timer.restart();
                } else {
                    GafInfoPanel.this.indicateError("Bild konnte nicht geladen werden: Unbekanntes Bildformat");
                }
            }
            catch (InterruptedException ex) {
                GafInfoPanel.this.gafFeatures = null;
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                GafInfoPanel.this.gafFeatures = null;
                LOG.error((Object)ex, (Throwable)ex);
                String causeMessage = "";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                }
                GafInfoPanel.this.indicateError(causeMessage);
            }
            finally {
                if (GafInfoPanel.this.gafFeatures == null) {
                    GafInfoPanel.this.showWait(false);
                }
            }
        }
    }
}

