/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui;

import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.watergis.gui.PhotoInfoPanel;
import de.cismet.watergis.gui.dialog.PhotoOptionsDialog;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import pswing.PSwing;
import pswing.PSwingCanvas;

public class PhotoInfoPHandle
extends PPath {
    private static final Logger LOG = Logger.getLogger(PhotoInfoPHandle.class);
    public static final double DEFAULT_HANDLE_SIZE = 10.0;
    public static final Shape DEFAULT_HANDLE_SHAPE = new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0);
    public static final Color DEFAULT_COLOR = Color.BLUE;
    private PLocator locator;
    private MappingComponent mc = null;
    private PhotoInfoPanel fotoInfoPanel;
    private PSwing pswingComp;

    public PhotoInfoPHandle(PLocator locator, MappingComponent mc) {
        super(DEFAULT_HANDLE_SHAPE);
        this.mc = mc;
        this.locator = locator;
        this.installEventListener();
        this.setPaint(DEFAULT_COLOR);
        this.installHandleEventHandlers();
        this.startResizeBounds();
        this.initPanel();
        this.relocateHandle();
    }

    public void setInfoPanelTransparency(float zeroToOne) {
        this.pswingComp.setTransparency(zeroToOne);
    }

    private void installEventListener() {
        PBasicInputEventHandler moveAndClickListener = new PBasicInputEventHandler(){

            public void mouseClicked(PInputEvent pInputEvent) {
                PhotoInfoPHandle.this.handleClicked(pInputEvent);
            }

            public void mouseEntered(PInputEvent pInputEvent) {
            }
        };
        this.addInputEventListener((PInputEventListener)moveAndClickListener);
    }

    private void handleClicked(PInputEvent pInputEvent) {
    }

    private void initPanel() {
        this.fotoInfoPanel = new PhotoInfoPanel(this);
        this.pswingComp = new PSwing((PSwingCanvas)this.mc, (JComponent)this.fotoInfoPanel);
        this.addChild((PNode)this.pswingComp);
    }

    public void setPhotoSize() {
        Dimension dim = PhotoOptionsDialog.getInstance().getPhotoSize();
        this.fotoInfoPanel.setPhotoSize();
        this.pswingComp.setBounds(0.0, 0.0, (double)dim.width, (double)dim.height);
        this.startResizeBounds();
        this.relocateHandle();
    }

    public void setMarkPosition() {
        this.relocateHandle();
        this.repaint();
    }

    protected void installHandleEventHandlers() {
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PhotoInfoPHandle.this.relocateHandle();
            }
        });
    }

    public PLocator getLocator() {
        return this.locator;
    }

    public void setLocator(PLocator locator) {
        this.locator = locator;
        this.invalidatePaint();
        this.relocateHandle();
    }

    public void setParent(PNode newParent) {
        super.setParent(newParent);
        this.relocateHandle();
    }

    public void parentBoundsChanged() {
        this.relocateHandle();
    }

    public void setFeature(List<CidsLayerFeature> feature) {
        this.fotoInfoPanel.setFeature(feature);
    }

    public void relocateHandle() {
        if (this.locator != null) {
            PBounds b = this.getBoundsReference();
            Point2D aPoint = this.locator.locatePoint(null);
            this.mc.getCamera().viewToLocal(aPoint);
            double newCenterX = aPoint.getX();
            double newCenterY = aPoint.getY();
            this.pswingComp.setOffset(newCenterX + 10.0, newCenterY - this.pswingComp.getHeight() / 2.0);
            if (newCenterX != b.getCenterX() || newCenterY != b.getCenterY()) {
                this.setBounds(0.0, 0.0, 10.0, 10.0);
                this.centerBoundsOnPoint(newCenterX, newCenterY);
            }
        }
    }
}

