/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui;

import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.PasswordEncrypter;
import de.cismet.watergis.gui.PhotoInfoPHandle;
import de.cismet.watergis.gui.dialog.PhotoOptionsDialog;
import de.cismet.watergis.gui.panels.PhotoEditor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PhotoInfoPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(PhotoInfoPanel.class);
    private static final String WEB_DAV_USER;
    private static final String WEB_DAV_PASSWORD;
    private static final String WEB_DAV_DIRECTORY;
    private static final WebDavClient webDavClient;
    private CidsLayerFeature feature;
    private BufferedImage image;
    private Timer timer;
    private Timer slideShow;
    private ImageResizeWorker currentResizeWorker;
    private Dimension lastDims;
    private PhotoInfoPHandle handle;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel labImage;
    private JLabel labTime;
    private JXBusyLabel lblBusy;
    private JPanel panData;
    private JPanel panImage;

    public PhotoInfoPanel(PhotoInfoPHandle handle) {
        this.handle = handle;
        this.initComponents();
        this.panImage.setSize(PhotoOptionsDialog.getInstance().getPhotoSize());
        this.timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PhotoInfoPanel.this.currentResizeWorker != null) {
                    PhotoInfoPanel.this.currentResizeWorker.cancel(true);
                }
                PhotoInfoPanel.this.currentResizeWorker = new ImageResizeWorker();
                CismetThreadPool.execute((Runnable)PhotoInfoPanel.this.currentResizeWorker);
            }
        });
        this.timer.setRepeats(false);
    }

    private void initComponents() {
        this.panImage = new JPanel();
        this.labImage = new JLabel();
        this.lblBusy = new JXBusyLabel(new Dimension(75, 75));
        this.panData = new JPanel();
        this.labTime = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.panImage.setMinimumSize(new Dimension(300, 300));
        this.panImage.setPreferredSize(new Dimension(300, 300));
        this.panImage.setLayout(new CardLayout());
        this.labImage.setHorizontalAlignment(0);
        this.panImage.add((Component)this.labImage, "image");
        this.lblBusy.setHorizontalAlignment(0);
        this.lblBusy.setMaximumSize(new Dimension(140, 40));
        this.lblBusy.setMinimumSize(new Dimension(140, 40));
        this.lblBusy.setPreferredSize(new Dimension(140, 40));
        this.panImage.add((Component)this.lblBusy, "busy");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panImage, gridBagConstraints);
        this.panData.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTime, (String)NbBundle.getMessage(PhotoInfoPanel.class, (String)"PhotoInfoPanel.labTime.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panData.add((Component)this.labTime, gridBagConstraints);
        this.jPanel1.setMaximumSize(new Dimension(250, 32));
        this.jPanel1.setPreferredSize(new Dimension(250, 32));
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PhotoInfoPanel.class, (String)"PhotoInfoPanel.jLabel1.text", (Object[])new Object[0]));
        this.jPanel1.add((Component)this.jLabel1, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panData.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.panData, gridBagConstraints);
    }

    public CidsLayerFeature getFeature() {
        return this.feature;
    }

    public void setPhotoSize() {
        this.setSize(PhotoOptionsDialog.getInstance().getPhotoSize());
        this.setFeature(new ArrayList<CidsLayerFeature>());
    }

    public void setFeature(final List<CidsLayerFeature> feature) {
        if (this.slideShow != null) {
            this.slideShow.stop();
            this.slideShow = null;
        }
        if (feature.size() == 1) {
            this.setFeature(feature.get(0));
        } else if (feature.size() == 0) {
            this.setFeature((CidsLayerFeature)null);
        } else {
            this.setFeature(feature.get(0));
            this.slideShow = new Timer(5000, new ActionListener(){
                int index = 0;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ++this.index;
                    if (this.index == feature.size()) {
                        this.index = 0;
                    }
                    PhotoInfoPanel.this.setFeature((CidsLayerFeature)feature.get(this.index));
                }
            });
            this.slideShow.setRepeats(true);
            this.slideShow.setDelay(5000);
            this.slideShow.start();
        }
    }

    private void setFeature(CidsLayerFeature feature) {
        if (feature != null && this.feature != feature) {
            this.feature = feature;
            this.jLabel1.setText("<html>" + this.obj2String(feature.getProperty("titel")) + "</html>");
            this.labTime.setText(PhotoInfoPanel.dateTime2String(feature.getProperty("aufn_datum"), (String)feature.getProperty("aufn_zeit")));
            this.loadFoto();
        } else {
            this.feature = feature;
        }
    }

    private String obj2String(Object o) {
        if (o == null) {
            return "";
        }
        return String.valueOf(o);
    }

    private String obj2Time(Object o) {
        if (o == null) {
            return "";
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            return format.format(o);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Not a date", (Throwable)e);
            return "";
        }
    }

    private static String dateTime2String(Object date, String time) {
        if (date == null && time == null) {
            return "";
        }
        if (date == null) {
            return time;
        }
        if (time == null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                return format.format(date);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Not a date", (Throwable)e);
                return "";
            }
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            return format.format(date) + " " + time;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Not a date", (Throwable)e);
            return "";
        }
    }

    private void loadFoto() {
        String path = (String)this.feature.getBean().getProperty("dateipfad");
        String filename = (String)this.feature.getProperty("foto");
        boolean cacheHit = false;
        if (path != null && filename != null) {
            BufferedImage cachedImage;
            String file = path + filename;
            SoftReference<BufferedImage> cachedImageRef = PhotoEditor.IMAGE_CACHE.get(file);
            this.showWait(true);
            if (cachedImageRef != null && (cachedImage = cachedImageRef.get()) != null) {
                cacheHit = true;
                this.image = cachedImage;
                this.timer.restart();
            }
            if (!cacheHit) {
                CismetThreadPool.execute((Runnable)new LoadImageWorker(path, filename));
            }
        }
    }

    private void indicateError(String error) {
        this.labImage.setToolTipText(error);
    }

    private void showWait(boolean wait) {
        if (wait) {
            if (!this.lblBusy.isBusy()) {
                CardLayout cardLayout = (CardLayout)this.panImage.getLayout();
                cardLayout.show(this.panImage, "busy");
                this.labImage.setIcon(null);
                this.lblBusy.setBusy(true);
            }
        } else {
            CardLayout cardLayout = (CardLayout)this.panImage.getLayout();
            cardLayout.show(this.panImage, "image");
            this.lblBusy.setBusy(false);
        }
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("WebDav");
        String pass = bundle.getString("password");
        if (pass != null) {
            pass = new String(PasswordEncrypter.decrypt((char[])pass.toCharArray(), (boolean)true));
        }
        WEB_DAV_PASSWORD = pass;
        WEB_DAV_USER = bundle.getString("username");
        WEB_DAV_DIRECTORY = bundle.getString("url");
        webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
    }

    final class ImageResizeWorker
    extends SwingWorker<ImageIcon, Void> {
        @Override
        protected ImageIcon doInBackground() throws Exception {
            if (PhotoInfoPanel.this.image != null) {
                ImageIcon result = new ImageIcon(PhotoEditor.adjustScale(PhotoInfoPanel.this.image, PhotoInfoPanel.this.panImage, 20, 20));
                return result;
            }
            return null;
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    ImageIcon result = (ImageIcon)this.get();
                    PhotoInfoPanel.this.labImage.setIcon(result);
                    PhotoInfoPanel.this.labImage.setText("");
                    PhotoInfoPanel.this.labImage.setToolTipText(null);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    PhotoInfoPanel.this.labImage.setText("Fehler beim Skalieren!");
                }
                finally {
                    PhotoInfoPanel.this.showWait(false);
                    if (PhotoInfoPanel.this.currentResizeWorker == this) {
                        PhotoInfoPanel.this.currentResizeWorker = null;
                    }
                    PhotoInfoPanel.this.handle.repaint();
                }
            }
        }
    }

    final class LoadImageWorker
    extends SwingWorker<BufferedImage, Void> {
        private final String path;
        private final String file;

        public LoadImageWorker(String path, String file) {
            this.path = path;
            this.file = file;
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            if (this.file != null && this.file.length() > 0) {
                IIOReadProgressListener listener = new IIOReadProgressListener(){

                    @Override
                    public void sequenceStarted(ImageReader source, int minIndex) {
                    }

                    @Override
                    public void sequenceComplete(ImageReader source) {
                    }

                    @Override
                    public void imageStarted(ImageReader source, int imageIndex) {
                    }

                    @Override
                    public void imageProgress(ImageReader source, float percentageDone) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PhotoInfoPanel.this.handle.repaint();
                            }
                        });
                    }

                    @Override
                    public void imageComplete(ImageReader source) {
                    }

                    @Override
                    public void thumbnailStarted(ImageReader source, int imageIndex, int thumbnailIndex) {
                    }

                    @Override
                    public void thumbnailProgress(ImageReader source, float percentageDone) {
                    }

                    @Override
                    public void thumbnailComplete(ImageReader source) {
                    }

                    @Override
                    public void readAborted(ImageReader source) {
                    }
                };
                return WebDavHelper.downloadImageFromWebDAV((String)this.file, (String)(WEB_DAV_DIRECTORY + this.path), (WebDavClient)webDavClient, null, (IIOReadProgressListener)listener);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                PhotoInfoPanel.this.image = (BufferedImage)this.get();
                if (PhotoInfoPanel.this.image != null) {
                    PhotoEditor.IMAGE_CACHE.put(this.path + this.file, new SoftReference<BufferedImage>(PhotoInfoPanel.this.image));
                    PhotoInfoPanel.this.timer.restart();
                } else {
                    PhotoInfoPanel.this.indicateError("Bild konnte nicht geladen werden: Unbekanntes Bildformat");
                }
                PhotoInfoPanel.this.handle.repaint();
            }
            catch (InterruptedException ex) {
                PhotoInfoPanel.this.image = null;
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                PhotoInfoPanel.this.image = null;
                LOG.error((Object)ex, (Throwable)ex);
                String causeMessage = "";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                }
                PhotoInfoPanel.this.indicateError(causeMessage);
            }
            finally {
                if (PhotoInfoPanel.this.image == null) {
                    PhotoInfoPanel.this.showWait(false);
                }
            }
        }
    }
}

