/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.localserver.attribute.ClassAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.CidsLayerFactory;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.JDBCFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.tools.ExportCsvDownload;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.actions.checks.AbstractCheckAction;
import de.cismet.watergis.gui.dialog.ExportDialog;
import de.cismet.watergis.utils.GeometryUtils;
import de.cismet.watergis.utils.JumpShapeWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class ExportAction
extends AbstractAction
implements Configurable {
    private static final Logger LOG = Logger.getLogger(ExportAction.class);
    private static final String CHECK_LIST = "CheckList";
    private static final String ROOT_TAG = "ExportAction";
    private static final String FEATURE_SERVICES_TAG = "FeatureServices";
    private static final String JAVA_CLASS_ATTR = "JavaClass";
    private static final String CHECK = "Check";
    private static final String THEME_FOLDER = "Themen";
    private static final String CATALOGUE_FOLDER = "Kataloge";
    private List<AbstractFeatureService> servicesToExport;
    private List<AbstractCheckAction> checks;
    private Map<Integer, CidsBean> wwGrBeans = null;
    private List<DefaultFeatureServiceFeature> expFeatures = null;
    private String path = null;

    public ExportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-download-alt.png");
        String text = "GDV";
        String tooltiptext = "GDV-Export";
        String mnemonic = "G";
        try {
            text = NbBundle.getMessage(ExportAction.class, (String)"ExportAction.text");
            tooltiptext = NbBundle.getMessage(ExportAction.class, (String)"ExportAction.toolTipText");
            mnemonic = NbBundle.getMessage(ExportAction.class, (String)"ExportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("ShortDescription", tooltiptext);
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        final File file = StaticSwingTools.chooseFile((String)(this.path == null ? DownloadManager.instance().getDestinationDirectory().toString() : this.path), (boolean)true, (String[])new String[]{"zip"}, (String)NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.butFileActionPerformed().getDescription.return"), (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file == null) {
            return;
        }
        if (file.getParent() != null) {
            this.path = file.getParent();
        }
        WaitingDialogThread<Boolean> wdt = new WaitingDialogThread<Boolean>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(ExportAction.class, (String)"ExportAction.actionPerformed().dialog"), null, 100, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean doInBackground() throws Exception {
                boolean askedForDirectory = false;
                int steps = ExportAction.this.servicesToExport.size();
                int checkSteps = 0;
                ArrayList<ErrorContainer> errors = new ArrayList<ErrorContainer>();
                ArrayList<H2FeatureService> errorServices = new ArrayList<H2FeatureService>();
                for (AbstractCheckAction check : ExportAction.this.checks) {
                    checkSteps += check.getProgressSteps();
                }
                this.wd.setMax(steps += checkSteps);
                if (ExportAction.this.wwGrBeans == null) {
                    this.setWwGrBeans();
                }
                this.setFgBaExpBeans();
                for (AbstractCheckAction check : ExportAction.this.checks) {
                    try {
                        errorServices.clear();
                        this.wd.setText("Pr\u00fcfe " + check.getValue("Name").toString());
                        check.startCheck(true, this.wd, errorServices);
                        if (Thread.interrupted()) {
                            Iterator iterator = null;
                            return iterator;
                        }
                        this.filterCheckResult(errorServices);
                        errors.addAll(this.createErrorObjects(check.getValue("Name").toString(), errorServices));
                    }
                    catch (Exception e2) {
                        Boolean service = false;
                        return service;
                    }
                    finally {
                        for (H2FeatureService service : errorServices) {
                            H2FeatureService.removeTableIfExists((String)service.getTableName());
                        }
                    }
                }
                int number = 0;
                String path = file.getAbsolutePath();
                char seperator = path.lastIndexOf(47) > path.lastIndexOf(92) ? (char)'/' : '\\';
                path = path.substring(0, path.lastIndexOf(seperator));
                String tempPath = path + seperator + "exp" + number;
                if (!errors.isEmpty()) {
                    SimpleDateFormat formatter = new SimpleDateFormat("YYYY-MM-dd-H-mm");
                    String filename = formatter.format(new Date()) + "-Export-Fehlerprotokoll";
                    new File(path + seperator).mkdirs();
                    List<DefaultFeatureServiceFeature> errorFeatures = this.createErrorFileContent(errors);
                    ExportCsvDownload d = new ExportCsvDownload(path + seperator + filename, ".csv", (FeatureServiceFeature[])errorFeatures.toArray(new DefaultFeatureServiceFeature[errorFeatures.size()]), null, null);
                    DownloadManager.instance().add((Download)d);
                }
                while (new File(tempPath).exists()) {
                    tempPath = path + seperator + "exp" + ++number;
                }
                new File(tempPath + seperator + ExportAction.THEME_FOLDER).mkdirs();
                new File(tempPath + seperator + ExportAction.CATALOGUE_FOLDER).mkdirs();
                try {
                    for (AbstractFeatureService service : ExportAction.this.servicesToExport) {
                        List<DefaultFeatureServiceFeature> features;
                        boolean geometryFound;
                        String sortingColumn;
                        block37: {
                            ClassAttribute ca;
                            this.wd.setText("Exportiere " + service.toString());
                            this.wd.setProgress(++checkSteps);
                            sortingColumn = null;
                            if (e.getActionCommand().equalsIgnoreCase("igm") && (service.getName().equalsIgnoreCase("Technologien") || service.getName().equalsIgnoreCase("Leistungen") || service.getName().equalsIgnoreCase("Dokumente") || service.getName().equalsIgnoreCase("Projekte") || service.getName().equalsIgnoreCase("fg_ba_doku") || service.getName().equalsIgnoreCase("fg_ba_proj") || service.getName().equalsIgnoreCase("k_leis") || service.getName().equalsIgnoreCase("k_tech") || service.getName().equalsIgnoreCase("k_gu_gu") || service.getName().equalsIgnoreCase("k_mahd_gu") || service.getName().equalsIgnoreCase("k_na_gu"))) continue;
                            if (service instanceof CidsLayer && (ca = ((CidsLayer)service).getMetaClass().getClassAttribute("sortingColumn")) != null) {
                                sortingColumn = String.valueOf(ca.getValue());
                            }
                            service.initAndWait();
                            geometryFound = this.hasGeometry(service);
                            String[] selectedbaCdArray = null;
                            User user = SessionManager.getSession().getUser();
                            selectedbaCdArray = this.getAttributesOfSelectedObjects("fg_ba", "ba_cd");
                            String query = null;
                            if (!service.getName().startsWith("k_")) {
                                query = this.createExportQuery(service, selectedbaCdArray);
                            }
                            features = service.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, null);
                            if (!Thread.interrupted()) break block37;
                            Boolean bl = null;
                            return bl;
                        }
                        try {
                            CidsLayer cl;
                            String link;
                            if (!service.getName().startsWith("k_")) {
                                features = this.filterFeatures(service, features);
                            }
                            String name = service.getName();
                            if (service instanceof CidsLayer) {
                                name = ((CidsLayer)service).getMetaClass().getTableName();
                            }
                            if (name.contains(".")) {
                                name = name.substring(name.lastIndexOf(".") + 1);
                            }
                            String filename = geometryFound ? tempPath + seperator + ExportAction.THEME_FOLDER + seperator + name : tempPath + seperator + ExportAction.CATALOGUE_FOLDER + seperator + name;
                            ArrayList<String[]> attribList = new ArrayList<String[]>();
                            for (String attr : service.getOrderedFeatureServiceAttributes()) {
                                String[] attrName = new String[]{attr, attr};
                                attribList.add(attrName);
                            }
                            if (sortingColumn != null) {
                                final String col = sortingColumn;
                                Collections.sort(features, new Comparator<DefaultFeatureServiceFeature>(){

                                    @Override
                                    public int compare(DefaultFeatureServiceFeature o1, DefaultFeatureServiceFeature o2) {
                                        Object attr1 = o1.getProperty(col);
                                        Object attr2 = o2.getProperty(col);
                                        if (attr1 == null && attr2 == null) {
                                            return 0;
                                        }
                                        if (attr1 == null) {
                                            return 1;
                                        }
                                        if (attr2 == null) {
                                            return -1;
                                        }
                                        if (attr1 instanceof Comparable && attr2 instanceof Comparable) {
                                            return ((Comparable)attr1).compareTo((Comparable)attr2);
                                        }
                                        return 0;
                                    }
                                });
                            }
                            this.exportShp(String.valueOf(checkSteps), (FeatureServiceFeature[])features.toArray(new DefaultFeatureServiceFeature[features.size()]), filename, attribList, geometryFound, service);
                            if (geometryFound) {
                                this.createPrjFile(filename + ".prj");
                            }
                            if (!(service instanceof CidsLayer) || (link = (cl = (CidsLayer)service).getMetaDocumentLink()) == null) continue;
                            BufferedInputStream bin = null;
                            FilterOutputStream out = null;
                            try {
                                int byteCount;
                                URL u = new URL(link);
                                String file2 = u.getFile().substring(u.getFile().lastIndexOf("/") + 1);
                                String outputFile = geometryFound ? tempPath + seperator + ExportAction.THEME_FOLDER + seperator + file2 : tempPath + seperator + ExportAction.CATALOGUE_FOLDER + seperator + file2;
                                InputStream in = WebAccessManager.getInstance().doRequest(u);
                                bin = new BufferedInputStream(in);
                                out = new BufferedOutputStream(new FileOutputStream(outputFile));
                                byte[] tmp = new byte[256];
                                while ((byteCount = bin.read(tmp, 0, tmp.length)) != -1) {
                                    ((BufferedOutputStream)out).write(tmp, 0, byteCount);
                                }
                            }
                            catch (Exception e3) {
                                LOG.error((Object)"Error while downloading meta document.", (Throwable)e3);
                            }
                            finally {
                                if (bin != null) {
                                    bin.close();
                                }
                                if (out == null) continue;
                                out.close();
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Error while retrieving features", (Throwable)ex);
                        }
                    }
                    File zipFile = new File(file.getAbsolutePath());
                    ExportAction.zipDirectory(new File(tempPath), zipFile);
                    DownloadManager.instance().add((Download)new FakeFileDownload(zipFile, "Export"));
                }
                finally {
                    File f = new File(tempPath);
                    if (f.exists() && f.isDirectory()) {
                        FileUtils.deleteDirectory((File)f);
                    }
                }
                return true;
            }

            private void showDownloadManager() {
                DownloadManagerDialog downloadManager = DownloadManagerDialog.instance((Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
                downloadManager.pack();
                StaticSwingTools.showDialog((JDialog)downloadManager);
            }

            private List<DefaultFeatureServiceFeature> createErrorFileContent(List<ErrorContainer> errors) {
                ArrayList<DefaultFeatureServiceFeature> errorFeatures = new ArrayList<DefaultFeatureServiceFeature>();
                TreeSet<String> set = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null && o2 != null) {
                            return -1;
                        }
                        if (o1 != null && o2 == null) {
                            return 1;
                        }
                        if (o1.startsWith("NIEMAND") && !o2.startsWith("NIEMAND")) {
                            return 1;
                        }
                        if (!o1.startsWith("NIEMAND") && o2.startsWith("NIEMAND")) {
                            return -1;
                        }
                        if (o1.startsWith("wsa") && o2.startsWith("wbv")) {
                            return -1;
                        }
                        if (o1.startsWith("wbv") && o2.startsWith("wsa")) {
                            return 1;
                        }
                        return o1.compareTo(o2);
                    }
                });
                String lastErrorMessage = "";
                HashMap<String, FeatureServiceAttribute> attributeMap = new HashMap<String, FeatureServiceAttribute>();
                for (ErrorContainer ec : errors) {
                    set.add(ec.getOwner());
                }
                attributeMap.put("Pr\u00fcfung", new FeatureServiceAttribute("Pr\u00fcfung", String.valueOf(12), true));
                for (String owner : set) {
                    attributeMap.put(owner, new FeatureServiceAttribute(owner, String.valueOf(12), true));
                }
                DefaultFeatureServiceFeature f = null;
                for (ErrorContainer ec : errors) {
                    if (!lastErrorMessage.equals(ec.getErrorMessage())) {
                        f = new DefaultFeatureServiceFeature();
                        errorFeatures.add(f);
                        f.setProperty("Pr\u00fcfung", (Object)ec.getErrorMessage());
                        for (String owner : set) {
                            f.setProperty(owner, (Object)"");
                        }
                        lastErrorMessage = ec.getErrorMessage();
                    }
                    if (f == null) continue;
                    f.setProperty(ec.getOwner(), (Object)"X");
                }
                return errorFeatures;
            }

            private boolean hasGeometry(AbstractFeatureService service) {
                Map attrMap = service.getFeatureServiceAttributes();
                for (FeatureServiceAttribute attr : attrMap.values()) {
                    if (!attr.isGeometry()) continue;
                    return true;
                }
                return false;
            }

            private List<ErrorContainer> createErrorObjects(String checkname, List<H2FeatureService> services) {
                TreeSet<String> errorSet = new TreeSet<String>();
                try {
                    for (H2FeatureService service : services) {
                        List features = service.getFeatureFactory().createFeatures(null, null, null, 0, 0, null);
                        if (features == null || features.isEmpty()) continue;
                        for (JDBCFeature feature : features) {
                            String owner = this.getGu((DefaultFeatureServiceFeature)feature);
                            if (errorSet.contains(owner)) continue;
                            errorSet.add(owner);
                        }
                    }
                }
                catch (Exception e2) {
                    LOG.error((Object)"Error while creating error message.", (Throwable)e2);
                }
                ArrayList<ErrorContainer> result = new ArrayList<ErrorContainer>();
                for (String owner : errorSet) {
                    result.add(new ErrorContainer(checkname, owner));
                }
                return result;
            }

            private void filterCheckResult(List<H2FeatureService> services) {
                try {
                    for (AbstractFeatureService abstractFeatureService : services) {
                        List features = abstractFeatureService.getFeatureFactory().createFeatures(null, null, null, 0, 0, null);
                        if (!e.getActionCommand().equalsIgnoreCase("igm") || !abstractFeatureService.getName().contains("Leis") && !abstractFeatureService.getName().contains("Tech")) {
                            List<DefaultFeatureServiceFeature> copiedFeaturesList = new ArrayList<DefaultFeatureServiceFeature>(features);
                            copiedFeaturesList = this.filterErrorFeatures(abstractFeatureService, copiedFeaturesList);
                            features.removeAll(copiedFeaturesList);
                        }
                        for (JDBCFeature f : features) {
                            f.delete();
                        }
                    }
                }
                catch (Exception e2) {
                    LOG.error((Object)"Error while filtering check results.", (Throwable)e2);
                }
            }

            private List<DefaultFeatureServiceFeature> filterErrorFeatures(AbstractFeatureService service, List<DefaultFeatureServiceFeature> features) {
                User user = SessionManager.getSession().getUser();
                Map attributes = service.getFeatureServiceAttributes();
                boolean hasWdm = false;
                if (features == null || features.isEmpty()) {
                    return features;
                }
                for (FeatureServiceAttribute attr : attributes.values()) {
                    if (!attr.getName().equals("ww_gr")) continue;
                    hasWdm = true;
                }
                if (hasWdm) {
                    ArrayList<DefaultFeatureServiceFeature> acceptedFeatures = new ArrayList<DefaultFeatureServiceFeature>(features.size());
                    for (DefaultFeatureServiceFeature feature : features) {
                        boolean acceptFeature = true;
                        if (!ExportDialog.getInstance().has1501() && this.isWdm1501(feature)) {
                            acceptFeature = false;
                        }
                        if (!ExportDialog.getInstance().has1502() && this.isWdm1502(feature)) {
                            acceptFeature = false;
                        }
                        if (!ExportDialog.getInstance().has1503() && this.isWdm1503(feature)) {
                            acceptFeature = false;
                        }
                        if (!ExportDialog.getInstance().has1504() && this.isWdm1504(feature)) {
                            acceptFeature = false;
                        }
                        if (!ExportDialog.getInstance().has1505() && this.isWdm1505(feature)) {
                            acceptFeature = false;
                        }
                        if (!user.getUserGroup().getName().equalsIgnoreCase("administratoren") && this.isInvalidForeignData(feature)) {
                            acceptFeature = false;
                        }
                        if (!acceptFeature) continue;
                        acceptedFeatures.add(feature);
                    }
                    return acceptedFeatures;
                }
                return features;
            }

            private List<DefaultFeatureServiceFeature> filterFeatures(AbstractFeatureService service, List<DefaultFeatureServiceFeature> features) {
                User user = SessionManager.getSession().getUser();
                Map attributes = service.getFeatureServiceAttributes();
                boolean hasWdm = false;
                if (features == null || features.isEmpty()) {
                    return features;
                }
                for (FeatureServiceAttribute attr : attributes.values()) {
                    if (!attr.getName().equals("ww_gr")) continue;
                    hasWdm = true;
                }
                if (!hasWdm && features.get(0).getProperty("ww_gr") != null) {
                    hasWdm = true;
                }
                if (hasWdm && !user.getUserGroup().getName().equalsIgnoreCase("administratoren")) {
                    ArrayList<DefaultFeatureServiceFeature> acceptedFeatures = new ArrayList<DefaultFeatureServiceFeature>(features.size());
                    for (DefaultFeatureServiceFeature feature : features) {
                        boolean acceptFeature = true;
                        if (!ExportDialog.getInstance().has1501() && this.isWdm1501(feature)) {
                            acceptFeature = false;
                        }
                        if (!ExportDialog.getInstance().has1502() && this.isWdm1502(feature)) {
                            acceptFeature = false;
                        }
                        if (!ExportDialog.getInstance().has1503() && this.isWdm1503(feature)) {
                            acceptFeature = false;
                        }
                        if (!ExportDialog.getInstance().has1504() && this.isWdm1504(feature)) {
                            acceptFeature = false;
                        }
                        if (!ExportDialog.getInstance().has1505() && this.isWdm1505(feature)) {
                            acceptFeature = false;
                        }
                        if (acceptFeature && this.isInvalidForeignData(feature)) {
                            acceptFeature = false;
                        }
                        if (!acceptFeature) continue;
                        acceptedFeatures.add(feature);
                    }
                    return acceptedFeatures;
                }
                return features;
            }

            private void setWwGrBeans() throws Exception {
                MetaClass WW_GR_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_ww_gr");
                String query = "select distinct " + WW_GR_MC.getID() + ", " + WW_GR_MC.getPrimaryKey() + " from dlm25w.k_ww_gr";
                User user = SessionManager.getSession().getUser();
                MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(user, query);
                if (mos != null) {
                    ExportAction.this.wwGrBeans = new HashMap();
                    for (MetaObject mo : mos) {
                        ExportAction.this.wwGrBeans.put((Integer)mo.getBean().getProperty("ww_gr"), mo.getBean());
                    }
                }
            }

            private void setFgBaExpBeans() throws Exception {
                MetaClass FG_BA_EXP_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_exp");
                User user = SessionManager.getSession().getUser();
                String query = "dlm25w.fg_ba_exp.ww_gr in (select id from dlm25w.k_ww_gr where owner = '" + user.getUserGroup().getName() + "')";
                CidsLayer layer = new CidsLayer(FG_BA_EXP_MC);
                layer.initAndWait();
                ExportAction.this.expFeatures = layer.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, null);
            }

            private String getGu(DefaultFeatureServiceFeature f) {
                Object wwGrObj = null;
                try {
                    wwGrObj = f.getProperty("ww_gr");
                }
                catch (Throwable t) {
                    LOG.error((Object)"error", t);
                }
                Integer wwGr = null;
                if (wwGrObj instanceof String) {
                    try {
                        wwGr = Integer.parseInt((String)f.getProperty("ww_gr"));
                    }
                    catch (NumberFormatException e2) {
                        LOG.error((Object)"wdm is not a number");
                    }
                } else if (wwGrObj instanceof Integer) {
                    wwGr = (Integer)wwGrObj;
                }
                if (wwGr != null) {
                    CidsBean wwGrBean = (CidsBean)ExportAction.this.wwGrBeans.get(wwGr);
                    return (String)wwGrBean.getProperty("owner");
                }
                return "unbekannt";
            }

            private boolean isWdm(DefaultFeatureServiceFeature feature, int wdm) {
                CidsBean wwGrBean;
                Integer wwGr = (Integer)feature.getProperty("ww_gr");
                return wwGr != null && (Integer)(wwGrBean = (CidsBean)ExportAction.this.wwGrBeans.get(wwGr)).getProperty("wdm") == wdm;
            }

            private boolean isWdm1501(DefaultFeatureServiceFeature feature) {
                return this.isWdm(feature, 1501);
            }

            private boolean isWdm1502(DefaultFeatureServiceFeature feature) {
                return this.isWdm(feature, 1502);
            }

            private boolean isWdm1503(DefaultFeatureServiceFeature feature) {
                return this.isWdm(feature, 1503);
            }

            private boolean isWdm1504(DefaultFeatureServiceFeature feature) {
                return this.isWdm(feature, 1504);
            }

            private boolean isWdm1505(DefaultFeatureServiceFeature feature) {
                return this.isWdm(feature, 1505);
            }

            private boolean isInvalidForeignData(DefaultFeatureServiceFeature feature) {
                Integer wwGr = (Integer)feature.getProperty("ww_gr");
                if (wwGr == null || wwGr != null && !this.isOwnWwGr(wwGr)) {
                    if (!ExportDialog.getInstance().hasForeignData()) {
                        return true;
                    }
                    String baCd = (String)feature.getProperty("ba_cd");
                    List<DefaultFeatureServiceFeature> correspondingExp = this.getExpForBaCd(baCd);
                    for (DefaultFeatureServiceFeature exp : correspondingExp) {
                        Geometry g = exp.getGeometry();
                        g = g.buffer(0.1, 8, 2);
                        if (!feature.getGeometry().intersects(g)) continue;
                        if (feature.getGeometry().within(g)) {
                            return false;
                        }
                        feature.setGeometry(feature.getGeometry().intersection(g));
                        Double von = (Double)feature.getProperty("ba_st_von");
                        Double bis = (Double)feature.getProperty("ba_st_bis");
                        Double expVon = (Double)exp.getProperty("ba_st_von");
                        Double expBis = (Double)exp.getProperty("ba_st_bis");
                        if (von != null && expVon != null && von < expVon) {
                            feature.setProperty("ba_st_von", (Object)expVon);
                        }
                        if (bis != null && expBis != null && bis > expBis) {
                            feature.setProperty("ba_st_bis", (Object)expBis);
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }

            private List<DefaultFeatureServiceFeature> getExpForBaCd(String baCd) {
                ArrayList<DefaultFeatureServiceFeature> result = new ArrayList<DefaultFeatureServiceFeature>();
                for (DefaultFeatureServiceFeature feature : ExportAction.this.expFeatures) {
                    String baCdTmp = (String)feature.getProperty("ba_cd");
                    if (baCdTmp == null || !baCdTmp.equals(baCd)) continue;
                    result.add(feature);
                }
                return result;
            }

            private boolean isOwnWwGr(Integer wwGr) {
                List<CidsBean> ownBeans = AppBroker.getInstance().getOwnWwGrList();
                for (CidsBean bean : ownBeans) {
                    if (bean.getProperty("ww_gr") == null || !bean.getProperty("ww_gr").equals(wwGr)) continue;
                    return true;
                }
                return false;
            }

            private String createQuery(AbstractFeatureService service) {
                String query = null;
                Map attributes = service.getFeatureServiceAttributes();
                boolean hasWdm = false;
                for (FeatureServiceAttribute attr : attributes.values()) {
                    if (!attr.getName().equals("ww_gr")) continue;
                    hasWdm = true;
                }
                if (!hasWdm) {
                    return null;
                }
                if (!ExportDialog.getInstance().has1501()) {
                    query = query == null ? "1501" : query + ", 1501";
                }
                if (!ExportDialog.getInstance().has1502()) {
                    query = query == null ? "1502" : query + ", 1502";
                }
                if (!ExportDialog.getInstance().has1503()) {
                    query = query == null ? "1503" : query + ",1503";
                }
                if (!ExportDialog.getInstance().has1504()) {
                    query = query == null ? "1504" : query + ", 1504";
                }
                if (!ExportDialog.getInstance().has1505()) {
                    query = query == null ? "1505" : query + ", 1505";
                }
                if (query != null) {
                    query = " dlm25wPk_ww_gr1.wdm not in (" + query + ")";
                }
                return query;
            }

            private String createExportQuery(AbstractFeatureService service, String[] selectedbaCdArray) {
                String query = null;
                Map attributes = service.getFeatureServiceAttributes();
                boolean hasWdm = false;
                for (Object attr : attributes.values()) {
                    if (!attr.getName().equals("ww_gr")) continue;
                    hasWdm = true;
                }
                boolean hasBaCd = false;
                for (FeatureServiceAttribute attr : attributes.values()) {
                    if (!attr.getName().equals("ba_cd")) continue;
                    hasBaCd = true;
                }
                if (hasWdm || service.getName().equals("Stationen")) {
                    User user;
                    if (!ExportDialog.getInstance().has1501()) {
                        query = query == null ? "1501" : query + ", 1501";
                    }
                    if (!ExportDialog.getInstance().has1502()) {
                        query = query == null ? "1502" : query + ", 1502";
                    }
                    if (!ExportDialog.getInstance().has1503()) {
                        query = query == null ? "1503" : query + ",1503";
                    }
                    if (!ExportDialog.getInstance().has1504()) {
                        query = query == null ? "1504" : query + ", 1504";
                    }
                    if (!ExportDialog.getInstance().has1505()) {
                        query = query == null ? "1505" : query + ", 1505";
                    }
                    if (query != null) {
                        query = service.getName().equals("Stationen") ? "  ba_cd in (select ba_cd from dlm25w.fg_ba b join dlm25w.k_ww_gr gr on (b.ww_gr = gr.id) where  gr.wdm not in (" + query + "))" : " dlm25wPk_ww_gr1.wdm not in (" + query + ")";
                    }
                    if (!(user = SessionManager.getSession().getUser()).getUserGroup().getName().equalsIgnoreCase("administratoren")) {
                        query = this.isGu() ? (service.getName().equals("Stationen") ? (query == null ? "  ba_cd in (select ba_cd from dlm25w.fg_ba b join dlm25w.k_ww_gr gr on (b.ww_gr = gr.id) where  gr.wdm in (select wdm from dlm25w.k_ww_gr where owner = '" + user.getUserGroup().getName() + "'))" : query + " and ba_cd in (select ba_cd from dlm25w.fg_ba b join dlm25w.k_ww_gr gr on (b.ww_gr = gr.id) where  gr.wdm in (select wdm from dlm25w.k_ww_gr where owner = '" + user.getUserGroup().getName() + "'))") : (query == null ? " dlm25wPk_ww_gr1.wdm in (select wdm from dlm25w.k_ww_gr where owner = '" + user.getUserGroup().getName() + "')" : query + " and dlm25wPk_ww_gr1.wdm in (select wdm from dlm25w.k_ww_gr where owner = '" + user.getUserGroup().getName() + "')")) : (query == null ? "false" : "(" + query + ") and false");
                        if (ExportDialog.getInstance().hasForeignData() && query != null && hasBaCd) {
                            query = "(" + query + ") or (ba_cd in (select ba.ba_cd from dlm25w.fg_ba_exp e join dlm25w.fg_ba_linie l on (ba_st = l.id) join dlm25w.fg_ba_punkt p on (l.von = p.id) join dlm25w.fg_ba ba on (ba.id = p.route) where e.ww_gr  in (select id from dlm25w.k_ww_gr where owner = '" + user.getUserGroup().getName() + "')))";
                        }
                    }
                }
                if (selectedbaCdArray != null && hasBaCd) {
                    query = query == null ? "(ba_cd = any(" + SQLFormatter.createSqlArrayString((String[])selectedbaCdArray) + "))" : "(" + query + ") and (ba_cd = any(" + SQLFormatter.createSqlArrayString((String[])selectedbaCdArray) + "))";
                }
                return query;
            }

            private boolean isGu() {
                User user = SessionManager.getSession().getUser();
                for (CidsBean bean : ExportAction.this.wwGrBeans.values()) {
                    String prefix;
                    String owner = (String)bean.getProperty("owner");
                    if (owner == null || !owner.equals(user.getUserGroup().getName()) || (prefix = (String)bean.getProperty("praefix")) == null) continue;
                    return true;
                }
                return false;
            }

            private void exportShp(String id, FeatureServiceFeature[] features, String filename, List<String[]> attribList, boolean hasGeometry, AbstractFeatureService service) throws Exception {
                try {
                    String charset;
                    block9: {
                        boolean emptyShape = false;
                        FeatureServiceFeature[] featureArray = features;
                        if (features.length == 0) {
                            emptyShape = true;
                            FeatureServiceFeature feature = service.getFeatureFactory().createNewFeature();
                            String geometryType = service.getGeometryType();
                            Geometry g = GeometryUtils.createDummyGeometry(geometryType);
                            feature.setGeometry(g);
                            featureArray = new FeatureServiceFeature[]{feature};
                        }
                        JumpShapeWriter shapeWriter = new JumpShapeWriter();
                        charset = Charset.defaultCharset().name();
                        shapeWriter.writeShpFile(featureArray, new File(filename + ".shp"), attribList, charset);
                        if (emptyShape) {
                            String geometryType = service.getGeometryType();
                            byte shpGeoType = GeometryUtils.getShpGeometryType(geometryType);
                            try {
                                GeometryUtils.clearShpOrShxFile(filename + ".shp", shpGeoType);
                                GeometryUtils.clearShpOrShxFile(filename + ".shx", shpGeoType);
                                GeometryUtils.clearDbfFile(filename + ".dbf");
                            }
                            catch (Exception e2) {
                                LOG.error((Object)"Cannot remove content from shape. So remove it completely", (Throwable)e2);
                                File shapeFile = new File(filename + ".shp");
                                File shxFile = new File(filename + ".shx");
                                File dbfFile = new File(filename + ".dbf");
                                if (shapeFile.exists()) {
                                    shapeFile.delete();
                                }
                                if (shxFile.exists()) {
                                    shxFile.delete();
                                }
                                if (!dbfFile.exists()) break block9;
                                dbfFile.delete();
                            }
                        }
                    }
                    BufferedWriter bwCpg = new BufferedWriter(new FileWriter(filename + ".cpg"));
                    bwCpg.write(charset);
                    bwCpg.close();
                    if (!hasGeometry) {
                        String shpFileName = filename + ".shp";
                        this.deleteFileIfExists(shpFileName);
                        shpFileName = filename + ".shx";
                        this.deleteFileIfExists(shpFileName);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error during export", (Throwable)ex);
                    throw ex;
                }
            }

            private void createPrjFile(String filename) {
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
                    bw.write("PROJCS[\"ETRS_1989_UTM_Zone_33N_zE-N\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",5650]]");
                    bw.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"Error while writing .prj file.", (Throwable)e2);
                }
            }

            private void deleteFileIfExists(String fileName) {
                File fileToDelete = new File(fileName);
                if (fileToDelete.exists()) {
                    fileToDelete.delete();
                }
            }

            private String[] getAttributesOfSelectedObjects(String cidsClassName, String attribute) {
                ActiveLayerModel model = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
                TreeSet<String> ids = new TreeSet<String>();
                int index = 0;
                for (MapService service : model.getMapServices().values()) {
                    List selectedFeatureList;
                    CidsLayer cidsLayer;
                    if (!(service instanceof CidsLayer) || !(cidsLayer = (CidsLayer)service).getMetaClass().getName().equals(cidsClassName) || (selectedFeatureList = SelectionManager.getInstance().getSelectedFeatures((AbstractFeatureService)cidsLayer)) == null) continue;
                    for (Feature f : selectedFeatureList) {
                        CidsLayerFeature feature = (CidsLayerFeature)f;
                        ids.add((String)feature.getProperty(attribute));
                    }
                }
                String[] resultArray = new String[ids.size()];
                for (String i : ids) {
                    resultArray[index++] = i;
                }
                if (resultArray.length == 0) {
                    return null;
                }
                return resultArray;
            }

            protected void done() {
                try {
                    Boolean exportResult = (Boolean)this.get();
                    if (exportResult != null && exportResult.booleanValue()) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(ExportAction.class, (String)"ExportAction.actionPerformed().result.success.text"), NbBundle.getMessage(ExportAction.class, (String)"ExportAction.actionPerformed().result.success.title"), 1);
                    } else if (exportResult != null && !exportResult.booleanValue()) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(ExportAction.class, (String)"ExportAction.actionPerformed().result.text"), NbBundle.getMessage(ExportAction.class, (String)"ExportAction.actionPerformed().result.title"), 1);
                    }
                }
                catch (Exception e2) {
                    LOG.error((Object)"Error during export", (Throwable)e2);
                }
            }
        };
        wdt.start();
    }

    public void configure(Element parent) {
    }

    public void masterConfigure(Element parent) {
        Element[] orderedLayers;
        Element actionRootElement = parent.getChild(ROOT_TAG);
        this.servicesToExport = new ArrayList<AbstractFeatureService>();
        this.checks = new ArrayList<AbstractCheckAction>();
        if (actionRootElement == null) {
            return;
        }
        if (!AppBroker.getInstance().isWawiOrAdminUser()) {
            return;
        }
        Element services = actionRootElement.getChild(FEATURE_SERVICES_TAG);
        for (Element curLayerElement : orderedLayers = CidsLayerFactory.orderLayers((Element)services)) {
            ServiceLayer sl = CidsLayerFactory.createLayer((Element)curLayerElement, null, null);
            if (sl instanceof AbstractFeatureService) {
                this.servicesToExport.add((AbstractFeatureService)sl);
                continue;
            }
            LOG.warn((Object)(sl + " is not a feature service and will be ignored for the export."));
        }
        Element checkListElement = actionRootElement.getChild(CHECK_LIST);
        List checkList = checkListElement.getChildren(CHECK);
        for (Element check : checkList) {
            String checkClass = check.getAttributeValue(JAVA_CLASS_ATTR);
            if (checkClass != null) {
                try {
                    Class<?> clazz = Class.forName(checkClass);
                    if (AbstractCheckAction.class.isAssignableFrom(clazz)) {
                        this.checks.add((AbstractCheckAction)clazz.newInstance());
                        continue;
                    }
                    LOG.warn((Object)("The checkclass " + checkClass + " is no instance of AbstractCheckAction"));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Cannot instantiate the check class " + checkClass), (Throwable)e);
                }
                continue;
            }
            LOG.warn((Object)"Check without java class found");
        }
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    public static void main(String[] args) {
        try {
            ExportAction.zipDirectory(new File("/home/therter/tmp/exp"), new File("/home/therter/tmp/exp.zip"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void zipDirectory(File inputDir, File file) throws Exception {
        try (ZipOutputStream out = null;){
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            ExportAction.zipDirectory(inputDir, out, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDirectory(File inputDir, ZipOutputStream out, String dirName) throws Exception {
        byte[] tmp = new byte[256];
        for (File f : inputDir.listFiles()) {
            if (f.isDirectory()) {
                if (dirName.equals("")) {
                    ExportAction.zipDirectory(f, out, f.getName() + "/");
                    continue;
                }
                ExportAction.zipDirectory(f, out, dirName + f.getName() + "/");
                continue;
            }
            ZipEntry entry = new ZipEntry(dirName + f.getName());
            out.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            try {
                int byteCount;
                while ((byteCount = bis.read(tmp, 0, 256)) != -1) {
                    out.write(tmp, 0, byteCount);
                }
            }
            finally {
                out.closeEntry();
                bis.close();
            }
        }
    }

    private class ErrorContainer
    implements Comparable<ErrorContainer> {
        private String errorMessage;
        private String owner;
        private int count = 1;

        public ErrorContainer(String errorMessage, String owner) {
            this.errorMessage = errorMessage;
            this.owner = owner;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void increaseCount() {
            ++this.count;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ErrorContainer) {
                ErrorContainer other = (ErrorContainer)obj;
                if (other.owner.equals(this.owner) && other.errorMessage.equals(this.errorMessage)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
            hash = 17 * hash + (this.owner != null ? this.owner.hashCode() : 0);
            return hash;
        }

        @Override
        public int compareTo(ErrorContainer o) {
            if (this.errorMessage.equals(o.errorMessage)) {
                return this.owner.compareTo(o.owner);
            }
            return this.errorMessage.compareTo(o.errorMessage);
        }
    }
}

