/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.DefaultCidsLayerBindableReferenceCombo;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.cismap.custom.attributerule.ConfirmDialog;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ReleaseAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ReleaseAction.class);
    private static final String FG_BA_CLASS_NAME = "fg_bak";
    private static final String GU_WIWE_CLASS_NAME = "gu_wiwe";
    private static final String FG_BA_LEIS_CLASS_NAME = "fg_ba_leis";
    private static final String FG_BA_TECH_CLASS_NAME = "fg_ba_tech";
    private static final String[] RELEVANT_CLASS_NAMES = new String[]{"fg_bak", "gu_wiwe", "fg_ba_leis", "fg_ba_tech"};
    protected int featureCount = 0;

    public ReleaseAction() {
        String tooltip = NbBundle.getMessage(ReleaseAction.class, (String)"ReleaseAction.ReleaseAction().toolTipText", (Object[])new Object[]{" "});
        this.putValue("ShortDescription", tooltip);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-removefriend.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final CidsLayerFeature[] features = this.getRelevantFeatures(SelectionManager.getInstance().getSelectedFeatures(), true);
        this.featureCount = 0;
        if (features != null && features.length > 0) {
            ConfirmDialog dialog = new ConfirmDialog(AppBroker.getInstance().getWatergisApp(), true, NbBundle.getMessage(ReleaseAction.class, (String)"ReleaseAction.done().title"), NbBundle.getMessage(ReleaseAction.class, (String)"ReleaseAction.done().message", (Object)features.length), NbBundle.getMessage(ReleaseAction.class, (String)"ReleaseAction.done().execute"), NbBundle.getMessage(ReleaseAction.class, (String)"ReleaseAction.done().cancel"));
            dialog.setSize(350, 120);
            StaticSwingTools.showDialog((JDialog)dialog);
            if (dialog.getButtonClicked() != 1) {
                return;
            }
            WaitingDialogThread<TreeSet<AbstractFeatureService>> wdt = new WaitingDialogThread<TreeSet<AbstractFeatureService>>((Frame)AppBroker.getInstance().getWatergisApp(), true, NbBundle.getMessage(ReleaseAction.class, (String)"ReleaseAction.actionPerformed.WaitingDialogThread.message"), null, 100){

                protected TreeSet<AbstractFeatureService> doInBackground() throws Exception {
                    TreeSet<AbstractFeatureService> services = new TreeSet<AbstractFeatureService>(new AbstractFeatureServiceComparator());
                    for (CidsLayerFeature cidsFeature : features) {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("release object with id " + cidsFeature.getId()));
                            }
                            if (cidsFeature.getLayerProperties() != null && cidsFeature.getLayerProperties().getFeatureService() != null) {
                                services.add(cidsFeature.getLayerProperties().getFeatureService());
                            }
                            CidsBean cidsBean = cidsFeature.getBean();
                            CidsBean newWwGr = AppBroker.getInstance().getNiemandWwGr();
                            cidsBean.setProperty("ww_gr", (Object)newWwGr);
                            cidsFeature.setProperty("ww_gr", (Object)newWwGr);
                            DefaultCidsLayerBindableReferenceCombo combo = cidsFeature.getCatalogueCombo("ww_gr");
                            if (combo != null) {
                                for (int i = 0; i < combo.getItemCount(); ++i) {
                                    Object o = combo.getItemAt(i);
                                    if (!(o instanceof CidsLayerFeature) || ((CidsLayerFeature)o).getId() != newWwGr.getPrimaryKeyValue().intValue()) continue;
                                    combo.setSelectedIndex(i);
                                    break;
                                }
                            }
                            if (cidsBean.getProperty("ba_cd") == null || !((String)cidsBean.getProperty("ba_cd")).startsWith((String)AppBroker.getInstance().getNiemandWwGr().getProperty("praefix"))) {
                                String baCd = AppBroker.getInstance().getNiemandWwGr().getProperty("praefix") + ":" + cidsBean.hashCode();
                                cidsBean.setProperty("ba_cd", (Object)baCd);
                                cidsFeature.setProperty("ba_cd", (Object)baCd);
                            }
                            cidsFeature.saveChangesWithoutReload();
                            cidsBean.persist();
                            ++ReleaseAction.this.featureCount;
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Cannot release feature", (Throwable)ex);
                        }
                    }
                    return services;
                }

                protected void done() {
                    try {
                        TreeSet services = (TreeSet)this.get();
                        ReleaseAction.this.refreshServiceAttributeTables(services);
                        AppBroker.getInstance().getWatergisApp().initRouteCombo();
                        ReleaseAction.this.refreshServiceLayer(services);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while releasing objects", (Throwable)e);
                    }
                }
            };
            wdt.start();
        } else {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(ReleaseAction.class, (String)"ReleaseAction.actionPerformed.noFeature.message"), NbBundle.getMessage(ReleaseAction.class, (String)"ReleaseAction.actionPerformed.noFeature.title"), 0);
        }
    }

    protected void refreshServiceAttributeTables(TreeSet<AbstractFeatureService> services) {
        for (AbstractFeatureService f : services) {
            AppBroker.getInstance().getWatergisApp().refreshAttributeTable(f);
        }
    }

    protected void refreshServiceLayer(TreeSet<AbstractFeatureService> services) {
        for (AbstractFeatureService service : services) {
            service.retrieve(true);
        }
    }

    protected CidsLayerFeature[] getRelevantFeatures(List<Feature> features, boolean isRelease) {
        ArrayList<CidsLayerFeature> featureList = new ArrayList<CidsLayerFeature>();
        for (Feature f : features) {
            CidsLayerFeature cidsFeature;
            if (!(f instanceof CidsLayerFeature) || !this.isRelevantClassName((cidsFeature = (CidsLayerFeature)f).getBean().getMetaObject().getMetaClass().getName())) continue;
            if (isRelease && cidsFeature.getBean().hasObjectWritePermission(SessionManager.getSession().getUser()) || !isRelease && cidsFeature.getBean().getProperty("ww_gr").equals(AppBroker.getInstance().getNiemandWwGr())) {
                featureList.add(cidsFeature);
                continue;
            }
            SelectionManager.getInstance().removeSelectedFeatures(f);
        }
        return featureList.toArray(new CidsLayerFeature[featureList.size()]);
    }

    public boolean containsAnyRelevantFeature(List<Feature> features, boolean isRelease) {
        for (Feature f : features) {
            CidsLayerFeature cidsFeature;
            CidsLayer cidsLayer;
            if (!(f instanceof CidsLayerFeature) || !this.isRelevantClassName((cidsLayer = (CidsLayer)(cidsFeature = (CidsLayerFeature)f).getLayerProperties().getFeatureService()).getMetaClass().getName())) continue;
            Object wwGr = cidsFeature.getProperty("ww_gr");
            if (wwGr instanceof CidsBean) {
                wwGr = ((CidsBean)wwGr).getProperty("ww_gr");
            } else if (wwGr instanceof CidsLayerFeature) {
                wwGr = ((CidsLayerFeature)wwGr).getProperty("ww_gr");
            }
            if ((isRelease || wwGr != null && !wwGr.equals(AppBroker.getInstance().getNiemandWwGr().getProperty("ww_gr"))) && (!isRelease || !AppBroker.getInstance().isOwnerWwGr((Integer)wwGr))) continue;
            return true;
        }
        return false;
    }

    private boolean isRelevantClassName(String className) {
        for (String tmp : RELEVANT_CLASS_NAMES) {
            if (!className.equalsIgnoreCase(tmp)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected class AbstractFeatureServiceComparator
    implements Comparator<AbstractFeatureService> {
        protected AbstractFeatureServiceComparator() {
        }

        @Override
        public int compare(AbstractFeatureService o1, AbstractFeatureService o2) {
            return Integer.compare(o1.hashCode(), o2.hashCode());
        }
    }
}

