/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.WatergisApp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SaveProjectAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(SaveProjectAction.class);

    public SaveProjectAction() {
        String tooltip = NbBundle.getMessage(SaveProjectAction.class, (String)"SaveProjectAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(SaveProjectAction.class, (String)"SaveProjectAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(SaveProjectAction.class, (String)"SaveProjectAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-save-floppy.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Save Project");
        }
        this.save();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private void save() {
        File file = StaticSwingTools.chooseFile((String)WatergisApp.getDIRECTORYPATH_WATERGIS(), (boolean)true, (String[])new String[]{"xml"}, (String)NbBundle.getMessage(SaveProjectAction.class, (String)"SaveProjectAction.save.FileFilter.getDescription.return"), (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file != null) {
            ConfigurationManager configurationManager = AppBroker.getConfigManager();
            String name = file.getAbsolutePath();
            AppBroker.getInstance().getWatergisApp().setCurrentLayoutFile(name);
            configurationManager.writeConfiguration(name);
            AppBroker.getInstance().getRecentlyOpenedFilesList().addFile(file);
            String layoutPath = FilenameUtils.getFullPath((String)name) + FilenameUtils.getBaseName((String)name) + ".layout";
            AppBroker.getInstance().getWatergisApp().saveLayout(layoutPath);
        }
    }
}

