/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.bookmarks;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.watergis.Bookmark;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.CreateBookmarkDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class CreateBookmarkAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(CreateBookmarkAction.class);
    private CreateBookmarkDialog bookmarkDialog;

    public CreateBookmarkAction() {
        this((CreateBookmarkDialog)null);
    }

    public CreateBookmarkAction(CreateBookmarkDialog bookmarkDialog) {
        String tooltip = NbBundle.getMessage(CreateBookmarkAction.class, (String)"CreateBookmarkAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(CreateBookmarkAction.class, (String)"CreateBookmarkAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(CreateBookmarkAction.class, (String)"CreateBookmarkAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.bookmarkDialog = bookmarkDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String bookmarkName = this.bookmarkDialog.getBookmarkName().trim();
        if (bookmarkName == null || bookmarkName.equals("")) {
            this.bookmarkDialog.changeTxtNameBG(Color.RED);
        } else {
            Geometry geom = this.createGeometrieInMiddleOfMap();
            Bookmark bookmark = new Bookmark();
            bookmark.setGeometry(geom);
            bookmark.setName(this.bookmarkDialog.getBookmarkName());
            bookmark.setDescription(this.bookmarkDialog.getBookmarkDescription());
            AppBroker.getInstance().getBookmarkManager().add(bookmark);
            this.bookmarkDialog.changeTxtNameBG(Color.WHITE);
            this.bookmarkDialog.dispose();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private Geometry createGeometrieInMiddleOfMap() {
        MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
        XBoundingBox middleOfScreen = (XBoundingBox)mappingComponent.getCurrentBoundingBoxFromCamera();
        return middleOfScreen.getGeometry();
    }
}

