/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.bookmarks;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.watergis.Bookmark;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.ManageBookmarksDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ZoomBookmarkInMapAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ZoomBookmarkInMapAction.class);
    private ManageBookmarksDialog manageBookmarksDialog;

    public ZoomBookmarkInMapAction() {
        this((ManageBookmarksDialog)null);
    }

    public ZoomBookmarkInMapAction(ManageBookmarksDialog manageBookmarksDialog) {
        String tooltip = NbBundle.getMessage(ZoomBookmarkInMapAction.class, (String)"ZoomBookmarkInMapAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(ZoomBookmarkInMapAction.class, (String)"ZoomBookmarkInMapAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(ZoomBookmarkInMapAction.class, (String)"ZoomBookmarkInMapAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.manageBookmarksDialog = manageBookmarksDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Bookmark bookmark = this.manageBookmarksDialog.getSelectedBookmark();
        Geometry geom = bookmark.getGeometry();
        XBoundingBox xbox = new XBoundingBox(geom);
        AppBroker.getInstance().getMappingComponent().gotoBoundingBox((BoundingBox)xbox, true, true, 500);
        this.manageBookmarksDialog.dispose();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

