/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.checks;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKBReader;
import de.cismet.cids.custom.watergis.server.search.RouteProblemsCountAndClasses;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.CidsLayerUtil;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFactory;
import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class AbstractCheckAction
extends AbstractAction {
    protected static final Logger LOG = Logger.getLogger(AbstractCheckAction.class);
    protected boolean isBackgroundCheck = false;
    private boolean exportCheck = false;
    private Map<String, CidsLayer> initialisedService = new HashMap<String, CidsLayer>();

    public AbstractCheckAction() {
    }

    public AbstractCheckAction(boolean isBackgroundCheck) {
        this.isBackgroundCheck = isBackgroundCheck;
    }

    public synchronized AbstractCheckResult startBackgroundCheck() throws Exception {
        boolean originState = this.isBackgroundCheck;
        this.isBackgroundCheck = true;
        AbstractCheckResult result = this.check(false, null);
        this.cleanup();
        this.isBackgroundCheck = originState;
        return result;
    }

    protected abstract AbstractCheckResult check(boolean var1, WaitDialog var2) throws Exception;

    protected abstract boolean startCheckInternal(boolean var1, WaitDialog var2, List<H2FeatureService> var3);

    public boolean startCheck(boolean isExport, WaitDialog wd, List<H2FeatureService> result) {
        this.exportCheck = isExport;
        boolean checkOk = this.startCheckInternal(isExport, wd, result);
        this.cleanup();
        return checkOk;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.startCheck(false, null, null);
        this.cleanup();
    }

    private void cleanup() {
        this.initialisedService.clear();
    }

    public abstract int getProgressSteps();

    protected void increaseProgress(WaitDialog wd, int steps) {
        if (wd != null) {
            wd.increaseProgress(1);
        }
    }

    protected void addService(List<H2FeatureService> result, H2FeatureService service) {
        if (service != null) {
            result.add(service);
        }
    }

    protected int[] getSelectedIds(boolean isExport) {
        String user = AppBroker.getInstance().getOwner();
        int[] selectedIds = null;
        if (this.isBackgroundCheck) {
            return null;
        }
        if (user.equalsIgnoreCase("Administratoren")) {
            user = null;
        }
        if (isExport) {
            if (user == null) {
                selectedIds = this.getIdsOfSelectedObjects("fg_ba");
            }
        } else {
            selectedIds = this.getIdsOfSelectedObjects("fg_ba");
        }
        return selectedIds;
    }

    protected int[] getIdsOfSelectedObjects(String cidsClassName) {
        ActiveLayerModel model = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        TreeSet<Integer> ids = new TreeSet<Integer>();
        int index = 0;
        for (MapService service : model.getMapServices().values()) {
            List selectedFeatureList;
            CidsLayer cidsLayer;
            if (!(service instanceof CidsLayer) || !(cidsLayer = (CidsLayer)service).getMetaClass().getName().equals(cidsClassName) || (selectedFeatureList = SelectionManager.getInstance().getSelectedFeatures((AbstractFeatureService)cidsLayer)) == null) continue;
            for (Feature f : selectedFeatureList) {
                CidsLayerFeature feature = (CidsLayerFeature)f;
                ids.add(feature.getId());
            }
        }
        int[] resultArray = new int[ids.size()];
        for (Integer i : ids) {
            resultArray[index++] = i;
        }
        if (resultArray.length == 0) {
            return null;
        }
        return resultArray;
    }

    protected H2FeatureService analyseByQuery(String query, String tableName) throws Exception {
        User user = SessionManager.getSession().getUser();
        MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(user, query);
        return this.createLocalTopicByMetaObjects(mos, tableName);
    }

    protected H2FeatureService analyseByQuery(MetaClass mc, String query, String tableName) throws Exception {
        FeatureServiceAttribute idAttr;
        CidsLayer cl = this.initialisedService.get(mc.getTableName());
        if (cl == null) {
            cl = new CidsLayer(mc);
            cl.initAndWait();
            this.initialisedService.put(mc.getTableName(), cl);
        }
        if ((idAttr = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("id")) == null) {
            idAttr = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ID");
        }
        if (idAttr == null) {
            LOG.error((Object)"Cannot perform check. ID attribute not found");
            return null;
        }
        String clQuery = cl.decoratePropertyName(idAttr.getName()) + " in (select id from (";
        clQuery = query.endsWith(";") ? clQuery + query.substring(0, query.length() - 1) + ") as a )" : clQuery + query + ") as a )";
        List featureList = cl.getFeatureFactory().createFeatures((Object)clQuery, null, null, 0, 0, null);
        String layerName = tableName + (this.isBackgroundCheck ? "TMP" : "");
        if (featureList != null && !featureList.isEmpty()) {
            H2FeatureService.removeTableIfExists((String)(layerName + "_1"));
            H2FeatureService internalService = new H2FeatureService(this.removeFolderNameFromTableName(layerName), "~/cismap/internalH2", layerName + "_1", null, null, featureList, cl.getOrderedFeatureServiceAttributes());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"create the new data source");
            }
            internalService.initAndWait();
            return internalService;
        }
        return null;
    }

    protected H2FeatureService analyseByCustomSearch(CidsServerSearch search, String tableName, List<FeatureServiceAttribute> featureServiceAttributes) throws Exception {
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, search);
        String layerName = tableName + (this.isBackgroundCheck ? "TMP" : "");
        return this.createLocalTopicByAttributeList(attributes, layerName, featureServiceAttributes);
    }

    protected H2FeatureService createLocalTopicByMetaObjects(MetaObject[] mos, String tableName) throws Exception {
        if (mos.length > 0) {
            ArrayList<DefaultFeatureServiceFeature> featureList = new ArrayList<DefaultFeatureServiceFeature>();
            MetaClass mc = mos[0].getMetaClass();
            CidsLayer cl = this.initialisedService.get(mc.getTableName());
            if (cl == null) {
                cl = new CidsLayer(mc);
                cl.initAndWait();
                this.initialisedService.put(mc.getTableName(), cl);
            }
            CidsLayerInfo layerInfo = CidsLayerUtil.getCidsLayerInfo((MetaClass)mc, (User)SessionManager.getSession().getUser());
            for (MetaObject mo : mos) {
                HashMap<String, Object> properties = new HashMap<String, Object>(layerInfo.getColumnNames().length);
                String[] colNames = layerInfo.getColumnNames();
                CidsBean bean = mo.getBean();
                for (int i = 0; i < colNames.length; ++i) {
                    String key = layerInfo.getColumnNames()[i];
                    Object value = bean.getProperty(layerInfo.getColumnPropertyNames()[i]);
                    properties.put(key, value);
                }
                DefaultFeatureServiceFeature feature = new DefaultFeatureServiceFeature();
                feature.setLayerProperties(cl.getLayerProperties());
                feature.setProperties(properties);
                featureList.add(feature);
            }
            H2FeatureService.removeTableIfExists((String)(tableName + "_1"));
            H2FeatureService internalService = new H2FeatureService(this.removeFolderNameFromTableName(tableName), "~/cismap/internalH2", tableName + "_1", null, null, featureList);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"create the new data source");
            }
            internalService.initAndWait();
            return internalService;
        }
        return null;
    }

    protected ProblemCountAndClasses getErrorObjectsFromTree(String owner, int[] routeIds, int[] classIds, boolean export) throws Exception {
        ArrayList problemCountList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new RouteProblemsCountAndClasses(owner, routeIds, classIds, false, export));
        String count = null;
        ArrayList<String> classes = new ArrayList<String>();
        if (problemCountList != null && !problemCountList.isEmpty()) {
            ArrayList innerList;
            for (int i = 0; i < problemCountList.size() - 1; ++i) {
                innerList = (ArrayList)problemCountList.get(i);
                if (innerList == null || innerList.isEmpty()) continue;
                classes.add((String)innerList.get(0));
            }
            innerList = (ArrayList)problemCountList.get(problemCountList.size() - 1);
            if (innerList != null && !innerList.isEmpty()) {
                count = (String)innerList.get(0);
            }
        }
        if (count != null) {
            ProblemCountAndClasses problems = new ProblemCountAndClasses(count, classes.toArray(new String[classes.size()]));
            return problems;
        }
        return null;
    }

    protected H2FeatureService createLocalTopicByAttributeList(ArrayList<ArrayList> attributes, String tableName, List<FeatureServiceAttribute> featureServiceAttributes) throws Exception {
        if (attributes.size() > 0) {
            ArrayList<DefaultFeatureServiceFeature> featureList = new ArrayList<DefaultFeatureServiceFeature>();
            GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getDefaultCrs()));
            WKBReader wkbReader = new WKBReader(geomFactory);
            int id = 0;
            DefaultLayerProperties layerProperties = new DefaultLayerProperties();
            boolean hasIdField = false;
            layerProperties.setFeatureService((AbstractFeatureService)new H2FeatureService("dummy", "dummy", null, featureServiceAttributes));
            for (int i = 0; i < attributes.size(); ++i) {
                Geometry g = null;
                HashMap<String, Object> properties = new HashMap<String, Object>(featureServiceAttributes.size());
                for (int j = attributes.get(i).size() - 1; j >= 0; --j) {
                    if (featureServiceAttributes.get(j).getName().equalsIgnoreCase("id")) {
                        hasIdField = true;
                    }
                    if (attributes.get(i).get(j) instanceof byte[]) {
                        try {
                            g = wkbReader.read((byte[])attributes.get(i).get(j));
                            properties.put(featureServiceAttributes.get(j).getName(), g);
                        }
                        catch (Exception ex) {
                            properties.put(featureServiceAttributes.get(j).getName(), attributes.get(i).get(j));
                        }
                        continue;
                    }
                    properties.put(featureServiceAttributes.get(j).getName(), attributes.get(i).get(j));
                }
                if (!hasIdField) {
                    properties.put("id", ++id);
                }
                DefaultFeatureServiceFeature lastFeature = new DefaultFeatureServiceFeature(id, g, (LayerProperties)layerProperties);
                lastFeature.setProperties(properties);
                featureList.add(lastFeature);
            }
            H2FeatureService.removeTableIfExists((String)(tableName + "_1"));
            H2FeatureService internalService = new H2FeatureService(this.removeFolderNameFromTableName(tableName), "~/cismap/internalH2", tableName + "_1", featureServiceAttributes, featureList);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"create the new data source");
            }
            internalService.initAndWait();
            return internalService;
        }
        return null;
    }

    private String removeFolderNameFromTableName(String tableName) {
        if (tableName.contains("->")) {
            return tableName.substring(tableName.lastIndexOf("->") + 2);
        }
        return tableName;
    }

    protected void removeServicesFromDb(String[] tableNames) {
        for (String table : tableNames) {
            if (this.isBackgroundCheck) {
                H2FeatureService.removeTableIfExists((String)(table + "TMP_1"));
                continue;
            }
            H2FeatureService.removeTableIfExists((String)(table + "_1"));
        }
        Component capComponent = AppBroker.getInstance().getComponent(ComponentName.CAPABILITIES);
        if (capComponent instanceof CapabilityWidget) {
            CapabilityWidget cap = (CapabilityWidget)capComponent;
            cap.refreshJdbcTrees();
        }
    }

    protected void removeServicesFromLayerModel(String[] tableNames) {
        for (String table : tableNames) {
            this.removeTableFromActiveLayerModel(table + "_1");
        }
    }

    private void removeTableFromActiveLayerModel(String tableNames) {
        MappingModel model = CismapBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap map = model.getRasterServices();
        if (map != null) {
            ArrayList<LayerCollection> collectionsToRemove = new ArrayList<LayerCollection>();
            for (MapService service : map.values()) {
                H2FeatureService h2Service;
                if (!(service instanceof H2FeatureService) || !(h2Service = (H2FeatureService)service).getTableName().equals(tableNames)) continue;
                TreeMap serviceMap = ((ActiveLayerModel)model).getMapServicesAndCollections();
                for (Integer key : serviceMap.keySet()) {
                    LayerCollection coll;
                    Object l = serviceMap.get(key);
                    if (!(l instanceof LayerCollection) || (coll = this.getCollectionWithService((LayerCollection)l, h2Service)) == null) continue;
                    collectionsToRemove.add(coll);
                }
                model.removeLayer((RetrievalServiceLayer)h2Service);
                AttributeTableFactory.getInstance().closeAttributeTable((AbstractFeatureService)h2Service);
            }
            for (int i = 0; i < collectionsToRemove.size(); ++i) {
                LayerCollection col = (LayerCollection)collectionsToRemove.get(i);
                TreeMap serviceMap = ((ActiveLayerModel)model).getMapServicesAndCollections();
                for (Integer key : serviceMap.keySet()) {
                    LayerCollection coll;
                    Object l = serviceMap.get(key);
                    if (!(l instanceof LayerCollection) || (coll = this.getCollectionWithService((LayerCollection)l, col)) == null) continue;
                    collectionsToRemove.add(coll);
                }
                ((ActiveLayerModel)model).removeLayerCollection(col);
            }
        }
    }

    private LayerCollection getCollectionWithService(LayerCollection collection, Object h2Service) {
        if (collection.contains(h2Service) && collection.size() == 1) {
            return collection;
        }
        for (Object subLayer : collection) {
            if (!(subLayer instanceof LayerCollection)) continue;
            return this.getCollectionWithService((LayerCollection)subLayer, h2Service);
        }
        return null;
    }

    protected void refreshTree() {
        ThemeLayerWidget tree = (ThemeLayerWidget)AppBroker.getInstance().getComponent(ComponentName.TREE);
        tree.updateTree();
    }

    protected void refreshMap() {
        if (AppBroker.getInstance().getMappingComponent() != null) {
            AppBroker.getInstance().getMappingComponent().refresh();
        }
    }

    protected void showService(H2FeatureService service) {
        String folder = service.getTableName();
        if (folder.contains("->")) {
            folder = service.getTableName().substring(0, service.getTableName().lastIndexOf("->"));
        }
        this.showService(service, folder);
    }

    protected void showService(H2FeatureService service, String folder) {
        ActiveLayerModel model = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        LayerCollection layerCollection = null;
        ArrayList<LayerCollection> pathObjects = new ArrayList<LayerCollection>();
        if (folder != null) {
            String[] tokens;
            for (String subFolder : tokens = folder.split("->")) {
                Object tmp;
                int i;
                boolean found;
                if (layerCollection != null) {
                    found = false;
                    for (i = 0; i < layerCollection.size(); ++i) {
                        tmp = layerCollection.get(i);
                        if (!(tmp instanceof LayerCollection) || !((LayerCollection)tmp).getName().equals(subFolder)) continue;
                        layerCollection = (LayerCollection)tmp;
                        pathObjects.add(layerCollection);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    LayerCollection newLayerCollection = new LayerCollection();
                    newLayerCollection.setName(subFolder);
                    layerCollection = newLayerCollection;
                    model.addEmptyLayerCollection(new TreePath(pathObjects.toArray()), layerCollection);
                    pathObjects.add(newLayerCollection);
                    continue;
                }
                found = false;
                for (i = 0; i < model.getChildCount(model.getRoot()); ++i) {
                    tmp = model.getChild(model.getRoot(), i);
                    if (!(tmp instanceof LayerCollection) || !((LayerCollection)tmp).getName().equals(subFolder)) continue;
                    layerCollection = (LayerCollection)tmp;
                    pathObjects.add(layerCollection);
                    found = true;
                    break;
                }
                if (found) continue;
                layerCollection = new LayerCollection();
                layerCollection.setName(subFolder);
                model.addEmptyLayerCollection(layerCollection);
                pathObjects.add(layerCollection);
            }
        }
        if (layerCollection != null) {
            model.registerRetrievalServiceLayer((RetrievalServiceLayer)service);
            layerCollection.add((Object)service);
        } else {
            model.addLayer((RetrievalServiceLayer)service);
        }
        Component capComponent = AppBroker.getInstance().getComponent(ComponentName.CAPABILITIES);
        if (capComponent instanceof CapabilityWidget) {
            CapabilityWidget cap = (CapabilityWidget)capComponent;
            cap.refreshJdbcTrees();
        }
    }

    protected static class ProblemCountAndClasses {
        private int count;
        private String classes;

        public ProblemCountAndClasses(String count, String[] classes) {
            try {
                this.count = Integer.parseInt(count);
            }
            catch (NumberFormatException ex) {
                LOG.error((Object)"Cannot parse problem count", (Throwable)ex);
            }
            if (classes == null || classes.length == 0) {
                this.classes = "";
            } else {
                for (String cl : classes) {
                    this.classes = this.classes == null ? cl : this.classes + ", " + cl;
                }
            }
        }

        public int getCount() {
            return this.count;
        }

        public String getClasses() {
            return this.classes;
        }
    }
}

