/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.checks;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.custom.watergis.server.search.BaWithIncompleteProfCoverage;
import de.cismet.cids.custom.watergis.server.search.FgBakCount;
import de.cismet.cids.custom.watergis.server.search.MergeBaBbef;
import de.cismet.cids.custom.watergis.server.search.MergeBaProf;
import de.cismet.cids.custom.watergis.server.search.MergeBaSbef;
import de.cismet.cids.custom.watergis.server.search.MergeBaUbef;
import de.cismet.cids.custom.watergis.server.search.OverlappedBBefWithProf;
import de.cismet.cids.custom.watergis.server.search.OverlappedBBefWithR;
import de.cismet.cids.custom.watergis.server.search.OverlappedProf;
import de.cismet.cids.custom.watergis.server.search.OverlappedProfWithR;
import de.cismet.cids.custom.watergis.server.search.OverlappedSBefWithProf;
import de.cismet.cids.custom.watergis.server.search.OverlappedSBefWithR;
import de.cismet.cids.custom.watergis.server.search.OverlappedUbefWithR;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.checks.AbstractCheckAction;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class AusbauCheckAction
extends AbstractCheckAction {
    private static final MetaClass FG_BA_SBEF = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_sbef");
    private static final MetaClass FG_BA_UBEF = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_ubef");
    private static final MetaClass FG_BA_BBEF = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_bbef");
    private static final MetaClass FG_BA_PROF = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_prof");
    private static final MetaClass FG_BA_RL = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_rl");
    private static final MetaClass FG_BA_D = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_d");
    private static final MetaClass FG_BA_DUE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_due");
    private static final int[] USED_CLASS_IDS = new int[]{FG_BA_SBEF != null ? FG_BA_SBEF.getId() : -1, FG_BA_UBEF != null ? FG_BA_UBEF.getId() : -1, FG_BA_BBEF != null ? FG_BA_BBEF.getId() : -1, FG_BA_PROF != null ? FG_BA_PROF.getId() : -1, FG_BA_RL != null ? FG_BA_RL.getId() : -1, FG_BA_D != null ? FG_BA_D.getId() : -1, FG_BA_DUE != null ? FG_BA_DUE.getId() : -1};
    private static String QUERY_PROF_ATTR;
    private static String QUERY_SBEF_ATTR;
    private static String QUERY_UBEF_ATTR;
    private static String QUERY_BBEF_ATTR;
    private static final String CHECK_AUSBAU_BBEFPROFBBEF__UEBERLAPPUNG_AT = "Pr\u00fcfungen->Ausbau->BBEF->PROF/BBEF: \u00dcberlappung/Attribute";
    private static final String CHECK_AUSBAU_SBEFPROFSBEF__UEBERLAPPUNG_AT = "Pr\u00fcfungen->Ausbau->SBEF->PROF/SBEF: \u00dcberlappung/Attribute";
    private static final String CHECK_AUSBAU_BBEFBBEF__UEBERLAPPUNG_MIT_R = "Pr\u00fcfungen->Ausbau->BBEF->BBEF: \u00dcberlappung mit RL/D/D\u00fc";
    private static final String CHECK_AUSBAU_UBEFUBEF__UEBERLAPPUNG_MIT_R = "Pr\u00fcfungen->Ausbau->UBEF->UBEF: \u00dcberlappung mit RL/D/D\u00fc";
    private static final String CHECK_AUSBAU_SBEFSBEF__UEBERLAPPUNG_MIT_R = "Pr\u00fcfungen->Ausbau->SBEF->SBEF: \u00dcberlappung mit RL/D/D\u00fc";
    private static final String CHECK_AUSBAU_PROFPROF__UEBERLAPPUNG_MIT_R = "Pr\u00fcfungen->Ausbau->PROF->PROF: \u00dcberlappung mit RL/D/D\u00fc";
    private static final String CHECK_AUSBAU_PROFPROF__UEBERLAPPUNG__THEMA = "Pr\u00fcfungen->Ausbau->PROF->PROF: \u00dcberlappung im Thema";
    private static final String CHECK_AUSBAU_PROFPROF__LUECKE_IM__THEMA = "Pr\u00fcfungen->Ausbau->PROF->PROF: L\u00fccke im Thema";
    private static final String CHECK_AUSBAU_UBEFUBEF__ATTRIBUTE = "Pr\u00fcfungen->Ausbau->UBEF->UBEF: Attribute";
    private static final String CHECK_AUSBAU_BBEFBBEF__ATTRIBUTE = "Pr\u00fcfungen->Ausbau->BBEF->BBEF: Attribute";
    private static final String CHECK_AUSBAU_SBEFSBEF__ATTRIBUTE = "Pr\u00fcfungen->Ausbau->SBEF->SBEF: Attribute";
    private static final String CHECK_AUSBAU_PROFPROF__ATTRIBUTE = "Pr\u00fcfungen->Ausbau->PROF->PROF: Attribute";
    private static String[] ALL_CHECKS;
    private boolean successful = true;

    public AusbauCheckAction() {
        this(false);
    }

    public AusbauCheckAction(boolean isBackgroundCheck) {
        super(isBackgroundCheck);
        String tooltip = NbBundle.getMessage(AusbauCheckAction.class, (String)"AusbauCheckAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(AusbauCheckAction.class, (String)"AusbauCheckAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-zoom.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public int getProgressSteps() {
        return 17;
    }

    @Override
    public boolean startCheckInternal(final boolean isExport, WaitDialog wd, List<H2FeatureService> result) {
        if (isExport) {
            try {
                CheckResult cr = this.check(isExport, wd);
                if (result != null) {
                    this.addService(result, cr.getBbefAttr());
                    this.addService(result, cr.getBbefGeschl());
                    this.addService(result, cr.getBbefOverlapsAttr());
                    this.addService(result, cr.getProfAttr());
                    this.addService(result, cr.getProfGeschl());
                    this.addService(result, cr.getProfHole());
                    this.addService(result, cr.getProfOverlaps());
                    this.addService(result, cr.getSbefAttr());
                    this.addService(result, cr.getSbefGeschl());
                    this.addService(result, cr.getSbefOverlapsAttr());
                    this.addService(result, cr.getUbefAttr());
                    this.addService(result, cr.getUbefGeschl());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while performing check", (Throwable)e);
                return false;
            }
            return true;
        }
        int[] selectedIds = this.getIdsOfSelectedObjects("fg_ba");
        String message = selectedIds == null ? "Es werden alle Routen gepr\u00fcft" : "Es werden die " + selectedIds.length + " selektierten Routen gepr\u00fcft";
        int ans = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), message, "Pr\u00fcfung starten", 2, 1);
        if (ans == 2) {
            return false;
        }
        WaitingDialogThread<CheckResult> wdt = new WaitingDialogThread<CheckResult>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(AusbauCheckAction.class, (String)"AusbauCheckAction.actionPerformed().dialog"), null, 100){

            protected CheckResult doInBackground() throws Exception {
                this.wd.setMax(AusbauCheckAction.this.getProgressSteps());
                return AusbauCheckAction.this.check(isExport, this.wd);
            }

            protected void done() {
                try {
                    CheckResult result = (CheckResult)this.get();
                    AusbauCheckAction.this.removeServicesFromLayerModel(ALL_CHECKS);
                    if (isExport) {
                        return;
                    }
                    if (result.getProblemTreeObjectCount() == null || result.getProblemTreeObjectCount().getCount() == 0) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(AusbauCheckAction.class, (String)"AusbauCheckAction.actionPerformed().result.text.withoutProblems", (Object[])new Object[]{result.getBakCount(), result.getProfAttrErrors(), result.getSbefAttrErrors(), result.getUbefAttrErrors(), result.getBbefAttrErrors(), result.getProfGeschlErrors(), result.getSbefGeschlErrors(), result.getUbefGeschlErrors(), result.getBbefGeschlErrors(), result.getProfOverlapsErrors(), result.getProfHoleErrors(), result.getSbefOverlapsAttrErrors(), result.getBbefOverlapsAttrErrors(), 0}), NbBundle.getMessage(AusbauCheckAction.class, (String)"AusbauCheckAction.actionPerformed().result.title"), 1);
                    } else {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(AusbauCheckAction.class, (String)"AusbauCheckAction.actionPerformed().result.text", (Object[])new Object[]{result.getBakCount(), result.getProfAttrErrors(), result.getSbefAttrErrors(), result.getUbefAttrErrors(), result.getBbefAttrErrors(), result.getProfGeschlErrors(), result.getSbefGeschlErrors(), result.getUbefGeschlErrors(), result.getBbefGeschlErrors(), result.getProfOverlapsErrors(), result.getProfHoleErrors(), result.getSbefOverlapsAttrErrors(), result.getBbefOverlapsAttrErrors(), result.getProblemTreeObjectCount().getCount(), result.getProblemTreeObjectCount().getClasses()}), NbBundle.getMessage(AusbauCheckAction.class, (String)"AusbauCheckAction.actionPerformed().result.title"), 1);
                    }
                    if (result.getBbefOverlapsAttr() != null) {
                        AusbauCheckAction.this.showService(result.getBbefOverlapsAttr());
                    }
                    if (result.getBbefGeschl() != null) {
                        AusbauCheckAction.this.showService(result.getBbefGeschl());
                    }
                    if (result.getBbefAttr() != null) {
                        AusbauCheckAction.this.showService(result.getBbefAttr());
                    }
                    if (result.getUbefGeschl() != null) {
                        AusbauCheckAction.this.showService(result.getUbefGeschl());
                    }
                    if (result.getUbefAttr() != null) {
                        AusbauCheckAction.this.showService(result.getUbefAttr());
                    }
                    if (result.getSbefOverlapsAttr() != null) {
                        AusbauCheckAction.this.showService(result.getSbefOverlapsAttr());
                    }
                    if (result.getSbefGeschl() != null) {
                        AusbauCheckAction.this.showService(result.getSbefGeschl());
                    }
                    if (result.getSbefAttr() != null) {
                        AusbauCheckAction.this.showService(result.getSbefAttr());
                    }
                    if (result.getProfHole() != null) {
                        AusbauCheckAction.this.showService(result.getProfHole());
                    }
                    if (result.getProfOverlaps() != null) {
                        AusbauCheckAction.this.showService(result.getProfOverlaps());
                    }
                    if (result.getProfGeschl() != null) {
                        AusbauCheckAction.this.showService(result.getProfGeschl());
                    }
                    if (result.getProfAttr() != null) {
                        AusbauCheckAction.this.showService(result.getProfAttr());
                    }
                    AusbauCheckAction.this.refreshTree();
                    AusbauCheckAction.this.refreshMap();
                }
                catch (Exception e) {
                    AbstractCheckAction.LOG.error((Object)"Error while performing the ausbau analyse.", (Throwable)e);
                    AusbauCheckAction.this.successful = false;
                }
            }
        };
        wdt.start();
        return this.successful;
    }

    @Override
    protected CheckResult check(boolean isExport, WaitDialog wd) throws Exception {
        ArrayList innerList;
        ArrayList countList;
        CheckResult result = new CheckResult();
        String user = AppBroker.getInstance().getOwner();
        int[] selectedIds = this.getSelectedIds(isExport);
        if (user.equalsIgnoreCase("Administratoren")) {
            user = null;
        }
        if ((countList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new FgBakCount(user, selectedIds, null))) != null && !countList.isEmpty() && (innerList = (ArrayList)countList.get(0)) != null && !innerList.isEmpty() && innerList.get(0) instanceof Number) {
            result.setBakCount(((Number)innerList.get(0)).intValue());
        }
        this.removeServicesFromDb(ALL_CHECKS);
        MergeBaProf mergeProf = new MergeBaProf(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeProf);
        this.increaseProgress(wd, 1);
        MergeBaSbef mergeSbef = new MergeBaSbef(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeSbef);
        this.increaseProgress(wd, 1);
        MergeBaUbef mergeUbef = new MergeBaUbef(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeUbef);
        this.increaseProgress(wd, 1);
        MergeBaBbef mergeBBef = new MergeBaBbef(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeBBef);
        this.increaseProgress(wd, 1);
        ArrayList<FeatureServiceAttribute> baProfServiceAttributeDefinition = new ArrayList<FeatureServiceAttribute>();
        FeatureServiceAttribute serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        baProfServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        baProfServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ww_gr", String.valueOf(4), true);
        baProfServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_cd", String.valueOf(12), true);
        baProfServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_von", String.valueOf(8), true);
        baProfServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_bis", String.valueOf(8), true);
        baProfServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("laenge", String.valueOf(8), true);
        baProfServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_date", String.valueOf(93), true);
        baProfServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_user", String.valueOf(12), true);
        baProfServiceAttributeDefinition.add(serviceAttribute);
        boolean useExpCond = user != null;
        boolean export = isExport && useExpCond;
        String expCondition = isExport && useExpCond ? " exists(select id from dlm25w.fg_ba_exp_complete where owner = '" + user + "' and bak_id = bak.id)" : "false";
        String query = useExpCond ? String.format(QUERY_BBEF_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_BBEF_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setBbefAttr(this.analyseByQuery(FG_BA_BBEF, query, CHECK_AUSBAU_BBEFBBEF__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        result.setUbefGeschl(this.analyseByCustomSearch((CidsServerSearch)new OverlappedUbefWithR(user, selectedIds, export), CHECK_AUSBAU_UBEFUBEF__UEBERLAPPUNG_MIT_R, baProfServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_PROF_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_PROF_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setProfAttr(this.analyseByQuery(FG_BA_PROF, query, CHECK_AUSBAU_PROFPROF__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_UBEF_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_UBEF_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setUbefAttr(this.analyseByQuery(FG_BA_UBEF, query, CHECK_AUSBAU_UBEFUBEF__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        result.setProfHole(this.analyseByCustomSearch((CidsServerSearch)new BaWithIncompleteProfCoverage(user, selectedIds, export), CHECK_AUSBAU_PROFPROF__LUECKE_IM__THEMA, baProfServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setProfOverlaps(this.analyseByCustomSearch((CidsServerSearch)new OverlappedProf(user, selectedIds, export), CHECK_AUSBAU_PROFPROF__UEBERLAPPUNG__THEMA, baProfServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setProfGeschl(this.analyseByCustomSearch((CidsServerSearch)new OverlappedProfWithR(user, selectedIds, export), CHECK_AUSBAU_PROFPROF__UEBERLAPPUNG_MIT_R, baProfServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_SBEF_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_SBEF_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setSbefAttr(this.analyseByQuery(FG_BA_SBEF, query, CHECK_AUSBAU_SBEFSBEF__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        result.setSbefGeschl(this.analyseByCustomSearch((CidsServerSearch)new OverlappedSBefWithR(user, selectedIds, export), CHECK_AUSBAU_SBEFSBEF__UEBERLAPPUNG_MIT_R, baProfServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setBbefGeschl(this.analyseByCustomSearch((CidsServerSearch)new OverlappedBBefWithR(user, selectedIds, export), CHECK_AUSBAU_BBEFBBEF__UEBERLAPPUNG_MIT_R, baProfServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setSbefOverlapsAttr(this.analyseByCustomSearch((CidsServerSearch)new OverlappedSBefWithProf(user, selectedIds, export), CHECK_AUSBAU_SBEFPROFSBEF__UEBERLAPPUNG_AT, baProfServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setBbefOverlapsAttr(this.analyseByCustomSearch((CidsServerSearch)new OverlappedBBefWithProf(user, selectedIds, export), CHECK_AUSBAU_BBEFPROFBBEF__UEBERLAPPUNG_AT, baProfServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setProblemTreeObjectCount(this.getErrorObjectsFromTree(user, selectedIds, USED_CLASS_IDS, isExport));
        if (result.getBbefAttr() != null) {
            result.setBbefAttrErrors(result.getBbefAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getBbefGeschl() != null) {
            result.setBbefGeschlErrors(result.getBbefGeschl().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getBbefOverlapsAttr() != null) {
            result.setBbefOverlapsAttrErrors(result.getBbefOverlapsAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getProfAttr() != null) {
            result.setProfAttrErrors(result.getProfAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getProfGeschl() != null) {
            result.setProfGeschlErrors(result.getProfGeschl().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getProfHole() != null) {
            result.setProfHoleErrors(result.getProfHole().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getProfOverlaps() != null) {
            result.setProfOverlapsErrors(result.getProfOverlaps().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getSbefAttr() != null) {
            result.setSbefAttrErrors(result.getSbefAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getSbefGeschl() != null) {
            result.setSbefGeschlErrors(result.getSbefGeschl().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getSbefOverlapsAttr() != null) {
            result.setSbefOverlapsAttrErrors(result.getSbefOverlapsAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getUbefAttr() != null) {
            result.setUbefAttrErrors(result.getUbefAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getUbefGeschl() != null) {
            result.setUbefGeschlErrors(result.getUbefGeschl().getFeatureCount(null));
            this.successful = false;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    static {
        ALL_CHECKS = new String[]{CHECK_AUSBAU_BBEFBBEF__ATTRIBUTE, CHECK_AUSBAU_BBEFBBEF__UEBERLAPPUNG_MIT_R, CHECK_AUSBAU_BBEFPROFBBEF__UEBERLAPPUNG_AT, CHECK_AUSBAU_PROFPROF__ATTRIBUTE, CHECK_AUSBAU_PROFPROF__LUECKE_IM__THEMA, CHECK_AUSBAU_PROFPROF__UEBERLAPPUNG_MIT_R, CHECK_AUSBAU_PROFPROF__UEBERLAPPUNG__THEMA, CHECK_AUSBAU_SBEFPROFSBEF__UEBERLAPPUNG_AT, CHECK_AUSBAU_SBEFSBEF__ATTRIBUTE, CHECK_AUSBAU_SBEFSBEF__UEBERLAPPUNG_MIT_R, CHECK_AUSBAU_UBEFUBEF__ATTRIBUTE, CHECK_AUSBAU_UBEFUBEF__UEBERLAPPUNG_MIT_R};
        if (FG_BA_SBEF != null && FG_BA_UBEF != null && FG_BA_BBEF != null && FG_BA_PROF != null) {
            User user = SessionManager.getSession().getUser();
            QUERY_PROF_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_PROF.getID() + ", bef." + FG_BA_PROF.getPrimaryKey() + " from dlm25w.fg_ba_prof bef\njoin dlm25w.fg_ba_linie linie on (bef.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_profil kpr on (kpr.id = bef.profil)\nleft join dlm25w.k_l_st kst on (kst.id = bef.l_st)\nleft join dlm25w.k_traeger kt on (kt.id = bef.traeger)\nleft join dlm25w.k_zust_kl kz on (kz.id = bef.zust_kl)\nwhere\n (%1$s is null or von.route = any(%1$s)) and (kpr.profil is null or (bef.l_st is not null and kst.l_st is null) or obj_nr is null\nor (bef.traeger is not null and kt.traeger is null)\nor (bef.zust_kl is not null and kz.zust_kl is null)\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 100))\nor (ho_e  is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a  is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle  is not null and (gefaelle < -10 or gefaelle > 100))\nor (bv_re  is not null and bv_re <> 0 and (bv_re < 0.1 or bv_re > 15))\nor (bh_re  is not null and (bh_re <= 0 or bh_re > 15))\nor (bl_re  is not null and (bl_re <= 0 or bl_re > 30))\nor (bv_li  is not null and bv_li <> 0 and (bv_li < 0.1 or bv_li > 15))\nor (bh_li  is not null and (bh_li <= 0 or bh_li > 15))\nor (bl_li  is not null and (bl_li <= 0 or bl_li > 30))\nor (mw  is not null and (mw <= 0 or mw > 30))\nor abs(bis.wert - von.wert) < 0.5\nor (ho_e is not null and ho_a is not null and (ho_e < ho_a))\nor (kpr.profil = 're' and (bv_re is not null and bv_re <> 0))\nor (kpr.profil = 're' and ((bv_re is not null and bv_re <> 0) or (bv_li is not null and bv_li <> 0) ) )\nor (kpr.profil = 'tr' and ((bv_re is not null and bv_re = 0) and (bv_li is not null and bv_li = 0) ) )\n);" : "select distinct " + FG_BA_PROF.getID() + ", bef." + FG_BA_PROF.getPrimaryKey() + " from dlm25w.fg_ba_prof bef\njoin dlm25w.fg_ba_linie linie on (bef.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_profil kpr on (kpr.id = bef.profil)\nleft join dlm25w.k_l_st kst on (kst.id = bef.l_st)\nleft join dlm25w.k_traeger kt on (kt.id = bef.traeger)\nleft join dlm25w.k_zust_kl kz on (kz.id = bef.zust_kl)\nwhere\n (%1$s is null or von.route = any(%1$s)) and (kpr.profil is null or (bef.l_st is not null and kst.l_st is null) or obj_nr is null\nor (bef.traeger is not null and kt.traeger is null)\nor (bef.zust_kl is not null and kz.zust_kl is null)\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 100))\nor (ho_e  is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a  is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle  is not null and (gefaelle < -10 or gefaelle > 100))\nor (bv_re  is not null and bv_re <> 0 and (bv_re < 0.1 or bv_re > 15))\nor (bh_re  is not null and (bh_re <= 0 or bh_re > 15))\nor (bl_re  is not null and (bl_re <= 0 or bl_re > 30))\nor (bv_li  is not null and bv_li <> 0 and (bv_li < 0.1 or bv_li > 15))\nor (bh_li  is not null and (bh_li <= 0 or bh_li > 15))\nor (bl_li  is not null and (bl_li <= 0 or bl_li > 30))\nor (mw  is not null and (mw <= 0 or mw > 30))\nor abs(bis.wert - von.wert) < 0.5\nor (ho_e is not null and ho_a is not null and (ho_e < ho_a))\nor (kpr.profil = 're' and (bv_re is not null and bv_re <> 0))\nor (kpr.profil = 're' and ((bv_re is not null and bv_re <> 0) or (bv_li is not null and bv_li <> 0) ) )\nor (kpr.profil = 'tr' and ((bv_re is not null and bv_re = 0) and (bv_li is not null and bv_li = 0) ) )\n) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s);";
            QUERY_UBEF_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_UBEF.getID() + ", bef." + FG_BA_UBEF.getPrimaryKey() + " from dlm25w.fg_ba_ubef bef\njoin dlm25w.fg_ba_linie linie on (bef.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_ubef kbef on (kbef.id = bef.ubef)\nleft join dlm25w.k_l_rl krl on (krl.id = bef.l_rl)\nleft join dlm25w.k_l_st kst on (kst.id = bef.l_st)\nleft join dlm25w.k_material km on (km.id = bef.material)\nleft join dlm25w.k_traeger kt on (kt.id = bef.traeger)\nleft join dlm25w.k_zust_kl kz on (kz.id = bef.zust_kl)\nwhere\n(%1$s is null or von.route = any(%1$s)) and (kbef.ubef is null or (bef.l_st is not null and kst.l_st is null) or krl.l_rl is null or obj_nr is null\nor (bef.material is not null and km.material is null) or (bef.traeger is not null and kt.traeger is null)\nor (bef.zust_kl is not null and kz.zust_kl is null)\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 10))\nor (ho_d_o  is not null and (ho_d_o <= 0 or ho_d_o > 15))\nor abs(bis.wert - von.wert) < 0.5\nor (kbef.ubef = 'Fa' and km.material not in ('H-Rsg', 'Kok'))\nor (kbef.ubef = 'Gtr' and km.material not in ('B', 'K'))\nor (kbef.ubef = 'Mte' and km.material <> 'Vl')\nor (kbef.ubef = 'Pfr' and km.material not in ('B', 'H', 'K', 'St'))\nor (kbef.ubef = 'Pl' and km.material not in ('B'))\nor (kbef.ubef = 'SP' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Wb'))\nor (kbef.ubef = 'Spw' and km.material not in ('H', 'K', 'St', 'St-B', 'Ste-Gab'))\nor (kbef.ubef = 'Wist\u00fc' and km.material not in ('B', 'K', 'St', 'St-B'))\nor (bef.esw is not null and (bef.esw < 0 or bef.esw > 1)) )" : "select distinct " + FG_BA_UBEF.getID() + ", bef." + FG_BA_UBEF.getPrimaryKey() + " from dlm25w.fg_ba_ubef bef\njoin dlm25w.fg_ba_linie linie on (bef.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_ubef kbef on (kbef.id = bef.ubef)\nleft join dlm25w.k_l_rl krl on (krl.id = bef.l_rl)\nleft join dlm25w.k_l_st kst on (kst.id = bef.l_st)\nleft join dlm25w.k_material km on (km.id = bef.material)\nleft join dlm25w.k_traeger kt on (kt.id = bef.traeger)\nleft join dlm25w.k_zust_kl kz on (kz.id = bef.zust_kl)\nwhere\n(%1$s is null or von.route = any(%1$s)) and (kbef.ubef is null or (bef.l_st is not null and kst.l_st is null) or krl.l_rl is null or obj_nr is null\nor (bef.material is not null and km.material is null) or (bef.traeger is not null and kt.traeger is null)\nor (bef.zust_kl is not null and kz.zust_kl is null)\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 10))\nor (ho_d_o  is not null and (ho_d_o <= 0 or ho_d_o > 15))\nor abs(bis.wert - von.wert) < 0.5\nor (kbef.ubef = 'Fa' and km.material not in ('H-Rsg', 'Kok'))\nor (kbef.ubef = 'Gtr' and km.material not in ('B', 'K'))\nor (kbef.ubef = 'Mte' and km.material <> 'Vl')\nor (kbef.ubef = 'Pfr' and km.material not in ('B', 'H', 'K', 'St'))\nor (kbef.ubef = 'Pl' and km.material not in ('B'))\nor (kbef.ubef = 'SP' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Wb'))\nor (kbef.ubef = 'Spw' and km.material not in ('H', 'K', 'St', 'St-B', 'Ste-Gab'))\nor (kbef.ubef = 'Wist\u00fc' and km.material not in ('B', 'K', 'St', 'St-B'))\nor (bef.esw is not null and (bef.esw < 0 or bef.esw > 1)) ) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s);";
            QUERY_SBEF_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_SBEF.getID() + ", bef." + FG_BA_SBEF.getPrimaryKey() + " from dlm25w.fg_ba_sbef bef\njoin dlm25w.fg_ba_linie linie on (bef.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_sbef kbef on (kbef.id = bef.sbef)\nleft join dlm25w.k_material km on (km.id = bef.material)\nwhere\n(%1$s is null or von.route = any(%1$s)) and (kbef.sbef is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 100))\nor (ho_e  is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a  is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle  is not null and (gefaelle < -10 or gefaelle > 100))\nor (ho_d_e  is not null and (ho_d_e < 0 or ho_d_e > 5))\nor (ho_d_a  is not null and (ho_d_a < 0 or ho_d_a > 5))\nor abs(bis.wert - von.wert) < 0.1\nor (ho_e is not null and ho_a is not null and (ho_e < ho_a))\nor (kbef.sbef = 'Buh' and km.material not in ('H', 'K', 'Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wab'))\nor (kbef.sbef = 'Pf' and km.material not in ('B', 'H', 'K'))\nor (kbef.sbef = 'Pfl' and km.material not in ('B', 'Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wb'))\nor (kbef.sbef = 'Pfr' and km.material not in ('B', 'H', 'K'))\nor (kbef.sbef = 'Pl' and km.material not in ('B'))\nor (kbef.sbef = 'Rgl' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wb'))\nor (kbef.sbef in ('So-Ab', 'So-Abt', 'So-Gl', 'So-Ra') and km.material <> 'B')\nor (kbef.sbef = 'SP' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wb'))\nor (kbef.sbef = 'St\u00f6ste' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Wb'))\nor (kbef.sbef in ('Sw-Gru', 'Sw-So', 'Sw-St\u00fc') and km.material <> 'B')\nor (kbef.sbef = 'Wu' and km.material <> 'H')\nor (bef.esw is not null and (bef.esw < 0 or bef.esw > 1)) )" : "select distinct " + FG_BA_SBEF.getID() + ", bef." + FG_BA_SBEF.getPrimaryKey() + " from dlm25w.fg_ba_sbef bef\njoin dlm25w.fg_ba_linie linie on (bef.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_sbef kbef on (kbef.id = bef.sbef)\nleft join dlm25w.k_material km on (km.id = bef.material)\nwhere\n(%1$s is null or von.route = any(%1$s)) and (kbef.sbef is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 100))\nor (ho_e  is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a  is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle  is not null and (gefaelle < -10 or gefaelle > 100))\nor (ho_d_e  is not null and (ho_d_e < 0 or ho_d_e > 5))\nor (ho_d_a  is not null and (ho_d_a < 0 or ho_d_a > 5))\nor abs(bis.wert - von.wert) < 0.1\nor (ho_e is not null and ho_a is not null and (ho_e < ho_a))\nor (kbef.sbef = 'Buh' and km.material not in ('H', 'K', 'Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wab'))\nor (kbef.sbef = 'Gtr' and km.material not in ('B', 'Ste-Fs', 'K'))\nor (kbef.sbef = 'Pf' and km.material not in ('B', 'H', 'K'))\nor (kbef.sbef = 'Pfl' and km.material not in ('B', 'Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wb'))\nor (kbef.sbef = 'Pfr' and km.material not in ('B', 'H', 'K'))\nor (kbef.sbef = 'Pl' and km.material not in ('B'))\nor (kbef.sbef = 'Rgl' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wb'))\nor (kbef.sbef in ('So-Ab', 'So-Abt', 'So-Gl', 'So-Ra') and km.material <> 'B')\nor (kbef.sbef = 'SP' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wb'))\nor (kbef.sbef = 'St\u00f6ste' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Wb'))\nor (kbef.sbef in ('Sw-Gru', 'Sw-So', 'Sw-St\u00fc') and km.material <> 'B')\nor (kbef.sbef = 'Wu' and km.material <> 'H')\nor (bef.esw is not null and (bef.esw < 0 or bef.esw > 1)) ) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s);";
            QUERY_BBEF_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_BBEF.getID() + ", bef." + FG_BA_BBEF.getPrimaryKey() + " from dlm25w.fg_ba_bbef bef\njoin dlm25w.fg_ba_linie linie on (bef.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_bbef kbef on (kbef.id = bef.bbef)\nleft join dlm25w.k_l_rl krl on (krl.id = bef.l_rl)\nleft join dlm25w.k_material km on (km.id = bef.material)\nwhere\n(%1$s is null or von.route = any(%1$s)) and (kbef.bbef is null or krl.l_rl is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 30))\nor (ho_d_o  is not null and (ho_d_o <= 0 or ho_d_o > 15))\nor (ho_d_u  is not null and (ho_d_u < 0 or ho_d_u > 15))\nor (kbef.bbef = 'Rin' and (abs(bis.wert - von.wert) <= 0 or abs(bis.wert - von.wert) > 10))\nor (kbef.bbef <> 'Rin' and (abs(bis.wert - von.wert) <= 0.5))\nor (ho_d_o is not null and ho_d_u is not null and (ho_d_o <= ho_d_u))\nor (kbef.bbef = 'Berme' and km.material is not null)\nor (kbef.bbef = 'Fa' and km.material not in ('H-Rsg', 'Kok', 'H'))\nor (kbef.bbef = 'SP' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wb'))\nor (kbef.bbef = 'Gtr' and km.material not in ('B', 'K', 'Ste-Fs'))\nor (kbef.bbef = 'Mte' and km.material not in ('Ste-Gab', 'Vl'))\nor (kbef.bbef = 'Pfl' and km.material not in ('B'))\nor (kbef.bbef = 'Pfr' and km.material not in ('B', 'H', 'K', 'St'))\nor (kbef.bbef = 'Pl' and km.material <> 'B')\nor (kbef.bbef = 'Rin' and km.material not in ('B', 'St-B', 'Ste', 'Ste-Fs', 'Ste-Mw', 'Ste-Wb'))\nor (kbef.bbef = 'Spreit' and km.material <> 'H')\nor (bef.esw is not null and (bef.esw < 0 or bef.esw > 1)) ) " : "select distinct " + FG_BA_BBEF.getID() + ", bef." + FG_BA_BBEF.getPrimaryKey() + " from dlm25w.fg_ba_bbef bef\njoin dlm25w.fg_ba_linie linie on (bef.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_bbef kbef on (kbef.id = bef.bbef)\nleft join dlm25w.k_l_rl krl on (krl.id = bef.l_rl)\nleft join dlm25w.k_material km on (km.id = bef.material)\nwhere\n(%1$s is null or von.route = any(%1$s)) and (kbef.bbef is null or krl.l_rl is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 30))\nor (ho_d_o  is not null and (ho_d_o <= 0 or ho_d_o > 15))\nor (ho_d_u  is not null and (ho_d_u < 0 or ho_d_u > 15))\nor (kbef.bbef = 'Rin' and (abs(bis.wert - von.wert) <= 0 or abs(bis.wert - von.wert) > 10))\nor (kbef.bbef <> 'Rin' and (abs(bis.wert - von.wert) <= 0.5))\nor (ho_d_o is not null and ho_d_u is not null and (ho_d_o <= ho_d_u))\nor (kbef.bbef = 'Berme' and km.material is not null)\nor (kbef.bbef = 'Fa' and km.material not in ('H-Rsg', 'Kok', 'H'))\nor (kbef.bbef = 'SP' and km.material not in ('Ste', 'Ste-Fs', 'Ste-Gab', 'Ste-Wb'))\nor (kbef.bbef = 'Gtr' and km.material not in ('B', 'K', 'Ste-Fs'))\nor (kbef.bbef = 'Mte' and km.material not in ('Ste-Gab', 'Vl'))\nor (kbef.bbef = 'Pfl' and km.material not in ('B'))\nor (kbef.bbef = 'Pfr' and km.material not in ('B', 'H', 'K', 'St'))\nor (kbef.bbef = 'Pl' and km.material <> 'B')\nor (kbef.bbef = 'Rin' and km.material not in ('B', 'St-B', 'Ste', 'Ste-Fs', 'Ste-Mw', 'Ste-Wb'))\nor (kbef.bbef = 'Spreit' and km.material <> 'H')\nor (bef.esw is not null and (bef.esw < 0 or bef.esw > 1)) ) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s);";
        }
    }

    protected static class CheckResult
    extends AbstractCheckResult {
        private static final String[] CHECK_NAMES = new String[]{"PROF_ATTR", "SBEF_ATTR", "BBEF_ATTR", "UBEF_ATTR", "PROF_GESCHL", "SBEF_GESCHL", "UBEF_GESCHL", "BBEF_GESCHL", "PROF_OVERLAPS", "PROF_HOLE", "SBEF_OVERLAPS", "BBEF_OVERLAPS"};
        private int bakCount;
        private int profAttrErrors;
        private int sbefAttrErrors;
        private int bbefAttrErrors;
        private int ubefAttrErrors;
        private int profGeschlErrors;
        private int sbefGeschlErrors;
        private int ubefGeschlErrors;
        private int bbefGeschlErrors;
        private int profOverlapsErrors;
        private int profHoleErrors;
        private int sbefOverlapsAttrErrors;
        private int bbefOverlapsAttrErrors;
        private AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount;
        private H2FeatureService profAttr;
        private H2FeatureService sbefAttr;
        private H2FeatureService bbefAttr;
        private H2FeatureService ubefAttr;
        private H2FeatureService profGeschl;
        private H2FeatureService sbefGeschl;
        private H2FeatureService ubefGeschl;
        private H2FeatureService bbefGeschl;
        private H2FeatureService profOverlaps;
        private H2FeatureService profHole;
        private H2FeatureService sbefOverlapsAttr;
        private H2FeatureService bbefOverlapsAttr;

        protected CheckResult() {
        }

        public void setProblemTreeObjectCount(AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount) {
            this.problemTreeObjectCount = problemTreeObjectCount;
        }

        public int getProfAttrErrors() {
            return this.profAttrErrors;
        }

        public void setProfAttrErrors(int profAttrErrors) {
            this.profAttrErrors = profAttrErrors;
        }

        public int getSbefAttrErrors() {
            return this.sbefAttrErrors;
        }

        public void setSbefAttrErrors(int sbefAttrErrors) {
            this.sbefAttrErrors = sbefAttrErrors;
        }

        public int getBbefAttrErrors() {
            return this.bbefAttrErrors;
        }

        public void setBbefAttrErrors(int bbefAttrErrors) {
            this.bbefAttrErrors = bbefAttrErrors;
        }

        public int getUbefAttrErrors() {
            return this.ubefAttrErrors;
        }

        public void setUbefAttrErrors(int ubefAttrErrors) {
            this.ubefAttrErrors = ubefAttrErrors;
        }

        public int getProfGeschlErrors() {
            return this.profGeschlErrors;
        }

        public void setProfGeschlErrors(int profGeschlErrors) {
            this.profGeschlErrors = profGeschlErrors;
        }

        public int getSbefGeschlErrors() {
            return this.sbefGeschlErrors;
        }

        public void setSbefGeschlErrors(int sbefGeschlErrors) {
            this.sbefGeschlErrors = sbefGeschlErrors;
        }

        public int getUbefGeschlErrors() {
            return this.ubefGeschlErrors;
        }

        public void setUbefGeschlErrors(int ubefGeschlErrors) {
            this.ubefGeschlErrors = ubefGeschlErrors;
        }

        public int getBbefGeschlErrors() {
            return this.bbefGeschlErrors;
        }

        public void setBbefGeschlErrors(int bbefGeschlErrors) {
            this.bbefGeschlErrors = bbefGeschlErrors;
        }

        public int getProfOverlapsErrors() {
            return this.profOverlapsErrors;
        }

        public void setProfOverlapsErrors(int profOverlapsErrors) {
            this.profOverlapsErrors = profOverlapsErrors;
        }

        public int getProfHoleErrors() {
            return this.profHoleErrors;
        }

        public void setProfHoleErrors(int profHoleErrors) {
            this.profHoleErrors = profHoleErrors;
        }

        public int getSbefOverlapsAttrErrors() {
            return this.sbefOverlapsAttrErrors;
        }

        public void setSbefOverlapsAttrErrors(int sbefOverlapsAttrErrors) {
            this.sbefOverlapsAttrErrors = sbefOverlapsAttrErrors;
        }

        public int getBbefOverlapsAttrErrors() {
            return this.bbefOverlapsAttrErrors;
        }

        public void setBbefOverlapsAttrErrors(int bbefOverlapsAttrErrors) {
            this.bbefOverlapsAttrErrors = bbefOverlapsAttrErrors;
        }

        public H2FeatureService getProfAttr() {
            return this.profAttr;
        }

        public void setProfAttr(H2FeatureService profAttr) {
            this.profAttr = profAttr;
        }

        public H2FeatureService getSbefAttr() {
            return this.sbefAttr;
        }

        public void setSbefAttr(H2FeatureService sbefAttr) {
            this.sbefAttr = sbefAttr;
        }

        public H2FeatureService getBbefAttr() {
            return this.bbefAttr;
        }

        public void setBbefAttr(H2FeatureService bbefAttr) {
            this.bbefAttr = bbefAttr;
        }

        public H2FeatureService getUbefAttr() {
            return this.ubefAttr;
        }

        public void setUbefAttr(H2FeatureService ubefAttr) {
            this.ubefAttr = ubefAttr;
        }

        public H2FeatureService getProfGeschl() {
            return this.profGeschl;
        }

        public void setProfGeschl(H2FeatureService profGeschl) {
            this.profGeschl = profGeschl;
        }

        public H2FeatureService getSbefGeschl() {
            return this.sbefGeschl;
        }

        public void setSbefGeschl(H2FeatureService sbefGeschl) {
            this.sbefGeschl = sbefGeschl;
        }

        public H2FeatureService getUbefGeschl() {
            return this.ubefGeschl;
        }

        public void setUbefGeschl(H2FeatureService ubefGeschl) {
            this.ubefGeschl = ubefGeschl;
        }

        public H2FeatureService getBbefGeschl() {
            return this.bbefGeschl;
        }

        public void setBbefGeschl(H2FeatureService bbefGeschl) {
            this.bbefGeschl = bbefGeschl;
        }

        public H2FeatureService getProfOverlaps() {
            return this.profOverlaps;
        }

        public void setProfOverlaps(H2FeatureService profOverlaps) {
            this.profOverlaps = profOverlaps;
        }

        public H2FeatureService getProfHole() {
            return this.profHole;
        }

        public void setProfHole(H2FeatureService profHole) {
            this.profHole = profHole;
        }

        public H2FeatureService getSbefOverlapsAttr() {
            return this.sbefOverlapsAttr;
        }

        public void setSbefOverlapsAttr(H2FeatureService sbefOverlapsAttr) {
            this.sbefOverlapsAttr = sbefOverlapsAttr;
        }

        public H2FeatureService getBbefOverlapsAttr() {
            return this.bbefOverlapsAttr;
        }

        public void setBbefOverlapsAttr(H2FeatureService bbefOverlapsAttr) {
            this.bbefOverlapsAttr = bbefOverlapsAttr;
        }

        public int getBakCount() {
            return this.bakCount;
        }

        public void setBakCount(int bakCount) {
            this.bakCount = bakCount;
        }

        @Override
        public String[] getCheckNames() {
            return CHECK_NAMES;
        }

        @Override
        public AbstractCheckAction.ProblemCountAndClasses getProblemTreeObjectCount() {
            return this.problemTreeObjectCount;
        }

        @Override
        public int getErrorsPerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.profAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.sbefAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.bbefAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.ubefAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.profGeschlErrors;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.sbefGeschlErrors;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.ubefGeschlErrors;
            }
            if (checkName.equals(CHECK_NAMES[7])) {
                return this.bbefGeschlErrors;
            }
            if (checkName.equals(CHECK_NAMES[8])) {
                return this.profOverlapsErrors;
            }
            if (checkName.equals(CHECK_NAMES[9])) {
                return this.profHoleErrors;
            }
            if (checkName.equals(CHECK_NAMES[10])) {
                return this.sbefOverlapsAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[11])) {
                return this.bbefOverlapsAttrErrors;
            }
            return 0;
        }

        @Override
        public H2FeatureService getErrorTablePerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.profAttr;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.sbefAttr;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.bbefAttr;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.ubefAttr;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.profGeschl;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.sbefGeschl;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.ubefGeschl;
            }
            if (checkName.equals(CHECK_NAMES[7])) {
                return this.bbefGeschl;
            }
            if (checkName.equals(CHECK_NAMES[8])) {
                return this.profOverlaps;
            }
            if (checkName.equals(CHECK_NAMES[9])) {
                return this.profHole;
            }
            if (checkName.equals(CHECK_NAMES[10])) {
                return this.sbefOverlapsAttr;
            }
            if (checkName.equals(CHECK_NAMES[11])) {
                return this.bbefOverlapsAttr;
            }
            return null;
        }
    }
}

