/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.checks;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.custom.watergis.server.search.FgBakCount;
import de.cismet.cids.custom.watergis.server.search.HaltungWithHolesCoverage;
import de.cismet.cids.custom.watergis.server.search.MergeBaAnll;
import de.cismet.cids.custom.watergis.server.search.MergeBaAnlp;
import de.cismet.cids.custom.watergis.server.search.MergeBaD;
import de.cismet.cids.custom.watergis.server.search.MergeBaDue;
import de.cismet.cids.custom.watergis.server.search.MergeBaEa;
import de.cismet.cids.custom.watergis.server.search.MergeBaKr;
import de.cismet.cids.custom.watergis.server.search.MergeBaScha;
import de.cismet.cids.custom.watergis.server.search.MergeBaSchw;
import de.cismet.cids.custom.watergis.server.search.MergeBaWehr;
import de.cismet.cids.custom.watergis.server.search.OverlappedAnllWithR;
import de.cismet.cids.custom.watergis.server.search.OverlappedRlWithRDDue;
import de.cismet.cids.custom.watergis.server.search.RlWithHole;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.checks.AbstractCheckAction;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class BauwerkeCheckAction
extends AbstractCheckAction {
    private static final MetaClass FG_BAK = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak");
    private static final MetaClass FG_BA_RL = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_rl");
    private static final MetaClass FG_BA_D = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_d");
    private static final MetaClass FG_BA_DUE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_due");
    private static final MetaClass FG_BA_ANLL = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_anll");
    private static final MetaClass FG_BA_ANLP = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_anlp");
    private static final MetaClass FG_BA_KR = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_kr");
    private static final MetaClass FG_BA_EA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_ea");
    private static final MetaClass FG_BA_SCHA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_scha");
    private static final MetaClass FG_BA_WEHR = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_wehr");
    private static final MetaClass FG_BA_SCHW = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_schw");
    private static final int[] USED_CLASS_IDS = new int[]{FG_BA_ANLL != null ? FG_BA_ANLL.getId() : -1, FG_BA_ANLP != null ? FG_BA_ANLP.getId() : -1, FG_BA_KR != null ? FG_BA_KR.getId() : -1, FG_BA_EA != null ? FG_BA_EA.getId() : -1, FG_BA_SCHA != null ? FG_BA_SCHA.getId() : -1, FG_BA_WEHR != null ? FG_BA_WEHR.getId() : -1, FG_BA_SCHW != null ? FG_BA_SCHW.getId() : -1, FG_BA_RL != null ? FG_BA_RL.getId() : -1, FG_BA_D != null ? FG_BA_D.getId() : -1, FG_BA_DUE != null ? FG_BA_DUE.getId() : -1};
    private static String QUERY_DUE_ATTR;
    private static String QUERY_D_ATTR;
    private static String QUERY_RL_ATTR;
    private static String QUERY_ANLL_ATTR;
    private static String QUERY_ANLP_ATTR;
    private static String QUERY_KR_ATTR;
    private static String QUERY_EA_ATTR;
    private static String QUERY_SCHA_ATTR;
    private static String QUERY_WEHR_ATTR;
    private static String QUERY_SCHW_ATTR;
    private static String QUERY_SCHA_DISTANCE;
    private static String QUERY_SCHW_DISTANCE;
    private static String QUERY_WEHR_DISTANCE;
    private static String QUERY_KR_DISTANCE;
    private static String QUERY_SCHA_OFFEN;
    private static String QUERY_ANLP_OFFEN;
    private static String QUERY_ANLP_GESCHL;
    private static String QUERY_ANLP_ESW;
    private static String QUERY_KR_ESW;
    private static String QUERY_EA_ESW;
    private static String QUERY_KR_MARKED_TWICE;
    private static String QUERY_KR_KEIN_FG_BA;
    private static String QUERY_KR_INVALID;
    private static final String CHECKS_BAUWERKE_KR_KR_DOPPELTE__MARKIERUNG = "Pr\u00fcfungen->Bauwerke->Kr->Kr: doppelte Markierung";
    private static final String CHECKS_BAUWERKE_ANLL_ANLL_AUF_GESCHLOSSEN = "Pr\u00fcfungen->Bauwerke->Anll->Anll: auf geschlossenem Gerinne";
    private static final String CHECKS_BAUWERKE_EA_EA__ESW_FUER_GESCHLOSSEN = "Pr\u00fcfungen->Bauwerke->Ea->Ea: Esw f\u00fcr geschlossenes Gerinne";
    private static final String CHECKS_BAUWERKE_EA_EA_AUF_GESCHLOSSENEM_G = "Pr\u00fcfungen->Bauwerke->Ea->Ea: auf geschlossenem Gerinne";
    private static final String CHECKS_BAUWERKE_KR_KR__ESW_FUER_GESCHLOSSEN = "Pr\u00fcfungen->Bauwerke->Kr->Kr: Esw f\u00fcr geschlossenes Gerinne";
    private static final String CHECKS_BAUWERKE_ANLP_ANLP__ESW_FUER_GESCHLO = "Pr\u00fcfungen->Bauwerke->Anlp->Anlp: Esw f\u00fcr geschlossenes Gerinne";
    private static final String CHECKS_BAUWERKE_ANLP_ANLP_AUF_GESCHLOSSEN = "Pr\u00fcfungen->Bauwerke->Anlp->Anlp: falsch auf geschlossenem Gerinne";
    private static final String CHECKS_BAUWERKE_ANLP_ANLP_AUF_OFFENEM__GER = "Pr\u00fcfungen->Bauwerke->Anlp->Anlp: falsch auf offenem Gerinne";
    private static final String CHECKS_BAUWERKE_WEHR_WEHR_AUF_GESCHLOSSEN = "Pr\u00fcfungen->Bauwerke->Wehr->Wehr: auf geschlossenem Gerinne";
    private static final String CHECKS_BAUWERKE_SCHA_SCHA_AUF_OFFENEM__GER = "Pr\u00fcfungen->Bauwerke->Scha->Scha: auf offenem Gerinne";
    private static final String CHECKS_BAUWERKE_KR_KR_DOPPELTZU_NAH = "Pr\u00fcfungen->Bauwerke->Kr->Kr: doppelt/zu nah";
    private static final String CHECKS_BAUWERKE_KR_KEIN_FG_BA = "Pr\u00fcfungen->Bauwerke->Kr->Kr: keine Kreuzung";
    private static final String CHECKS_BAUWERKE_KR_INVALID = "Pr\u00fcfungen->Bauwerke->Kr->Kr: unzul\u00e4ssige Profillage";
    private static final String CHECKS_BAUWERKE_SCHW_SCHW_DOPPELTZU_NAH = "Pr\u00fcfungen->Bauwerke->Schw->Schw: doppelt/zu nah";
    private static final String CHECKS_BAUWERKE_WEHR_WEHR_DOPPELTZU_NAH = "Pr\u00fcfungen->Bauwerke->Wehr->Wehr: doppelt/zu nah";
    private static final String CHECKS_BAUWERKE_SCHA_SCHA_DOPPELTZU_NAH = "Pr\u00fcfungen->Bauwerke->Scha->Scha: doppelt/zu nah";
    private static final String CHECKS_BAUWERKE_RL_RL__UEBERLAPPUNG = "Pr\u00fcfungen->Bauwerke->RL/D/D\u00fc->RL/D/D\u00fc: \u00dcberlappung";
    private static final String CHECKS_HALTUNG_HOLES = "Pr\u00fcfungen->Bauwerke->Haltung->L\u00f6cher";
    private static final String CHECKS_BAUWERKE_RL_RL__LUECKE = "Pr\u00fcfungen->Bauwerke->RL/D/D\u00fc->RL/D/D\u00fc: L\u00fccke";
    private static final String CHECKS_BAUWERKE_DD__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->RL/D/D\u00fc->D: Attribute";
    private static final String CHECKS_BAUWERKE_WEHR_WEHR__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->Wehr->Wehr: Attribute";
    private static final String CHECKS_BAUWERKE_SCHW_SCHW__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->Schw->Schw: Attribute";
    private static final String CHECKS_BAUWERKE_SCHA_SCHA__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->Scha->Scha: Attribute";
    private static final String CHECKS_BAUWERKE_RL_RL__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->RL/D/D\u00fc->RL: Attribute";
    private static final String CHECKS_BAUWERKE_KR_KR__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->Kr->Kr: Attribute";
    private static final String CHECKS_BAUWERKE_EA_EA__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->Ea->Ea: Attribute";
    private static final String CHECKS_BAUWERKE_DUE_DUE__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->RL/D/D\u00fc->Due: Attribute";
    private static final String CHECKS_BAUWERKE_ANLP_ANLP__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->Anlp->Anlp: Attribute";
    private static final String CHECKS_BAUWERKE_ANLL_ANLL__ATTRIBUTE = "Pr\u00fcfungen->Bauwerke->Anll->Anll: Attribute";
    private static final String[] ALL_CHECKS;
    private boolean successful = true;

    public BauwerkeCheckAction() {
        this(false);
    }

    public BauwerkeCheckAction(boolean isBackgroundCheck) {
        super(isBackgroundCheck);
        String tooltip = NbBundle.getMessage(BauwerkeCheckAction.class, (String)"BauwerkeCheckAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(BauwerkeCheckAction.class, (String)"BauwerkeCheckAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-zoom.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public int getProgressSteps() {
        return 31;
    }

    @Override
    public boolean startCheckInternal(final boolean isExport, WaitDialog wd, List<H2FeatureService> result) {
        if (isExport) {
            try {
                CheckResult cr = this.check(isExport, wd);
                if (result != null) {
                    this.addService(result, cr.getAnllAttr());
                    this.addService(result, cr.getAnllGeschl());
                    this.addService(result, cr.getAnlpAttr());
                    this.addService(result, cr.getAnlpEsw());
                    this.addService(result, cr.getAnlpGeschlossen());
                    this.addService(result, cr.getAnlpOffen());
                    this.addService(result, cr.getDueAttr());
                    this.addService(result, cr.getEaAttr());
                    this.addService(result, cr.getEaEsw());
                    this.addService(result, cr.getKrAttr());
                    this.addService(result, cr.getKrDistance());
                    this.addService(result, cr.getKrEsw());
                    this.addService(result, cr.getKrMarkedTwice());
                    this.addService(result, cr.getRlAttr());
                    this.addService(result, cr.getRlHole());
                    this.addService(result, cr.getRlOverlapps());
                    this.addService(result, cr.getSchaAttr());
                    this.addService(result, cr.getSchaDistance());
                    this.addService(result, cr.getSchaOffen());
                    this.addService(result, cr.getSchwAttr());
                    this.addService(result, cr.getSchwDistance());
                    this.addService(result, cr.getWehrAttr());
                    this.addService(result, cr.getWehrDistance());
                    this.addService(result, cr.getdAttr());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while performing check", (Throwable)e);
                return false;
            }
            return true;
        }
        WaitingDialogThread<CheckResult> wdt = new WaitingDialogThread<CheckResult>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(BauwerkeCheckAction.class, (String)"BauwerkeCheckAction.actionPerformed().dialog"), null, 100){

            protected CheckResult doInBackground() throws Exception {
                this.wd.setMax(BauwerkeCheckAction.this.getProgressSteps());
                return BauwerkeCheckAction.this.check(isExport, this.wd);
            }

            protected void done() {
                try {
                    CheckResult result = (CheckResult)this.get();
                    BauwerkeCheckAction.this.removeServicesFromLayerModel(ALL_CHECKS);
                    if (isExport) {
                        return;
                    }
                    if (result.getProblemTreeObjectCount() == null || result.getProblemTreeObjectCount().getCount() == 0) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(BauwerkeCheckAction.class, (String)"BauwerkeCheckAction.actionPerformed().result.text.withoutProblems", (Object[])new Object[]{result.getBakCount(), result.getRlAttrErrors(), result.getdAttrErrors(), result.getDueAttrErrors(), result.getSchaAttrErrors(), result.getWehrAttrErrors(), result.getSchwAttrErrors(), result.getAnlpAttrErrors(), result.getAnllAttrErrors(), result.getKrAttrErrors(), result.getEaAttrErrors(), result.getRlHoleErrors(), result.getRlOverlappsErrors(), result.getSchaDistanceError() + result.getSchaOffenError(), result.getWehrDistanceError(), result.getSchwDistanceError(), result.getAnlpEswError() + result.getAnlpGeschlossenError() + result.getAnlpOffenError(), result.getAnllGeschlError(), result.getKrDistanceError() + result.getKrEswError() + result.getKrMarkedTwiceError() + result.getKrFgBaError() + result.getKrInvalidError(), result.getEaEswError(), 0}), NbBundle.getMessage(BauwerkeCheckAction.class, (String)"BauwerkeCheckAction.actionPerformed().result.title"), 1);
                    } else {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(BauwerkeCheckAction.class, (String)"BauwerkeCheckAction.actionPerformed().result.text", (Object[])new Object[]{result.getBakCount(), result.getRlAttrErrors(), result.getdAttrErrors(), result.getDueAttrErrors(), result.getSchaAttrErrors(), result.getWehrAttrErrors(), result.getSchwAttrErrors(), result.getAnlpAttrErrors(), result.getAnllAttrErrors(), result.getKrAttrErrors(), result.getEaAttrErrors(), result.getRlHoleErrors(), result.getRlOverlappsErrors(), result.getSchaDistanceError() + result.getSchaOffenError(), result.getWehrDistanceError(), result.getSchwDistanceError(), result.getAnlpEswError() + result.getAnlpGeschlossenError() + result.getAnlpOffenError(), result.getAnllGeschlError(), result.getKrDistanceError() + result.getKrEswError() + result.getKrMarkedTwiceError() + result.getKrFgBaError() + result.getKrInvalidError(), result.getEaEswError(), result.getProblemTreeObjectCount().getCount(), result.getProblemTreeObjectCount().getClasses()}), NbBundle.getMessage(BauwerkeCheckAction.class, (String)"BauwerkeCheckAction.actionPerformed().result.title"), 1);
                    }
                    if (result.getEaEsw() != null) {
                        BauwerkeCheckAction.this.showService(result.getEaEsw());
                    }
                    if (result.getEaAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getEaAttr());
                    }
                    if (result.getKrEsw() != null) {
                        BauwerkeCheckAction.this.showService(result.getKrEsw());
                    }
                    if (result.getKrInvalid() != null) {
                        BauwerkeCheckAction.this.showService(result.getKrInvalid());
                    }
                    if (result.getKrMarkedTwice() != null) {
                        BauwerkeCheckAction.this.showService(result.getKrMarkedTwice());
                    }
                    if (result.getKrFgBa() != null) {
                        BauwerkeCheckAction.this.showService(result.getKrFgBa());
                    }
                    if (result.getKrDistance() != null) {
                        BauwerkeCheckAction.this.showService(result.getKrDistance());
                    }
                    if (result.getKrAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getKrAttr());
                    }
                    if (result.getAnllGeschl() != null) {
                        BauwerkeCheckAction.this.showService(result.getAnllGeschl());
                    }
                    if (result.getAnllAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getAnllAttr());
                    }
                    if (result.getAnlpEsw() != null) {
                        BauwerkeCheckAction.this.showService(result.getAnlpEsw());
                    }
                    if (result.getAnlpGeschlossen() != null) {
                        BauwerkeCheckAction.this.showService(result.getAnlpGeschlossen());
                    }
                    if (result.getAnlpOffen() != null) {
                        BauwerkeCheckAction.this.showService(result.getAnlpOffen());
                    }
                    if (result.getAnlpAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getAnlpAttr());
                    }
                    if (result.getSchwDistance() != null) {
                        BauwerkeCheckAction.this.showService(result.getSchwDistance());
                    }
                    if (result.getSchwAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getSchwAttr());
                    }
                    if (result.getWehrDistance() != null) {
                        BauwerkeCheckAction.this.showService(result.getWehrDistance());
                    }
                    if (result.getWehrAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getWehrAttr());
                    }
                    if (result.getSchaOffen() != null) {
                        BauwerkeCheckAction.this.showService(result.getSchaOffen());
                    }
                    if (result.getSchaDistance() != null) {
                        BauwerkeCheckAction.this.showService(result.getSchaDistance());
                    }
                    if (result.getSchaAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getSchaAttr());
                    }
                    if (result.getRlOverlapps() != null) {
                        BauwerkeCheckAction.this.showService(result.getRlOverlapps());
                    }
                    if (result.getRlHole() != null) {
                        BauwerkeCheckAction.this.showService(result.getRlHole());
                    }
                    if (result.getDueAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getDueAttr());
                    }
                    if (result.getdAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getdAttr());
                    }
                    if (result.getRlAttr() != null) {
                        BauwerkeCheckAction.this.showService(result.getRlAttr());
                    }
                    BauwerkeCheckAction.this.refreshTree();
                    BauwerkeCheckAction.this.refreshMap();
                }
                catch (Exception e) {
                    AbstractCheckAction.LOG.error((Object)"Error while performing the bauwerke analyse.", (Throwable)e);
                    BauwerkeCheckAction.this.successful = false;
                }
            }
        };
        wdt.start();
        return this.successful;
    }

    @Override
    protected CheckResult check(boolean isExport, WaitDialog wd) throws Exception {
        ArrayList innerList;
        CheckResult result = new CheckResult();
        String user = AppBroker.getInstance().getOwner();
        int[] selectedIds = this.getSelectedIds(isExport);
        if (user.equalsIgnoreCase("Administratoren")) {
            user = null;
        }
        this.removeServicesFromDb(ALL_CHECKS);
        ArrayList countList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new FgBakCount(user, selectedIds, null));
        if (countList != null && !countList.isEmpty() && (innerList = (ArrayList)countList.get(0)) != null && !innerList.isEmpty() && innerList.get(0) instanceof Number) {
            result.setBakCount(((Number)innerList.get(0)).intValue());
        }
        MergeBaD mergeD = new MergeBaD(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeD);
        this.increaseProgress(wd, 1);
        MergeBaDue mergeDue = new MergeBaDue(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeDue);
        this.increaseProgress(wd, 1);
        MergeBaScha mergeScha = new MergeBaScha(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeScha);
        this.increaseProgress(wd, 1);
        MergeBaWehr mergeWehr = new MergeBaWehr(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeWehr);
        this.increaseProgress(wd, 1);
        MergeBaSchw mergeSchw = new MergeBaSchw(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeSchw);
        this.increaseProgress(wd, 1);
        MergeBaAnlp mergeAnlp = new MergeBaAnlp(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeAnlp);
        this.increaseProgress(wd, 1);
        MergeBaAnll mergeAnll = new MergeBaAnll(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeAnll);
        this.increaseProgress(wd, 1);
        MergeBaKr mergeKr = new MergeBaKr(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeKr);
        this.increaseProgress(wd, 1);
        MergeBaEa mergeEa = new MergeBaEa(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeEa);
        this.increaseProgress(wd, 1);
        result.setProblemTreeObjectCount(this.getErrorObjectsFromTree(user, selectedIds, USED_CLASS_IDS, isExport));
        ArrayList<FeatureServiceAttribute> serviceAttributeDefinition = new ArrayList<FeatureServiceAttribute>();
        FeatureServiceAttribute serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ww_gr", String.valueOf(4), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_cd", String.valueOf(12), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_von", String.valueOf(8), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_bis", String.valueOf(8), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("laenge", String.valueOf(8), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_date", String.valueOf(93), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_user", String.valueOf(12), true);
        serviceAttributeDefinition.add(serviceAttribute);
        boolean useExpCond = user != null;
        boolean export = isExport && useExpCond;
        String expCondition = isExport && useExpCond ? " exists(select id from dlm25w.fg_ba_exp_complete where owner = '" + user + "' and bak_id = bak.id)" : "false";
        String query = useExpCond ? String.format(QUERY_ANLL_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_ANLL_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setAnllAttr(this.analyseByQuery(FG_BA_ANLL, query, CHECKS_BAUWERKE_ANLL_ANLL__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_ANLP_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_ANLP_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setAnlpAttr(this.analyseByQuery(FG_BA_ANLP, query, CHECKS_BAUWERKE_ANLP_ANLP__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_DUE_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_DUE_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setDueAttr(this.analyseByQuery(FG_BA_DUE, query, CHECKS_BAUWERKE_DUE_DUE__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_EA_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_EA_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setEaAttr(this.analyseByQuery(FG_BA_EA, query, CHECKS_BAUWERKE_EA_EA__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_KR_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_KR_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setKrAttr(this.analyseByQuery(FG_BA_KR, query, CHECKS_BAUWERKE_KR_KR__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_RL_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_RL_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setRlAttr(this.analyseByQuery(FG_BA_RL, query, CHECKS_BAUWERKE_RL_RL__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_SCHA_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_SCHA_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setSchaAttr(this.analyseByQuery(FG_BA_SCHA, query, CHECKS_BAUWERKE_SCHA_SCHA__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_SCHW_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_SCHW_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setSchwAttr(this.analyseByQuery(FG_BA_SCHW, query, CHECKS_BAUWERKE_SCHW_SCHW__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_WEHR_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_WEHR_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setWehrAttr(this.analyseByQuery(FG_BA_WEHR, query, CHECKS_BAUWERKE_WEHR_WEHR__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_D_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_D_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setdAttr(this.analyseByQuery(FG_BA_D, query, CHECKS_BAUWERKE_DD__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        result.setRlHole(this.analyseByCustomSearch((CidsServerSearch)new RlWithHole(user, selectedIds, export), CHECKS_BAUWERKE_RL_RL__LUECKE, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setRlOverlapps(this.analyseByCustomSearch((CidsServerSearch)new OverlappedRlWithRDDue(user, selectedIds, export), CHECKS_BAUWERKE_RL_RL__UEBERLAPPUNG, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_SCHA_DISTANCE, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_SCHA_DISTANCE, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setSchaDistance(this.analyseByQuery(FG_BA_SCHA, query, CHECKS_BAUWERKE_SCHA_SCHA_DOPPELTZU_NAH));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_WEHR_DISTANCE, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_WEHR_DISTANCE, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setWehrDistance(this.analyseByQuery(FG_BA_WEHR, query, CHECKS_BAUWERKE_WEHR_WEHR_DOPPELTZU_NAH));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_SCHW_DISTANCE, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_SCHW_DISTANCE, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setSchwDistance(this.analyseByQuery(FG_BA_SCHW, query, CHECKS_BAUWERKE_SCHW_SCHW_DOPPELTZU_NAH));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_KR_DISTANCE, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_KR_DISTANCE, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setKrDistance(this.analyseByQuery(FG_BA_KR, query, CHECKS_BAUWERKE_KR_KR_DOPPELTZU_NAH));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_KR_KEIN_FG_BA, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_KR_KEIN_FG_BA, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setKrFgBa(this.analyseByQuery(FG_BA_KR, query, CHECKS_BAUWERKE_KR_KEIN_FG_BA));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_KR_INVALID, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_KR_INVALID, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setKrInvalid(this.analyseByQuery(FG_BA_KR, query, CHECKS_BAUWERKE_KR_INVALID));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_SCHA_OFFEN, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_SCHA_OFFEN, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setSchaOffen(this.analyseByQuery(FG_BA_SCHA, query, CHECKS_BAUWERKE_SCHA_SCHA_AUF_OFFENEM__GER));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_ANLP_OFFEN, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_ANLP_OFFEN, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setAnlpOffen(this.analyseByQuery(FG_BA_ANLP, query, CHECKS_BAUWERKE_ANLP_ANLP_AUF_OFFENEM__GER));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_ANLP_GESCHL, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_ANLP_GESCHL, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setAnlpGeschlossen(this.analyseByQuery(FG_BA_ANLP, query, CHECKS_BAUWERKE_ANLP_ANLP_AUF_GESCHLOSSEN));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_ANLP_ESW, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_ANLP_ESW, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setAnlpEsw(this.analyseByQuery(FG_BA_ANLP, query, CHECKS_BAUWERKE_ANLP_ANLP__ESW_FUER_GESCHLO));
        query = useExpCond ? String.format(QUERY_KR_ESW, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_KR_ESW, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setKrEsw(this.analyseByQuery(FG_BA_KR, query, CHECKS_BAUWERKE_KR_KR__ESW_FUER_GESCHLOSSEN));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_EA_ESW, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_EA_ESW, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setEaEsw(this.analyseByQuery(FG_BA_EA, query, CHECKS_BAUWERKE_EA_EA__ESW_FUER_GESCHLOSSEN));
        this.increaseProgress(wd, 1);
        result.setAnllGeschl(this.analyseByCustomSearch((CidsServerSearch)new OverlappedAnllWithR(user, selectedIds, export), CHECKS_BAUWERKE_ANLL_ANLL_AUF_GESCHLOSSEN, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setHaltungHoles(this.analyseByCustomSearch((CidsServerSearch)new HaltungWithHolesCoverage(user, selectedIds), CHECKS_HALTUNG_HOLES, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        if (result.getAnllAttr() != null) {
            result.setAnllAttrErrors(result.getAnllAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAnlpAttr() != null) {
            result.setAnlpAttrErrors(result.getAnlpAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getDueAttr() != null) {
            result.setDueAttrErrors(result.getDueAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getEaAttr() != null) {
            result.setEaAttrErrors(result.getEaAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getKrAttr() != null) {
            result.setKrAttrErrors(result.getKrAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getRlAttr() != null) {
            result.setRlAttrErrors(result.getRlAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getSchaAttr() != null) {
            result.setSchaAttrErrors(result.getSchaAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getSchwAttr() != null) {
            result.setSchwAttrErrors(result.getSchwAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getWehrAttr() != null) {
            result.setWehrAttrErrors(result.getWehrAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getdAttr() != null) {
            result.setdAttrErrors(result.getdAttr().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getRlHole() != null) {
            result.setRlHoleErrors(result.getRlHole().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getRlOverlapps() != null) {
            result.setRlOverlappsErrors(result.getRlOverlapps().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getSchaDistance() != null) {
            result.setSchaDistanceError(result.getSchaDistance().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getWehrDistance() != null) {
            result.setWehrDistanceError(result.getWehrDistance().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getSchwDistance() != null) {
            result.setSchwDistanceError(result.getSchwDistance().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getKrDistance() != null) {
            result.setKrDistanceError(result.getKrDistance().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getKrFgBa() != null) {
            result.setKrFgBaError(result.getKrFgBa().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getKrInvalid() != null) {
            result.setKrInvalidError(result.getKrInvalid().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getSchaOffen() != null) {
            result.setSchaOffenError(result.getSchaOffen().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAnlpGeschlossen() != null) {
            result.setAnlpGeschlossenError(result.getAnlpGeschlossen().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAnlpOffen() != null) {
            result.setAnlpOffenError(result.getAnlpOffen().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getKrEsw() != null) {
            result.setKrEswError(result.getKrEsw().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getEaEsw() != null) {
            result.setEaEswError(result.getEaEsw().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAnllGeschl() != null) {
            result.setAnllGeschlError(result.getAnllGeschl().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getKrMarkedTwice() != null) {
            result.setKrMarkedTwiceError(result.getKrMarkedTwice().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAnlpEsw() != null) {
            result.setAnlpEswError(result.getAnlpEsw().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getHaltungHoles() != null) {
            result.setHaltungHolesError(result.getHaltungHoles().getFeatureCount(null));
            this.successful = false;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    static {
        ALL_CHECKS = new String[]{CHECKS_BAUWERKE_ANLL_ANLL_AUF_GESCHLOSSEN, CHECKS_BAUWERKE_ANLL_ANLL__ATTRIBUTE, CHECKS_BAUWERKE_ANLP_ANLP_AUF_GESCHLOSSEN, CHECKS_BAUWERKE_ANLP_ANLP_AUF_OFFENEM__GER, CHECKS_BAUWERKE_ANLP_ANLP__ATTRIBUTE, CHECKS_BAUWERKE_ANLP_ANLP__ESW_FUER_GESCHLO, CHECKS_BAUWERKE_DD__ATTRIBUTE, CHECKS_BAUWERKE_DUE_DUE__ATTRIBUTE, CHECKS_BAUWERKE_EA_EA_AUF_GESCHLOSSENEM_G, CHECKS_BAUWERKE_EA_EA__ATTRIBUTE, CHECKS_BAUWERKE_EA_EA__ESW_FUER_GESCHLOSSEN, CHECKS_BAUWERKE_KR_KR_DOPPELTE__MARKIERUNG, CHECKS_BAUWERKE_KR_KR_DOPPELTZU_NAH, CHECKS_BAUWERKE_KR_KEIN_FG_BA, CHECKS_BAUWERKE_KR_INVALID, CHECKS_BAUWERKE_KR_KR__ATTRIBUTE, CHECKS_BAUWERKE_KR_KR__ESW_FUER_GESCHLOSSEN, CHECKS_BAUWERKE_RL_RL__ATTRIBUTE, CHECKS_BAUWERKE_RL_RL__LUECKE, CHECKS_BAUWERKE_RL_RL__UEBERLAPPUNG, CHECKS_BAUWERKE_SCHA_SCHA_AUF_OFFENEM__GER, CHECKS_BAUWERKE_SCHA_SCHA_DOPPELTZU_NAH, CHECKS_BAUWERKE_SCHA_SCHA__ATTRIBUTE, CHECKS_BAUWERKE_SCHW_SCHW_DOPPELTZU_NAH, CHECKS_BAUWERKE_SCHW_SCHW__ATTRIBUTE, CHECKS_BAUWERKE_WEHR_WEHR_AUF_GESCHLOSSEN, CHECKS_BAUWERKE_WEHR_WEHR_DOPPELTZU_NAH, CHECKS_BAUWERKE_WEHR_WEHR__ATTRIBUTE};
        if (FG_BAK != null && FG_BA_RL != null && FG_BA_D != null && FG_BA_DUE != null && FG_BA_ANLL != null && FG_BA_ANLP != null && FG_BA_KR != null && FG_BA_EA != null && FG_BA_WEHR != null && FG_BA_SCHA != null && FG_BA_SCHW != null) {
            User user = SessionManager.getSession().getUser();
            QUERY_RL_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_RL.getID() + ", rl." + FG_BA_RL.getPrimaryKey() + " from dlm25w.fg_ba_rl rl\njoin dlm25w.fg_ba_linie linie on (rl.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_profil p on (p.id = rl.profil)\nwhere\n(rl.profil is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br_dm_li is not null and ((p.profil in ('kr', 'ei') and (br_dm_li <25 or br_dm_li > 5000)) or ( p.profil in ('re', 'tr') and (br_dm_li < 0.025 or br_dm_li > 5) )))\nor (ho_li is not null and ((p.profil in ('ei') and (ho_li <25 or ho_li > 5000)) or ( p.profil in ('re', 'tr') and (ho_li < 0.025 or ho_li > 5) )))\nor (br_tr_o_li is not null and (br_tr_o_li <0.025 or br_tr_o_li > 5))\nor (ho_e is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle is not null and (gefaelle < -10 or gefaelle > 100))\nor (ho_d_e is not null and (ho_d_e < 0 or ho_d_e > 10))\nor (ho_d_a is not null and (ho_d_a < 0 or ho_d_a > 10))\nor (ho_d_m is not null and (ho_d_m <= 0 or ho_d_m > 30))\nor abs(von.wert - bis.wert) < 0.5\nor (p.profil = 'kr' and (ho_li is not null or br_tr_o_li is not null))\nor (p.profil in ('ei', 're') and br_tr_o_li is not null)\nor (p.profil = 'tr' and (br_dm_li = br_tr_o_li))) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_RL.getID() + ", rl." + FG_BA_RL.getPrimaryKey() + " from dlm25w.fg_ba_rl rl\njoin dlm25w.fg_ba_linie linie on (rl.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_profil p on (p.id = rl.profil)\nwhere\n(rl.profil is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br_dm_li is not null and ((p.profil in ('kr', 'ei') and (br_dm_li <25 or br_dm_li > 5000)) or ( p.profil in ('re', 'tr') and (br_dm_li < 0.025 or br_dm_li > 5) )))\nor (ho_li is not null and ((p.profil in ('ei') and (ho_li <25 or ho_li > 5000)) or ( p.profil in ('re', 'tr') and (ho_li < 0.025 or ho_li > 5) )))\nor (br_tr_o_li is not null and (br_tr_o_li <0.025 or br_tr_o_li > 5))\nor (ho_e is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle is not null and (gefaelle < -10 or gefaelle > 100))\nor (ho_d_e is not null and (ho_d_e < 0 or ho_d_e > 10))\nor (ho_d_a is not null and (ho_d_a < 0 or ho_d_a > 10))\nor (ho_d_m is not null and (ho_d_m <= 0 or ho_d_m > 30))\nor abs(von.wert - bis.wert) < 0.5\nor (p.profil = 'kr' and (ho_li is not null or br_tr_o_li is not null))\nor (p.profil in ('ei', 're') and br_tr_o_li is not null)\nor (p.profil = 'tr' and (br_dm_li = br_tr_o_li))) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_D_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_D.getID() + ", d." + FG_BA_D.getPrimaryKey() + " from dlm25w.fg_ba_d d\njoin dlm25w.fg_ba_linie linie on (d.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_profil p on (p.id = d.profil)\nwhere\n(d.profil is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br_dm_li is not null and ((p.profil in ('kr', 'ei') and (br_dm_li <25 or br_dm_li > 6000)) or ( p.profil in ('re', 'tr') and (br_dm_li < 0.025 or br_dm_li > 6) )))\nor (ho_li is not null and ((p.profil in ('ei') and (ho_li <25 or ho_li > 6000)) or ( p.profil in ('re', 'tr') and (ho_li < 0.025 or ho_li > 6) )))\nor (br_tr_o_li is not null and (br_tr_o_li <0.025 or br_tr_o_li > 6))\nor (ho_e is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle is not null and (gefaelle < -10 or gefaelle > 100))\nor (ho_d_e is not null and (ho_d_e < 0 or ho_d_e > 10))\nor (ho_d_a is not null and (ho_d_a < 0 or ho_d_a > 10))\nor (ho_d_m is not null and (ho_d_m <= 0 or ho_d_m > 30))\nor abs(von.wert - bis.wert) < 0.5\nor abs(von.wert - bis.wert) > 250\nor (p.profil = 'kr' and (ho_li is not null or br_tr_o_li is not null))\nor (p.profil in ('ei', 're') and br_tr_o_li is not null)\nor (p.profil = 'tr' and (br_dm_li = br_tr_o_li))) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_D.getID() + ", d." + FG_BA_D.getPrimaryKey() + " from dlm25w.fg_ba_d d\njoin dlm25w.fg_ba_linie linie on (d.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_profil p on (p.id = d.profil)\nwhere\n(d.profil is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br_dm_li is not null and ((p.profil in ('kr', 'ei') and (br_dm_li <25 or br_dm_li > 6000)) or ( p.profil in ('re', 'tr') and (br_dm_li < 0.025 or br_dm_li > 6) )))\nor (ho_li is not null and ((p.profil in ('ei') and (ho_li <25 or ho_li > 6000)) or ( p.profil in ('re', 'tr') and (ho_li < 0.025 or ho_li > 6) )))\nor (br_tr_o_li is not null and (br_tr_o_li <0.025 or br_tr_o_li > 6))\nor (ho_e is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle is not null and (gefaelle < -10 or gefaelle > 100))\nor (ho_d_e is not null and (ho_d_e < 0 or ho_d_e > 10))\nor (ho_d_a is not null and (ho_d_a < 0 or ho_d_a > 10))\nor (ho_d_m is not null and (ho_d_m <= 0 or ho_d_m > 30))\nor abs(von.wert - bis.wert) < 0.5\nor abs(von.wert - bis.wert) > 250\nor (p.profil = 'kr' and (ho_li is not null or br_tr_o_li is not null))\nor (p.profil in ('ei', 're') and br_tr_o_li is not null)\nor (p.profil = 'tr' and (br_dm_li = br_tr_o_li))) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_DUE_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_DUE.getID() + ", d." + FG_BA_DUE.getPrimaryKey() + " from dlm25w.fg_ba_due d\njoin dlm25w.fg_ba_linie linie on (d.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_profil p on (p.id = d.profil)\nwhere\n(d.profil is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br_dm_li is not null and ((p.profil in ('kr', 'ei') and (br_dm_li <25 or br_dm_li > 6000)) or ( p.profil in ('re', 'tr') and (br_dm_li < 0.025 or br_dm_li > 6) )))\nor (ho_li is not null and ((p.profil in ('ei') and (ho_li <25 or ho_li > 6000)) or ( p.profil in ('re', 'tr') and (ho_li < 0.025 or ho_li > 6) )))\nor (br_tr_o_li is not null and (br_tr_o_li <0.025 or br_tr_o_li > 6))\nor (ho_e is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle is not null and (gefaelle < -10 or gefaelle > 100))\nor (ho_d_e is not null and (ho_d_e < 0 or ho_d_e > 10))\nor (ho_d_a is not null and (ho_d_a < 0 or ho_d_a > 10))\nor (ho_d_iab is not null and (ho_d_iab <= 0 or ho_d_iab > 30))\nor (ho_d_iauf is not null and (ho_d_iauf <= 0 or ho_d_iauf > 30))\nor (ho_d_m is not null and (ho_d_m <= 0 or ho_d_m > 30))\nor abs(von.wert - bis.wert) < 0.5\nor abs(von.wert - bis.wert) > 250\nor (p.profil = 'kr' and (ho_li is not null or br_tr_o_li is not null))\nor (p.profil in ('ei', 're') and br_tr_o_li is not null)\nor (p.profil = 'tr' and (br_dm_li = br_tr_o_li))) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_DUE.getID() + ", d." + FG_BA_DUE.getPrimaryKey() + " from dlm25w.fg_ba_due d\njoin dlm25w.fg_ba_linie linie on (d.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_profil p on (p.id = d.profil)\nwhere\n(d.profil is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br_dm_li is not null and ((p.profil in ('kr', 'ei') and (br_dm_li <25 or br_dm_li > 6000)) or ( p.profil in ('re', 'tr') and (br_dm_li < 0.025 or br_dm_li > 6) )))\nor (ho_li is not null and ((p.profil in ('ei') and (ho_li <25 or ho_li > 6000)) or ( p.profil in ('re', 'tr') and (ho_li < 0.025 or ho_li > 6) )))\nor (br_tr_o_li is not null and (br_tr_o_li <0.025 or br_tr_o_li > 6))\nor (ho_e is not null and (ho_e < -6 or ho_e > 179))\nor (ho_a is not null and (ho_a < -6 or ho_a > 179))\nor (gefaelle is not null and (gefaelle < -10 or gefaelle > 100))\nor (ho_d_e is not null and (ho_d_e < 0 or ho_d_e > 10))\nor (ho_d_a is not null and (ho_d_a < 0 or ho_d_a > 10))\nor (ho_d_iab is not null and (ho_d_iab <= 0 or ho_d_iab > 30))\nor (ho_d_iauf is not null and (ho_d_iauf <= 0 or ho_d_iauf > 30))\nor (ho_d_m is not null and (ho_d_m <= 0 or ho_d_m > 30))\nor abs(von.wert - bis.wert) < 0.5\nor abs(von.wert - bis.wert) > 250\nor (p.profil = 'kr' and (ho_li is not null or br_tr_o_li is not null))\nor (p.profil in ('ei', 're') and br_tr_o_li is not null)\nor (p.profil = 'tr' and (br_dm_li = br_tr_o_li))) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_ANLL_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_ANLL.getID() + ", a." + FG_BA_ANLL.getPrimaryKey() + " from dlm25w.fg_ba_anll a\njoin dlm25w.fg_ba_linie linie on (a.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_anll an on (an.id = a.anll)\nwhere\n(a.anll is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (an.anll in ('See', 'Spei') and (abs(von.wert - bis.wert) < 5 or abs(von.wert - bis.wert) > 50000 ))\nor (an.anll in ('Drte', 'Faa', 'Rb') and (abs(von.wert - bis.wert) < 5 or abs(von.wert - bis.wert) > 200))\nor (an.anll in ('Ds', 'Sf', 'Si', 'Sleu','Tosb','WKA') and (abs(von.wert - bis.wert) < 1 or abs(von.wert - bis.wert) > 200))\nor (a.esw is not null and (a.esw < 0 or a.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_ANLL.getID() + ", a." + FG_BA_ANLL.getPrimaryKey() + " from dlm25w.fg_ba_anll a\njoin dlm25w.fg_ba_linie linie on (a.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_anll an on (an.id = a.anll)\nwhere\n(a.anll is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (an.anll in ('See', 'Spei') and (abs(von.wert - bis.wert) < 5 or abs(von.wert - bis.wert) > 50000 ))\nor (an.anll in ('Drte', 'Faa', 'Rb') and (abs(von.wert - bis.wert) < 5 or abs(von.wert - bis.wert) > 200))\nor (an.anll in ('Ds', 'Sf', 'Si', 'Sleu','Tosb','WKA') and (abs(von.wert - bis.wert) < 1 or abs(von.wert - bis.wert) > 200))\nor (a.esw is not null and (a.esw < 0 or a.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_ANLP_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_ANLP.getID() + ", a." + FG_BA_ANLP.getPrimaryKey() + " from dlm25w.fg_ba_anlp a\njoin dlm25w.fg_ba_punkt von on (a.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_anlp an on (an.id = a.anlp)\nleft join dlm25w.k_l_rl rl on (rl.id = a.l_rl)\nwhere\n(a.anlp is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (an.anlp not in ('Steg', 'Vt', 'Wee', 'Z') and (br < 0 or br > 10 ))\nor (an.anlp in ('Steg', 'Vt', 'Wee', 'Z') and (br < 1 or br > 200))\nor (an.anlp in ('Albw', 'Elbw', 'Fu', 'Rsk', 'Schi', 'Slu', 'Stt') and (rl.l_rl <> 'mi'))\nor (an.anlp in ('P', 'P-Gr', 'P-Steg', 'P-Gr-Steg', 'P-Lat', 'Sta') and (rl.l_rl is not null and rl.l_rl not in ('re', 'li', 'mi', 'bs', 'nb')))\nor (an.anlp in ('Steg', 'Vt', 'Wes') and (rl.l_rl is not null and rl.l_rl not in ('re', 'li', 'bs', 'nb')))\nor (a.esw is not null and (a.esw < 0 or a.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_ANLP.getID() + ", a." + FG_BA_ANLP.getPrimaryKey() + " from dlm25w.fg_ba_anlp a\njoin dlm25w.fg_ba_punkt von on (a.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_anlp an on (an.id = a.anlp)\nleft join dlm25w.k_l_rl rl on (rl.id = a.l_rl)\nwhere\n(a.anlp is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (an.anlp not in ('Steg', 'Vt', 'Wee', 'Z') and (br < 0 or br > 10 ))\nor (an.anlp in ('Steg', 'Vt', 'Wee', 'Z') and (br < 1 or br > 200))\nor (an.anlp in ('Albw', 'Elbw', 'Fu', 'Rsk', 'Schi', 'Slu', 'Stt') and (rl.l_rl <> 'mi'))\nor (an.anlp in ('P', 'P-Gr', 'P-Steg', 'P-Gr-Steg', 'P-Lat', 'Sta') and (rl.l_rl is not null and rl.l_rl not in ('re', 'li', 'mi', 'bs', 'nb')))\nor (an.anlp in ('Steg', 'Vt', 'Wes') and (rl.l_rl is not null and rl.l_rl not in ('re', 'li', 'bs', 'nb')))\nor (a.esw is not null and (a.esw < 0 or a.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_KR_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_KR.getID() + ", kr." + FG_BA_KR.getPrimaryKey() + " from dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt von on (kr.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_kr k on (k.id = kr.kr)\nleft join dlm25w.k_l_oiu oi on (oi.id = kr.l_oiu)\nwhere\n(kr.kr is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br is not null and (br <= 0 or br > 100))\nor (k.kr in ('Br') and (oi.l_oiu <> 'o' ))\nor (k.kr in ('U') and (oi.l_oiu <> 'u' ))\nor (kr.esw is not null and (kr.esw < 0 or kr.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_KR.getID() + ", kr." + FG_BA_KR.getPrimaryKey() + " from dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt von on (kr.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_kr k on (k.id = kr.kr)\nleft join dlm25w.k_l_oiu oi on (oi.id = kr.l_oiu)\nwhere\n(kr.kr is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br is not null and (br <= 0 or br > 100))\nor (k.kr in ('Br') and (oi.l_oiu <> 'o' ))\nor (k.kr in ('U') and (oi.l_oiu <> 'u' ))\nor (kr.esw is not null and (kr.esw < 0 or kr.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_EA_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_EA.getID() + ", ea." + FG_BA_EA.getPrimaryKey() + " from dlm25w.fg_ba_ea ea\njoin dlm25w.fg_ba_punkt von on (ea.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere\n(ea.l_rl is null or ea.ea is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br is not null and (br <= 0 or br > 30))\nor (ho_ea  is not null and (ho_ea < -6 or ho_ea > 179))\nor (ho_d_ea is not null and (ho_d_ea < 0 or ho_d_ea > 15))\nor (ea.esw is not null and (ea.esw < 0 or ea.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_EA.getID() + ", ea." + FG_BA_EA.getPrimaryKey() + " from dlm25w.fg_ba_ea ea\njoin dlm25w.fg_ba_punkt von on (ea.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere\n(ea.l_rl is null or ea.ea is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br is not null and (br <= 0 or br > 30))\nor (ho_ea  is not null and (ho_ea < -6 or ho_ea > 179))\nor (ho_d_ea is not null and (ho_d_ea < 0 or ho_d_ea > 15))\nor (ea.esw is not null and (ea.esw < 0 or ea.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_SCHA_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_SCHA.getID() + ", scha." + FG_BA_SCHA.getPrimaryKey() + " from dlm25w.fg_ba_scha scha\njoin dlm25w.fg_ba_punkt von on (scha.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere\n(scha.scha is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (ho_so  is not null and (ho_so < -6 or ho_so > 179))\nor (ho_d_so_ok is not null and (ho_d_so_ok <= 0 or ho_d_so_ok > 10))\n) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_SCHA.getID() + ", scha." + FG_BA_SCHA.getPrimaryKey() + " from dlm25w.fg_ba_scha scha\njoin dlm25w.fg_ba_punkt von on (scha.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere\n(scha.scha is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (ho_so  is not null and (ho_so < -6 or ho_so > 179))\nor (ho_d_so_ok is not null and (ho_d_so_ok <= 0 or ho_d_so_ok > 10))\n) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_WEHR_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_WEHR.getID() + ", wehr." + FG_BA_WEHR.getPrimaryKey() + " from dlm25w.fg_ba_wehr wehr\njoin dlm25w.fg_ba_punkt von on (wehr.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_wehr w on (w.id = wehr.wehr)\nleft join dlm25w.k_wehr_v wv on (wv.id = wehr.wehr_v)\nleft join dlm25w.k_wehr_av wav on (wav.id = wehr.wehr_av)\nleft join dlm25w.k_material m on (m.id = wehr.material_v)\nleft join dlm25w.k_sbef sbef on (sbef.id = wehr.wehr_a)\nleft join dlm25w.k_material ma on (ma.id = wehr.material_a)\nwhere\n(wehr.wehr is null or wehr.wehr_v is null or wehr.wehr_av is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 30))\nor (br_li  is not null and (br_li <= 0 or br_li > 100))\nor (ho_so  is not null and (ho_so < -6 or ho_so > 179))\nor (sz  is not null and (sz < -6 or sz > 179))\nor (az  is not null and (az < -6 or az > 179))\nor (sz is not null and az is not null and (sz <= az))\nor (sz is not null and ho_so is not null and (sz <= ho_so))\nor (az is not null and ho_so is not null and (az <= ho_so))\nor (w.wehr in ('S-Kbw', 'S-Sbw', 'S-Stw', 'S-Moe') and wv.wehr_v not in ('Bo', 'Bo-J', 'Sch\u00fc'))\nor (w.wehr in ('W-Strei', 'W-\u00dcfa') and wv.wehr_v <> 'Schw')\nor (w.wehr in ('Ki') and wv.wehr_v not in ('Kl', 'Kl-Fb', 'Kl-Fb-Sch\u00fc', 'Kl-Sch\u00fc'))\nor (w.wehr in ('Na') and wv.wehr_v not in ('na'))\nor (w.wehr in ('Seg') and wv.wehr_v not in ('Seg', 'Seg-Fb'))\nor (w.wehr in ('Sek') and wv.wehr_v not in ('Sek'))\nor (w.wehr in ('Schl') and wv.wehr_v not in ('Schl'))\nor (w.wehr in ('Sch\u00fc') and wv.wehr_v not in ('Sch\u00fc', 'Sch\u00fc-Dop', 'Sch\u00fc-Dreh', 'Sch\u00fc-Haken', 'Sch\u00fc-Seg'))\nor (w.wehr in ('Tro') and wv.wehr_v not in ('Tro'))\nor (w.wehr in ('Wz') and wv.wehr_v not in ('Wz'))\nor (w.wehr in ('W-Strei', 'W-\u00dcfa') and wav.wehr_av not in ('ohne'))\nor (wv.wehr_v in ('Bo','Bo-J') and m.material not in ('H','K','St','nb'))\nor (wv.wehr_v in ('Schw') and m.material not in ('B','K'))\nor (wv.wehr_v not in ('Bo', 'Bo-J', 'Schw') and m.material is not null)\nor (sbef.sbef in ('PL', 'RL') and (ma.material is null or ma.material not in ('B')))\nor (sbef.sbef in ('SP') and (ma.material is null or ma.material not in ('Ste')))\nor (wehr.esw is not null and (wehr.esw < 0 or wehr.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_WEHR.getID() + ", wehr." + FG_BA_WEHR.getPrimaryKey() + " from dlm25w.fg_ba_wehr wehr\njoin dlm25w.fg_ba_punkt von on (wehr.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nleft join dlm25w.k_wehr w on (w.id = wehr.wehr)\nleft join dlm25w.k_wehr_v wv on (wv.id = wehr.wehr_v)\nleft join dlm25w.k_wehr_av wav on (wav.id = wehr.wehr_av)\nleft join dlm25w.k_material m on (m.id = wehr.material_v)\nleft join dlm25w.k_sbef sbef on (sbef.id = wehr.wehr_a)\nleft join dlm25w.k_material ma on (ma.id = wehr.material_a)\nwhere\n(wehr.wehr is null or wehr.wehr_v is null or wehr.wehr_av is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 30))\nor (br_li  is not null and (br_li <= 0 or br_li > 100))\nor (ho_so  is not null and (ho_so < -6 or ho_so > 179))\nor (sz  is not null and (sz < -6 or sz > 179))\nor (az  is not null and (az < -6 or az > 179))\nor (sz is not null and az is not null and (sz <= az))\nor (sz is not null and ho_so is not null and (sz <= ho_so))\nor (az is not null and ho_so is not null and (az <= ho_so))\nor (w.wehr in ('S-Kbw', 'S-Sbw', 'S-Stw', 'S-Moe') and wv.wehr_v not in ('Bo', 'Bo-J', 'Sch\u00fc'))\nor (w.wehr in ('W-Strei', 'W-\u00dcfa') and wv.wehr_v <> 'Schw')\nor (w.wehr in ('Ki') and wv.wehr_v not in ('Kl', 'Kl-Fb', 'Kl-Fb-Sch\u00fc', 'Kl-Sch\u00fc'))\nor (w.wehr in ('Na') and wv.wehr_v not in ('na'))\nor (w.wehr in ('Seg') and wv.wehr_v not in ('Seg', 'Seg-Fb'))\nor (w.wehr in ('Sek') and wv.wehr_v not in ('Sek'))\nor (w.wehr in ('Schl') and wv.wehr_v not in ('Schl'))\nor (w.wehr in ('Sch\u00fc') and wv.wehr_v not in ('Sch\u00fc', 'Sch\u00fc-Dop', 'Sch\u00fc-Dreh', 'Sch\u00fc-Haken', 'Sch\u00fc-Seg'))\nor (w.wehr in ('Tro') and wv.wehr_v not in ('Tro'))\nor (w.wehr in ('Wz') and wv.wehr_v not in ('Wz'))\nor (w.wehr in ('W-Strei', 'W-\u00dcfa') and wav.wehr_av not in ('ohne'))\nor (wv.wehr_v in ('Bo','Bo-J') and m.material not in ('H','K','St','nb'))\nor (wv.wehr_v in ('Schw') and m.material not in ('B','K'))\nor (wv.wehr_v not in ('Bo', 'Bo-J', 'Schw') and m.material is not null)\nor (sbef.sbef in ('PL', 'RL') and (ma.material is null or ma.material not in ('B')))\nor (sbef.sbef in ('SP') and (ma.material is null or ma.material not in ('Ste')))\nor (wehr.esw is not null and (wehr.esw < 0 or wehr.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_SCHW_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_SCHW.getID() + ", schw." + FG_BA_SCHW.getPrimaryKey() + " from dlm25w.fg_ba_schw schw\njoin dlm25w.fg_ba_punkt von on (schw.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere\n(schw.schw is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 30))\nor (sz  is not null and (sz < -6 or sz > 179))\nor (az  is not null and (az < -6 or az > 179))\nor (ezg_fl  is not null and (ezg_fl <= 0 or ezg_fl > 100))\nor (v_fl  is not null and (v_fl <= 0 or v_fl > 100))\nor (pu_anz1  is not null and (pu_anz1 < 1 or pu_anz1 > 9))\nor (pu_anz2  is not null and (pu_anz2 < 1 or pu_anz2 > 9))\nor (pu_motl1  is not null and (pu_motl1 <= 0 or pu_motl1 > 500))\nor (pu_motl2  is not null and (pu_motl2 <= 0 or pu_motl2 > 500))\nor (pu_foel1  is not null and (pu_foel1 <= 0 or pu_foel1 > 100))\nor (pu_foel2  is not null and (pu_foel2 <= 0 or pu_foel2 > 100))\nor (sz is not null and az is not null and (sz <= az))\nor (ezg_fl is not null and v_fl is not null and (ezg_fl < v_fl))\nor (schw.esw is not null and (schw.esw < 0 or schw.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s));" : "select " + FG_BA_SCHW.getID() + ", schw." + FG_BA_SCHW.getPrimaryKey() + " from dlm25w.fg_ba_schw schw\njoin dlm25w.fg_ba_punkt von on (schw.ba_st = von.id)\njoin dlm25w.fg_ba ba on (ba.id = von.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere\n(schw.schw is null or obj_nr is null\nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br  is not null and (br <= 0 or br > 30))\nor (sz  is not null and (sz < -6 or sz > 179))\nor (az  is not null and (az < -6 or az > 179))\nor (ezg_fl  is not null and (ezg_fl <= 0 or ezg_fl > 100))\nor (v_fl  is not null and (v_fl <= 0 or v_fl > 100))\nor (pu_anz1  is not null and (pu_anz1 < 1 or pu_anz1 > 9))\nor (pu_anz2  is not null and (pu_anz2 < 1 or pu_anz2 > 9))\nor (pu_motl1  is not null and (pu_motl1 <= 0 or pu_motl1 > 500))\nor (pu_motl2  is not null and (pu_motl2 <= 0 or pu_motl2 > 500))\nor (pu_foel1  is not null and (pu_foel1 <= 0 or pu_foel1 > 100))\nor (pu_foel2  is not null and (pu_foel2 <= 0 or pu_foel2 > 100))\nor (sz is not null and az is not null and (sz <= az))\nor (ezg_fl is not null and v_fl is not null and (ezg_fl < v_fl))\nor (schw.esw is not null and (schw.esw < 0 or schw.esw > 1)) ) and (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_SCHA_DISTANCE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_SCHA.getID() + ", s1." + FG_BA_SCHA.getPrimaryKey() + " from (\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_scha scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n) s1,\n(\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_scha scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n) s2\nwhere (%1$s is null or s1.route = any(%1$s)) and s1.id <> s2.id and s1.route = s2.route and abs(s1.wert - s2.wert) < 0.5" : "select distinct " + FG_BA_SCHA.getID() + ", s1." + FG_BA_SCHA.getPrimaryKey() + " from (\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_scha scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nWHERE (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) s1,\n(\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_scha scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nWHERE (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) s2\nwhere (%1$s is null or s1.route = any(%1$s)) and s1.id <> s2.id and s1.route = s2.route and abs(s1.wert - s2.wert) < 0.5";
            QUERY_WEHR_DISTANCE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_WEHR.getID() + ", s1." + FG_BA_WEHR.getPrimaryKey() + " from (\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_wehr scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n) s1,\n(\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_wehr scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n) s2\nwhere (%1$s is null or s1.route = any(%1$s)) and s1.id <> s2.id and s1.route = s2.route and abs(s1.wert - s2.wert) < 0.5" : "select distinct " + FG_BA_WEHR.getID() + ", s1." + FG_BA_WEHR.getPrimaryKey() + " from (\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_wehr scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nWHERE (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) s1,\n(\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_wehr scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nWHERE (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) s2\nwhere (%1$s is null or s1.route = any(%1$s)) and s1.id <> s2.id and s1.route = s2.route and abs(s1.wert - s2.wert) < 0.5";
            QUERY_SCHW_DISTANCE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_SCHW.getID() + ", s1." + FG_BA_SCHW.getPrimaryKey() + " from (\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_schw scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n) s1,\n(\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_schw scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n) s2\nwhere (%1$s is null or s1.route = any(%1$s)) and s1.id <> s2.id and s1.route = s2.route and abs(s1.wert - s2.wert) < 20" : "select distinct " + FG_BA_SCHW.getID() + ", s1." + FG_BA_SCHW.getPrimaryKey() + " from (\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_schw scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nWHERE (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) s1,\n(\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_schw scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nWHERE (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) s2\nwhere (%1$s is null or s1.route = any(%1$s)) and s1.id <> s2.id and s1.route = s2.route and abs(s1.wert - s2.wert) < 20";
            QUERY_KR_DISTANCE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_KR.getID() + ", s1." + FG_BA_KR.getPrimaryKey() + " from (\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_kr scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n left join dlm25w.k_kr k on (k.id = scha.kr) where k.kr in ('Br', 'Gew', 'U')) s1,\n(\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_kr scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n left join dlm25w.k_kr k on (k.id = scha.kr) where k.kr in ('Br', 'Gew', 'U')) s2\nwhere (%1$s is null or s1.route = any(%1$s)) and s1.id <> s2.id and s1.route = s2.route and abs(s1.wert - s2.wert) < 3" : "select distinct " + FG_BA_KR.getID() + ", s1." + FG_BA_KR.getPrimaryKey() + " from (\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_kr scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n left join dlm25w.k_kr k on (k.id = scha.kr)WHERE k.kr in ('Br', 'Gew', 'U') and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) s1,\n(\nselect scha.id, st.route, st.wert\nfrom dlm25w.fg_ba_kr scha\njoin dlm25w.fg_ba_punkt st on (scha.ba_st = st.id)\njoin dlm25w.fg_ba ba on (ba.id = st.route)\njoin dlm25w.fg_bak bak on (bak.id = ba.bak_id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n left join dlm25w.k_kr k on (k.id = scha.kr)WHERE k.kr in ('Br', 'Gew', 'U') and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) s2\nwhere (%1$s is null or s1.route = any(%1$s)) and s1.id <> s2.id and s1.route = s2.route and abs(s1.wert - s2.wert) < 3";
            QUERY_SCHA_OFFEN = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_SCHA.getID() + ", scha." + FG_BA_SCHA.getPrimaryKey() + " from dlm25w.fg_ba_scha scha\njoin dlm25w.fg_ba_punkt s on (scha.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nwhere (%1$s is null or s.route = any(%1$s)) and not\n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert))))\n" : "select distinct " + FG_BA_SCHA.getID() + ", scha." + FG_BA_SCHA.getPrimaryKey() + " from dlm25w.fg_ba_scha scha\njoin dlm25w.fg_ba_punkt s on (scha.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nwhere (%1$s is null or s.route = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s) and not\n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert))))\n";
            QUERY_ANLP_OFFEN = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_ANLP.getID() + ", a." + FG_BA_ANLP.getPrimaryKey() + " from dlm25w.fg_ba_anlp a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nleft join dlm25w.k_anlp ka on (ka.id = a.anlp)\nwhere (%1$s is null or s.route = any(%1$s)) and ka.anlp in ('Schi', 'Slu') and \nnot (exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)" : "select distinct " + FG_BA_ANLP.getID() + ", a." + FG_BA_ANLP.getPrimaryKey() + " from dlm25w.fg_ba_anlp a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nleft join dlm25w.k_anlp ka on (ka.id = a.anlp)\nwhere (%1$s is null or s.route = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s) and ka.anlp in ('Schi', 'Slu') and \nnot (exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)";
            QUERY_ANLP_GESCHL = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_ANLP.getID() + ", a." + FG_BA_ANLP.getPrimaryKey() + " from dlm25w.fg_ba_anlp a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nleft join dlm25w.k_anlp ka on (ka.id = a.anlp)\nwhere (%1$s is null or s.route = any(%1$s)) and ka.anlp in ('Fu', 'P', 'P-Grr', 'P-Steg', 'P-Grr-Steg', 'P-Lat', 'Steg', 'Stt', 'Vt') and \n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)" : "select distinct " + FG_BA_ANLP.getID() + ", a." + FG_BA_ANLP.getPrimaryKey() + " from dlm25w.fg_ba_anlp a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nleft join dlm25w.k_anlp ka on (ka.id = a.anlp)\nwhere (%1$s is null or s.route = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s) and ka.anlp in ('Fu', 'P', 'P-Grr', 'P-Steg', 'P-Grr-Steg', 'P-Lat', 'Steg', 'Stt', 'Vt') and \n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert  or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)";
            QUERY_ANLP_ESW = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_ANLP.getID() + ", a." + FG_BA_ANLP.getPrimaryKey() + " from dlm25w.fg_ba_anlp a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nleft join dlm25w.k_anlp ka on (ka.id = a.anlp)\nwhere (%1$s is null or s.route = any(%1$s)) and esw = 1 and \n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)" : "select distinct " + FG_BA_ANLP.getID() + ", a." + FG_BA_ANLP.getPrimaryKey() + " from dlm25w.fg_ba_anlp a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nleft join dlm25w.k_anlp ka on (ka.id = a.anlp)\nwhere (%1$s is null or s.route = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s) and esw = 1 and \n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)";
            QUERY_KR_ESW = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_KR.getID() + ", a." + FG_BA_KR.getPrimaryKey() + " from dlm25w.fg_ba_kr a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nwhere (%1$s is null or s.route = any(%1$s)) and esw = 1 and \n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)" : "select distinct " + FG_BA_KR.getID() + ", a." + FG_BA_KR.getPrimaryKey() + " from dlm25w.fg_ba_kr a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nwhere (%1$s is null or s.route = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s) and esw = 1 and \n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)";
            QUERY_EA_ESW = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_EA.getID() + ", a." + FG_BA_EA.getPrimaryKey() + " from dlm25w.fg_ba_ea a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nwhere (%1$s is null or s.route = any(%1$s)) and esw = 1 and \n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)" : "select distinct " + FG_BA_EA.getID() + ", a." + FG_BA_EA.getPrimaryKey() + " from dlm25w.fg_ba_ea a\njoin dlm25w.fg_ba_punkt s on (a.ba_st = s.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\nwhere (%1$s is null or s.route = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s) and esw = 1 and \n(exists(select 1 from dlm25w.fg_ba_rl r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor\nexists(select 1 from dlm25w.fg_ba_d r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\nor \nexists(select 1 from dlm25w.fg_ba_due r join dlm25w.fg_ba_linie l on (r.ba_st = l.id) join dlm25w.fg_ba_punkt v on (l.von = v.id) join dlm25w.fg_ba_punkt b on (l.bis = b.id)\nwhere v.route = s.route and (least(v.wert, b.wert) <= s.wert or dlm25w.is_station_equal(least(v.wert, b.wert), s.wert)) and (greatest(v.wert, b.wert) >= s.wert or dlm25w.is_station_equal(greatest(v.wert, b.wert), s.wert)))\n)";
            QUERY_KR_MARKED_TWICE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_KR.getID() + ", k1." + FG_BA_KR.getPrimaryKey() + " from \n(select kr.id, g.geo_field, s.route, kkr.kr kr\nfrom dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt s on (kr.ba_st = s.id)\njoin geom g on (s.real_point = g.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_kr kkr on (kr.kr = kkr.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)) as k1,\n(select kr.id, g.geo_field, s.route, kkr.kr kr \nfrom dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt s on (kr.ba_st = s.id)\njoin geom g on (s.real_point = g.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_kr kkr on (kr.kr = kkr.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)) as k2\n where (%1$s is null or k1.route = any(%1$s)) and k1.id <> k2.id and k1.kr = 'Gew' and k2.kr = 'Gew' and st_intersects(k1.geo_field, st_buffer(k2.geo_field, 3));" : "select distinct " + FG_BA_KR.getID() + ", k1." + FG_BA_KR.getPrimaryKey() + " from \n(select kr.id, g.geo_field, s.route, kkr.kr kr\nfrom dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt s on (kr.ba_st = s.id)\njoin geom g on (s.real_point = g.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_kr kkr on (kr.kr = kkr.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr) where (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) as k1,\n(select kr.id, g.geo_field, s.route , kkr.kr kr\nfrom dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt s on (kr.ba_st = s.id)\njoin geom g on (s.real_point = g.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_kr kkr on (kr.kr = kkr.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr) where (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)) as k2\nwhere (%1$s is null or k1.route = any(%1$s)) and k1.id <> k2.id and k1.kr = 'Gew' and k2.kr = 'Gew' and not st_isempty(st_intersection(k1.geo_field, st_buffer(k2.geo_field, 3)));";
            QUERY_KR_KEIN_FG_BA = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_KR.getID() + ", kr." + FG_BA_KR.getPrimaryKey() + " from dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt s on (kr.ba_st = s.id)\njoin geom g on (s.real_point = g.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_kr kkr on (kr.kr = kkr.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n where (%1$s is null or s.route = any(%1$s)) and kkr.kr = 'Gew' and (select count(ba.id) from dlm25w.fg_ba ba join geom on (ba.geom = geom.id) where st_intersects(geom.geo_field, st_buffer(g.geo_field, 3)) ) < 2;" : "select distinct " + FG_BA_KR.getID() + ", kr." + FG_BA_KR.getPrimaryKey() + " from dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt s on (kr.ba_st = s.id)\njoin geom g on (s.real_point = g.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_kr kkr on (kr.kr = kkr.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n where (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s) and (%1$s is null or s.route = any(%1$s)) and kkr.kr = 'Gew' and (select count(ba.id) from dlm25w.fg_ba ba join geom on (ba.geom = geom.id) where st_intersects(geom.geo_field, st_buffer(g.geo_field, 3)) ) < 2;";
            QUERY_KR_INVALID = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_KR.getID() + ", kr." + FG_BA_KR.getPrimaryKey() + " from dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt s on (kr.ba_st = s.id)\njoin geom g on (s.real_point = g.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_l_oiu koiu on (kr.l_oiu = koiu.id)\nleft join dlm25w.k_kr kkr on (kr.kr = kkr.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n where (%1$s is null or s.route = any(%1$s)) and kkr.kr = 'Gew' and koiu.l_oiu = 'i' and ( dlm25w.isgeschlossenesgerinne(st_buffer(g.geo_field, 0.01), ba.id)  or (dlm25w.isoffenesgerinne(st_buffer(g.geo_field, 0.01), ba.id) and dlm25w.isoffenesgerinne(\n(select st_buffer(ST_LineInterpolatePoint(geo_field, ST_LineLocatePoint(geo_field, g.geo_field)), 0.01) from dlm25w.fg_ba b join geom on (b.geom = geom.id) where b.id != ba.id and st_intersects(geom.geo_field, st_buffer(g.geo_field, 3)) limit 1), \n(select b.id from dlm25w.fg_ba b join geom on (b.geom = geom.id) where b.id != ba.id and st_intersects(geom.geo_field, st_buffer(g.geo_field, 3)) limit 1)) ) );" : "select distinct " + FG_BA_KR.getID() + ", kr." + FG_BA_KR.getPrimaryKey() + " from dlm25w.fg_ba_kr kr\njoin dlm25w.fg_ba_punkt s on (kr.ba_st = s.id)\njoin geom g on (s.real_point = g.id)\njoin dlm25w.fg_ba ba on (s.route = ba.id)\njoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nleft join dlm25w.k_l_oiu koiu on (kr.l_oiu = koiu.id)\nleft join dlm25w.k_kr kkr on (kr.kr = kkr.id)\nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)\n where  (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s) and (%1$s is null or s.route = any(%1$s)) and kkr.kr = 'Gew' and koiu.l_oiu = 'i' and ( dlm25w.isgeschlossenesgerinne(st_buffer(g.geo_field, 0.01), ba.id)  or (dlm25w.isoffenesgerinne(st_buffer(g.geo_field, 0.01), ba.id) and dlm25w.isoffenesgerinne(\n(select st_buffer(ST_LineInterpolatePoint(geo_field, ST_LineLocatePoint(geo_field, g.geo_field)), 0.01) from dlm25w.fg_ba b join geom on (b.geom = geom.id) where b.id != ba.id and st_intersects(geom.geo_field, st_buffer(g.geo_field, 3)) limit 1), \n(select b.id from dlm25w.fg_ba b join geom on (b.geom = geom.id) where b.id != ba.id and st_intersects(geom.geo_field, st_buffer(g.geo_field, 3)) limit 1)) ) );";
        }
    }

    protected static class CheckResult
    extends AbstractCheckResult {
        private static final String[] CHECK_NAMES = new String[]{"RL_ATTR", "D_ATTR", "DUE_ATTR", "SCHA_ATTR", "WEHR_ATTR", "SCHw_ATTR", "ANLP_ATTR", "ANLL_ATTR", "KR_ATTR", "EA_ATTR", "RL_HOLE", "RL_OVERLAPS", "SCHA_DISTANCE", "WEHR_DISTANCE", "SCHW_DISTANCE", "KR_DISTANCE", "KR_FGBA", "KR_INVALID", "SCHA_OFFEN", "ANLP_OFFEN", "ANLP_GESCHL", "ANLP_ESW", "KR_ESW", "EA_ESW", "ANLL_GESCHL", "KR_MARKED_TWICE", "HALTUNG_HOLES"};
        private int bakCount;
        private int rlAttrErrors;
        private int dAttrErrors;
        private int dueAttrErrors;
        private int schaAttrErrors;
        private int wehrAttrErrors;
        private int schwAttrErrors;
        private int anlpAttrErrors;
        private int anllAttrErrors;
        private int krAttrErrors;
        private int eaAttrErrors;
        private int rlHoleErrors;
        private int rlOverlappsErrors;
        private int schaDistanceError;
        private int wehrDistanceError;
        private int schwDistanceError;
        private int krDistanceError;
        private int krFgBaError;
        private int krInvalidError;
        private int schaOffenError;
        private int anlpOffenError;
        private int anlpGeschlossenError;
        private int anlpEswError;
        private int krEswError;
        private int eaEswError;
        private int anllGeschlError;
        private int krMarkedTwiceError;
        private int haltungHolesError;
        private AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount;
        private H2FeatureService rlAttr;
        private H2FeatureService dAttr;
        private H2FeatureService dueAttr;
        private H2FeatureService schaAttr;
        private H2FeatureService wehrAttr;
        private H2FeatureService schwAttr;
        private H2FeatureService anlpAttr;
        private H2FeatureService anllAttr;
        private H2FeatureService krAttr;
        private H2FeatureService eaAttr;
        private H2FeatureService rlHole;
        private H2FeatureService rlOverlapps;
        private H2FeatureService schaDistance;
        private H2FeatureService wehrDistance;
        private H2FeatureService schwDistance;
        private H2FeatureService krDistance;
        private H2FeatureService krFgBa;
        private H2FeatureService krInvalid;
        private H2FeatureService schaOffen;
        private H2FeatureService anlpOffen;
        private H2FeatureService anlpGeschlossen;
        private H2FeatureService anlpEsw;
        private H2FeatureService krEsw;
        private H2FeatureService eaEsw;
        private H2FeatureService anllGeschl;
        private H2FeatureService krMarkedTwice;
        private H2FeatureService haltungHoles;

        protected CheckResult() {
        }

        public int getHaltungHolesError() {
            return this.haltungHolesError;
        }

        public void setHaltungHolesError(int haltungHolesError) {
            this.haltungHolesError = haltungHolesError;
        }

        public H2FeatureService getHaltungHoles() {
            return this.haltungHoles;
        }

        public void setHaltungHoles(H2FeatureService haltungHoles) {
            this.haltungHoles = haltungHoles;
        }

        public void setProblemTreeObjectCount(AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount) {
            this.problemTreeObjectCount = problemTreeObjectCount;
        }

        public int getKrInvalidError() {
            return this.krInvalidError;
        }

        public void setKrInvalidError(int krInvalidError) {
            this.krInvalidError = krInvalidError;
        }

        public H2FeatureService getKrInvalid() {
            return this.krInvalid;
        }

        public void setKrInvalid(H2FeatureService krInvalid) {
            this.krInvalid = krInvalid;
        }

        public int getKrFgBaError() {
            return this.krFgBaError;
        }

        public void setKrFgBaError(int krFgBaError) {
            this.krFgBaError = krFgBaError;
        }

        public H2FeatureService getKrFgBa() {
            return this.krFgBa;
        }

        public void setKrFgBa(H2FeatureService krFgBa) {
            this.krFgBa = krFgBa;
        }

        public int getRlAttrErrors() {
            return this.rlAttrErrors;
        }

        public void setRlAttrErrors(int rlAttrErrors) {
            this.rlAttrErrors = rlAttrErrors;
        }

        public int getdAttrErrors() {
            return this.dAttrErrors;
        }

        public void setdAttrErrors(int dAttrErrors) {
            this.dAttrErrors = dAttrErrors;
        }

        public int getDueAttrErrors() {
            return this.dueAttrErrors;
        }

        public void setDueAttrErrors(int dueAttrErrors) {
            this.dueAttrErrors = dueAttrErrors;
        }

        public int getSchaAttrErrors() {
            return this.schaAttrErrors;
        }

        public void setSchaAttrErrors(int schaAttrErrors) {
            this.schaAttrErrors = schaAttrErrors;
        }

        public int getWehrAttrErrors() {
            return this.wehrAttrErrors;
        }

        public void setWehrAttrErrors(int wehrAttrErrors) {
            this.wehrAttrErrors = wehrAttrErrors;
        }

        public int getSchwAttrErrors() {
            return this.schwAttrErrors;
        }

        public void setSchwAttrErrors(int schwAttrErrors) {
            this.schwAttrErrors = schwAttrErrors;
        }

        public int getAnlpAttrErrors() {
            return this.anlpAttrErrors;
        }

        public void setAnlpAttrErrors(int anlpAttrErrors) {
            this.anlpAttrErrors = anlpAttrErrors;
        }

        public int getAnllAttrErrors() {
            return this.anllAttrErrors;
        }

        public void setAnllAttrErrors(int anllAttrErrors) {
            this.anllAttrErrors = anllAttrErrors;
        }

        public int getKrAttrErrors() {
            return this.krAttrErrors;
        }

        public void setKrAttrErrors(int krAttrErrors) {
            this.krAttrErrors = krAttrErrors;
        }

        public int getEaAttrErrors() {
            return this.eaAttrErrors;
        }

        public void setEaAttrErrors(int eaAttrErrors) {
            this.eaAttrErrors = eaAttrErrors;
        }

        public H2FeatureService getRlAttr() {
            return this.rlAttr;
        }

        public void setRlAttr(H2FeatureService rlAttr) {
            this.rlAttr = rlAttr;
        }

        public H2FeatureService getdAttr() {
            return this.dAttr;
        }

        public void setdAttr(H2FeatureService dAttr) {
            this.dAttr = dAttr;
        }

        public H2FeatureService getDueAttr() {
            return this.dueAttr;
        }

        public void setDueAttr(H2FeatureService dueAttr) {
            this.dueAttr = dueAttr;
        }

        public H2FeatureService getSchaAttr() {
            return this.schaAttr;
        }

        public void setSchaAttr(H2FeatureService schaAttr) {
            this.schaAttr = schaAttr;
        }

        public H2FeatureService getWehrAttr() {
            return this.wehrAttr;
        }

        public void setWehrAttr(H2FeatureService wehrAttr) {
            this.wehrAttr = wehrAttr;
        }

        public H2FeatureService getSchwAttr() {
            return this.schwAttr;
        }

        public void setSchwAttr(H2FeatureService schwAttr) {
            this.schwAttr = schwAttr;
        }

        public H2FeatureService getAnlpAttr() {
            return this.anlpAttr;
        }

        public void setAnlpAttr(H2FeatureService anlpAttr) {
            this.anlpAttr = anlpAttr;
        }

        public H2FeatureService getAnllAttr() {
            return this.anllAttr;
        }

        public void setAnllAttr(H2FeatureService anllAttr) {
            this.anllAttr = anllAttr;
        }

        public H2FeatureService getKrAttr() {
            return this.krAttr;
        }

        public void setKrAttr(H2FeatureService krAttr) {
            this.krAttr = krAttr;
        }

        public H2FeatureService getEaAttr() {
            return this.eaAttr;
        }

        public void setEaAttr(H2FeatureService eaAttr) {
            this.eaAttr = eaAttr;
        }

        public int getBakCount() {
            return this.bakCount;
        }

        public void setBakCount(int bakCount) {
            this.bakCount = bakCount;
        }

        public int getRlHoleErrors() {
            return this.rlHoleErrors;
        }

        public void setRlHoleErrors(int rlHoleErrors) {
            this.rlHoleErrors = rlHoleErrors;
        }

        public H2FeatureService getRlHole() {
            return this.rlHole;
        }

        public void setRlHole(H2FeatureService rlHole) {
            this.rlHole = rlHole;
        }

        public H2FeatureService getRlOverlapps() {
            return this.rlOverlapps;
        }

        public void setRlOverlapps(H2FeatureService rlOverlapps) {
            this.rlOverlapps = rlOverlapps;
        }

        public int getRlOverlappsErrors() {
            return this.rlOverlappsErrors;
        }

        public void setRlOverlappsErrors(int rlOverlappsErrors) {
            this.rlOverlappsErrors = rlOverlappsErrors;
        }

        public H2FeatureService getSchaDistance() {
            return this.schaDistance;
        }

        public void setSchaDistance(H2FeatureService schaDistance) {
            this.schaDistance = schaDistance;
        }

        public H2FeatureService getWehrDistance() {
            return this.wehrDistance;
        }

        public void setWehrDistance(H2FeatureService wehrDistance) {
            this.wehrDistance = wehrDistance;
        }

        public H2FeatureService getSchwDistance() {
            return this.schwDistance;
        }

        public void setSchwDistance(H2FeatureService schwDistance) {
            this.schwDistance = schwDistance;
        }

        public H2FeatureService getKrDistance() {
            return this.krDistance;
        }

        public void setKrDistance(H2FeatureService krDistance) {
            this.krDistance = krDistance;
        }

        public int getSchaDistanceError() {
            return this.schaDistanceError;
        }

        public void setSchaDistanceError(int schaDistanceError) {
            this.schaDistanceError = schaDistanceError;
        }

        public int getWehrDistanceError() {
            return this.wehrDistanceError;
        }

        public void setWehrDistanceError(int wehrDistanceError) {
            this.wehrDistanceError = wehrDistanceError;
        }

        public int getSchwDistanceError() {
            return this.schwDistanceError;
        }

        public void setSchwDistanceError(int schwDistanceError) {
            this.schwDistanceError = schwDistanceError;
        }

        public int getKrDistanceError() {
            return this.krDistanceError;
        }

        public void setKrDistanceError(int krDistanceError) {
            this.krDistanceError = krDistanceError;
        }

        public H2FeatureService getSchaOffen() {
            return this.schaOffen;
        }

        public void setSchaOffen(H2FeatureService schaOffen) {
            this.schaOffen = schaOffen;
        }

        public H2FeatureService getAnlpOffen() {
            return this.anlpOffen;
        }

        public void setAnlpOffen(H2FeatureService anlpOffen) {
            this.anlpOffen = anlpOffen;
        }

        public H2FeatureService getAnlpGeschlossen() {
            return this.anlpGeschlossen;
        }

        public void setAnlpGeschlossen(H2FeatureService anlpGeschlossen) {
            this.anlpGeschlossen = anlpGeschlossen;
        }

        public H2FeatureService getAnlpEsw() {
            return this.anlpEsw;
        }

        public void setAnlpEsw(H2FeatureService anlpEsw) {
            this.anlpEsw = anlpEsw;
        }

        public int getSchaOffenError() {
            return this.schaOffenError;
        }

        public void setSchaOffenError(int schaOffenError) {
            this.schaOffenError = schaOffenError;
        }

        public int getAnlpOffenError() {
            return this.anlpOffenError;
        }

        public void setAnlpOffenError(int anlpOffenError) {
            this.anlpOffenError = anlpOffenError;
        }

        public int getAnlpGeschlossenError() {
            return this.anlpGeschlossenError;
        }

        public void setAnlpGeschlossenError(int anlpGeschlossenError) {
            this.anlpGeschlossenError = anlpGeschlossenError;
        }

        public int getAnlpEswError() {
            return this.anlpEswError;
        }

        public void setAnlpEswError(int anlpEswError) {
            this.anlpEswError = anlpEswError;
        }

        public H2FeatureService getKrEsw() {
            return this.krEsw;
        }

        public void setKrEsw(H2FeatureService krEsw) {
            this.krEsw = krEsw;
        }

        public H2FeatureService getEaEsw() {
            return this.eaEsw;
        }

        public void setEaEsw(H2FeatureService eaEsw) {
            this.eaEsw = eaEsw;
        }

        public H2FeatureService getAnllGeschl() {
            return this.anllGeschl;
        }

        public void setAnllGeschl(H2FeatureService anllGeschl) {
            this.anllGeschl = anllGeschl;
        }

        public H2FeatureService getKrMarkedTwice() {
            return this.krMarkedTwice;
        }

        public void setKrMarkedTwice(H2FeatureService krMarkedTwice) {
            this.krMarkedTwice = krMarkedTwice;
        }

        public int getKrEswError() {
            return this.krEswError;
        }

        public void setKrEswError(int krEswError) {
            this.krEswError = krEswError;
        }

        public int getEaEswError() {
            return this.eaEswError;
        }

        public void setEaEswError(int eaEswError) {
            this.eaEswError = eaEswError;
        }

        public int getAnllGeschlError() {
            return this.anllGeschlError;
        }

        public void setAnllGeschlError(int anllGeschlError) {
            this.anllGeschlError = anllGeschlError;
        }

        public int getKrMarkedTwiceError() {
            return this.krMarkedTwiceError;
        }

        public void setKrMarkedTwiceError(int krMarkedTwiceError) {
            this.krMarkedTwiceError = krMarkedTwiceError;
        }

        @Override
        public String[] getCheckNames() {
            return CHECK_NAMES;
        }

        @Override
        public AbstractCheckAction.ProblemCountAndClasses getProblemTreeObjectCount() {
            return this.problemTreeObjectCount;
        }

        @Override
        public int getErrorsPerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.rlAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.dAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.dueAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.schaAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.wehrAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.schwAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.anlpAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[7])) {
                return this.anllAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[8])) {
                return this.krAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[9])) {
                return this.eaAttrErrors;
            }
            if (checkName.equals(CHECK_NAMES[10])) {
                return this.rlHoleErrors;
            }
            if (checkName.equals(CHECK_NAMES[11])) {
                return this.rlOverlappsErrors;
            }
            if (checkName.equals(CHECK_NAMES[12])) {
                return this.schaDistanceError;
            }
            if (checkName.equals(CHECK_NAMES[13])) {
                return this.wehrDistanceError;
            }
            if (checkName.equals(CHECK_NAMES[14])) {
                return this.schwDistanceError;
            }
            if (checkName.equals(CHECK_NAMES[15])) {
                return this.krDistanceError;
            }
            if (checkName.equals(CHECK_NAMES[16])) {
                return this.krFgBaError;
            }
            if (checkName.equals(CHECK_NAMES[17])) {
                return this.krInvalidError;
            }
            if (checkName.equals(CHECK_NAMES[18])) {
                return this.schaOffenError;
            }
            if (checkName.equals(CHECK_NAMES[19])) {
                return this.anlpOffenError;
            }
            if (checkName.equals(CHECK_NAMES[20])) {
                return this.anlpGeschlossenError;
            }
            if (checkName.equals(CHECK_NAMES[21])) {
                return this.anlpEswError;
            }
            if (checkName.equals(CHECK_NAMES[22])) {
                return this.krEswError;
            }
            if (checkName.equals(CHECK_NAMES[23])) {
                return this.eaEswError;
            }
            if (checkName.equals(CHECK_NAMES[24])) {
                return this.anllGeschlError;
            }
            if (checkName.equals(CHECK_NAMES[25])) {
                return this.krMarkedTwiceError;
            }
            if (checkName.equals(CHECK_NAMES[26])) {
                return this.haltungHolesError;
            }
            return 0;
        }

        @Override
        public H2FeatureService getErrorTablePerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.rlAttr;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.dAttr;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.dueAttr;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.schaAttr;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.wehrAttr;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.schwAttr;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.anlpAttr;
            }
            if (checkName.equals(CHECK_NAMES[7])) {
                return this.anllAttr;
            }
            if (checkName.equals(CHECK_NAMES[8])) {
                return this.krAttr;
            }
            if (checkName.equals(CHECK_NAMES[9])) {
                return this.eaAttr;
            }
            if (checkName.equals(CHECK_NAMES[10])) {
                return this.rlHole;
            }
            if (checkName.equals(CHECK_NAMES[11])) {
                return this.rlOverlapps;
            }
            if (checkName.equals(CHECK_NAMES[12])) {
                return this.schaDistance;
            }
            if (checkName.equals(CHECK_NAMES[13])) {
                return this.wehrDistance;
            }
            if (checkName.equals(CHECK_NAMES[14])) {
                return this.schwDistance;
            }
            if (checkName.equals(CHECK_NAMES[15])) {
                return this.krDistance;
            }
            if (checkName.equals(CHECK_NAMES[16])) {
                return this.krFgBa;
            }
            if (checkName.equals(CHECK_NAMES[17])) {
                return this.krInvalid;
            }
            if (checkName.equals(CHECK_NAMES[18])) {
                return this.schaOffen;
            }
            if (checkName.equals(CHECK_NAMES[19])) {
                return this.anlpOffen;
            }
            if (checkName.equals(CHECK_NAMES[20])) {
                return this.anlpGeschlossen;
            }
            if (checkName.equals(CHECK_NAMES[21])) {
                return this.anlpEsw;
            }
            if (checkName.equals(CHECK_NAMES[22])) {
                return this.krEsw;
            }
            if (checkName.equals(CHECK_NAMES[23])) {
                return this.eaEsw;
            }
            if (checkName.equals(CHECK_NAMES[24])) {
                return this.anllGeschl;
            }
            if (checkName.equals(CHECK_NAMES[25])) {
                return this.krMarkedTwice;
            }
            if (checkName.equals(CHECK_NAMES[26])) {
                return this.haltungHoles;
            }
            return null;
        }
    }
}

