/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.checks;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.watergis.server.search.LawaConnected;
import de.cismet.cids.custom.watergis.server.search.LawaCount;
import de.cismet.cids.custom.watergis.server.search.LawaDirection;
import de.cismet.cids.custom.watergis.server.search.MergeLawa;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.factory.H2FeatureServiceFactory;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.checks.AbstractCheckAction;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class GWKConnectionCheckAction
extends AbstractCheckAction {
    private static final MetaClass LAK_AE_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_lak_ae");
    private static final MetaClass FG_BAK_GWK = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gwk");
    private static String QUERY_AE = null;
    private static final String CHECK_LAWA_ROUTEN_AUS_EINLEITUNG = "Pr\u00fcfungen->LAWA-Routen->Aus-/Einleitung";
    private static final String CHECK_LAWA_ROUTEN_GERICHTETHEIT = "Pr\u00fcfungen->LAWA-Routen->Gerichtetheit";
    private static final String CHECK_LAWA_ROUTEN_KONNEKTIVITAET = "Pr\u00fcfungen->LAWA-Routen->Konnektivit\u00e4t";
    private static final String[] ALL_CHECKS = new String[]{"Pr\u00fcfungen->LAWA-Routen->Aus-/Einleitung", "Pr\u00fcfungen->LAWA-Routen->Gerichtetheit", "Pr\u00fcfungen->LAWA-Routen->Konnektivit\u00e4t"};
    private static final int[] USED_CLASS_IDS = new int[]{LAK_AE_MC != null ? LAK_AE_MC.getId() : -1, FG_BAK_GWK != null ? FG_BAK_GWK.getId() : -1};
    private boolean successful = true;

    public GWKConnectionCheckAction() {
        this(false);
    }

    public GWKConnectionCheckAction(boolean isBackgroundCheck) {
        super(isBackgroundCheck);
        String tooltip = NbBundle.getMessage(GWKConnectionCheckAction.class, (String)"GWKConnectionCheckAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(GWKConnectionCheckAction.class, (String)"GWKConnectionCheckAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-vectoralt.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public int getProgressSteps() {
        return 7;
    }

    @Override
    public boolean startCheckInternal(final boolean isExport, WaitDialog wd, List<H2FeatureService> result) {
        WaitingDialogThread<CheckResult> wdt = new WaitingDialogThread<CheckResult>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(GWKConnectionCheckAction.class, (String)"GWKConnectionCheckAction.actionPerformed().dialog"), null, 100){

            protected CheckResult doInBackground() throws Exception {
                this.wd.setMax(GWKConnectionCheckAction.this.getProgressSteps());
                return GWKConnectionCheckAction.this.check(isExport, this.wd);
            }

            protected void done() {
                try {
                    CheckResult result = (CheckResult)this.get();
                    GWKConnectionCheckAction.this.removeServicesFromLayerModel(ALL_CHECKS);
                    if (isExport) {
                        return;
                    }
                    if (result.getProblemTreeObjectCount() == null || result.getProblemTreeObjectCount().getCount() == 0) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(GWKConnectionCheckAction.class, (String)"GWKConnectionCheckAction.actionPerformed().result.text.withoutProblems", (Object[])new Object[]{result.getLawaCount(), result.getConnectionErrors(), result.getDirectionErrors(), result.getLakAeErrors(), 0}), NbBundle.getMessage(GWKConnectionCheckAction.class, (String)"GWKConnectionCheckAction.actionPerformed().result.title"), 1);
                    } else {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(GWKConnectionCheckAction.class, (String)"GWKConnectionCheckAction.actionPerformed().result.text", (Object[])new Object[]{result.getLawaCount(), result.getConnectionErrors(), result.getDirectionErrors(), result.getLakAeErrors(), result.getProblemTreeObjectCount().getCount(), result.getProblemTreeObjectCount().getClasses()}), NbBundle.getMessage(GWKConnectionCheckAction.class, (String)"GWKConnectionCheckAction.actionPerformed().result.title"), 1);
                    }
                    if (result.getLakAeService() != null) {
                        GWKConnectionCheckAction.this.showService(result.getLakAeService(), "Pr\u00fcfungen->LAWA-Routen");
                    }
                    if (result.getDirectionService() != null) {
                        GWKConnectionCheckAction.this.showService(result.getDirectionService(), "Pr\u00fcfungen->LAWA-Routen");
                    }
                    if (result.getConnectionService() != null) {
                        GWKConnectionCheckAction.this.showService(result.getConnectionService(), "Pr\u00fcfungen->LAWA-Routen");
                    }
                    GWKConnectionCheckAction.this.refreshTree();
                    GWKConnectionCheckAction.this.refreshMap();
                }
                catch (Exception e) {
                    AbstractCheckAction.LOG.error((Object)"Error while performing the lawa connection analyse.", (Throwable)e);
                    GWKConnectionCheckAction.this.successful = false;
                }
            }
        };
        wdt.start();
        return this.successful;
    }

    @Override
    protected CheckResult check(boolean isExport, WaitDialog wd) throws Exception {
        Object laCdCode;
        TreeSet<Object> laCdSet;
        List features;
        XBoundingBox boundingBox;
        H2FeatureServiceFactory fac;
        ArrayList innerList;
        CheckResult result = new CheckResult();
        String user = AppBroker.getInstance().getOwner();
        if (user.equalsIgnoreCase("Administratoren")) {
            user = null;
        }
        this.removeServicesFromDb(ALL_CHECKS);
        MergeLawa search = new MergeLawa(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
        this.increaseProgress(wd, 1);
        ArrayList<Object> serviceAttributeDefinition = new ArrayList<FeatureServiceAttribute>();
        FeatureServiceAttribute serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("la_cd", String.valueOf(12), true);
        serviceAttributeDefinition.add(serviceAttribute);
        result.setConnectionService(this.analyseByCustomSearch((CidsServerSearch)new LawaConnected(user), CHECK_LAWA_ROUTEN_KONNEKTIVITAET, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        serviceAttributeDefinition = new ArrayList();
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("la_cd", String.valueOf(12), true);
        serviceAttributeDefinition.add(serviceAttribute);
        result.setDirectionService(this.analyseByCustomSearch((CidsServerSearch)new LawaDirection(user), CHECK_LAWA_ROUTEN_GERICHTETHEIT, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setLakAeService(this.analyseByQuery(LAK_AE_MC, QUERY_AE, CHECK_LAWA_ROUTEN_AUS_EINLEITUNG));
        this.increaseProgress(wd, 1);
        ArrayList lawaCountList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new LawaCount(user));
        if (lawaCountList != null && !lawaCountList.isEmpty() && (innerList = (ArrayList)lawaCountList.get(0)) != null && !innerList.isEmpty() && innerList.get(0) instanceof Number) {
            result.setLawaCount(((Number)innerList.get(0)).intValue());
        }
        this.increaseProgress(wd, 1);
        if (result.getConnectionService() != null) {
            fac = (H2FeatureServiceFactory)result.getConnectionService().getFeatureFactory();
            boundingBox = new XBoundingBox(fac.getEnvelope());
            features = fac.createFeatures(null, (BoundingBox)boundingBox, null, 0, 0, null);
            laCdSet = new TreeSet<Object>();
            for (FeatureServiceFeature fsf : features) {
                laCdCode = fsf.getProperty("la_cd");
                if (laCdCode == null) {
                    laCdCode = "";
                }
                laCdSet.add(laCdCode);
            }
            result.setConnectionErrors(laCdSet.size());
            this.successful = false;
        }
        this.increaseProgress(wd, 1);
        if (result.getDirectionService() != null) {
            fac = (H2FeatureServiceFactory)result.getDirectionService().getFeatureFactory();
            boundingBox = new XBoundingBox(fac.getEnvelope());
            features = fac.createFeatures(null, (BoundingBox)boundingBox, null, 0, 0, null);
            laCdSet = new TreeSet();
            for (FeatureServiceFeature fsf : features) {
                laCdCode = fsf.getProperty("la_cd");
                if (laCdCode == null) {
                    laCdCode = "";
                }
                laCdSet.add(laCdCode);
            }
            result.setDirectionErrors(laCdSet.size());
            this.successful = false;
        }
        this.increaseProgress(wd, 1);
        result.setProblemTreeObjectCount(this.getErrorObjectsFromTree(user, null, USED_CLASS_IDS, isExport));
        if (result.getLakAeService() != null) {
            result.setLakAeErrors(result.getLakAeService().getFeatureCount(null));
            this.successful = false;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    static {
        if (LAK_AE_MC != null) {
            QUERY_AE = "select " + LAK_AE_MC.getID() + ", ae." + LAK_AE_MC.getPrimaryKey() + " from dlm25w.fg_lak_ae ae \njoin dlm25w.fg_lak_linie linie on (ae.lak_st = linie.id) \njoin dlm25w.fg_lak_punkt von on (linie.von = von.id)\njoin dlm25w.fg_lak_punkt bis on (linie.bis = bis.id)\njoin geom gpv on (von.real_point = gpv.id) \njoin geom gpb on (bis.real_point = gpb.id) \njoin dlm25w.fg_lak lak on (von.route = lak.id) \njoin dlm25w.fg_lak lak_bis on (bis.route = lak_bis.id) \njoin geom on (lak.geom = geom.id) \njoin geom gb on (lak_bis.geom = gb.id) \nwhere \n(von.wert > 0 and abs(bis.wert - st_length(geom.geo_field)) >= 1) or (lak_bis.id <> lak.id) or (st_distance(ST_LineInterpolatePoint(geom.geo_field, case when von.wert / st_length(geom.geo_field) > 1.0 then 1.0 else von.wert / st_length(geom.geo_field) end ), gpv.geo_field) > 0.1 or st_distance(ST_LineInterpolatePoint(gb.geo_field, case when bis.wert / st_length(gb.geo_field) > 1.0 then 1.0 else bis.wert / st_length(gb.geo_field) end ), gpb.geo_field) > 0.1)  ;";
        }
    }

    private static class CheckResult
    extends AbstractCheckResult {
        private static final String[] CHECK_NAMES = new String[]{"CONNECTION_ERRORS", "DIRECTION_ERRORS", "LAK_AE_ERRORS"};
        private int connectionErrors;
        private int directionErrors;
        private int lakAeErrors;
        private int lawaCount;
        private AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount;
        private H2FeatureService directionService;
        private H2FeatureService connectionService;
        private H2FeatureService lakAeService;

        private CheckResult() {
        }

        @Override
        public AbstractCheckAction.ProblemCountAndClasses getProblemTreeObjectCount() {
            return this.problemTreeObjectCount;
        }

        public void setProblemTreeObjectCount(AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount) {
            this.problemTreeObjectCount = problemTreeObjectCount;
        }

        public int getConnectionErrors() {
            return this.connectionErrors;
        }

        public void setConnectionErrors(int connectionErrors) {
            this.connectionErrors = connectionErrors;
        }

        public int getDirectionErrors() {
            return this.directionErrors;
        }

        public void setDirectionErrors(int directionErrors) {
            this.directionErrors = directionErrors;
        }

        public int getLakAeErrors() {
            return this.lakAeErrors;
        }

        public void setLakAeErrors(int lakAeErrors) {
            this.lakAeErrors = lakAeErrors;
        }

        public H2FeatureService getDirectionService() {
            return this.directionService;
        }

        public void setDirectionService(H2FeatureService directionService) {
            this.directionService = directionService;
        }

        public H2FeatureService getConnectionService() {
            return this.connectionService;
        }

        public void setConnectionService(H2FeatureService connectionService) {
            this.connectionService = connectionService;
        }

        public H2FeatureService getLakAeService() {
            return this.lakAeService;
        }

        public void setLakAeService(H2FeatureService lakAeService) {
            this.lakAeService = lakAeService;
        }

        public int getLawaCount() {
            return this.lawaCount;
        }

        public void setLawaCount(int lawaCount) {
            this.lawaCount = lawaCount;
        }

        @Override
        public String[] getCheckNames() {
            return CHECK_NAMES;
        }

        @Override
        public int getErrorsPerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.connectionErrors;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.directionErrors;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.lakAeErrors;
            }
            return 0;
        }

        @Override
        public H2FeatureService getErrorTablePerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.connectionService;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.directionService;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.lakAeService;
            }
            return null;
        }
    }
}

