/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.gaf;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.dialog.GafCheckDialog;
import de.cismet.watergis.profile.ProfileReader;
import de.cismet.watergis.profile.ProfileReaderFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class CheckAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(CheckAction.class);

    public CheckAction() {
        String tooltip = NbBundle.getMessage(CheckAction.class, (String)"CheckAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(CheckAction.class, (String)"CheckAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(CheckAction.class, (String)"CheckAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-question-sign.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GafCheckDialog.getInstance().setSize(195, 190);
        StaticSwingTools.showDialog((JDialog)GafCheckDialog.getInstance());
        if (!GafCheckDialog.getInstance().isCancelled()) {
            WaitingDialogThread<String[][]> wdt = new WaitingDialogThread<String[][]>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed.waitingDialog"), null, 100, true){

                protected String[][] doInBackground() throws Exception {
                    ArrayList<String[]> checkResult = new ArrayList<String[]>();
                    File f = new File(GafCheckDialog.getInstance().getGafFile());
                    ProfileReader reader = ProfileReaderFactory.getReader(f);
                    String rkFile = GafCheckDialog.getInstance().getRkFile();
                    String bkFile = GafCheckDialog.getInstance().getBkFile();
                    if (rkFile != null) {
                        reader.addCustomCatalogue(new File(rkFile));
                    }
                    if (bkFile != null) {
                        reader.addCustomCatalogue(new File(bkFile));
                    }
                    checkResult.add(reader.checkFile());
                    return (String[][])checkResult.toArray((T[])new String[checkResult.size()][]);
                }

                protected void done() {
                    try {
                        String[][] checkResult = (String[][])this.get();
                        String[] errors = checkResult[0];
                        String[] hints = null;
                        if (checkResult.length > 1) {
                            hints = checkResult[1];
                        }
                        if (errors.length > 0) {
                            CheckAction.handleErrors(errors, new File(GafCheckDialog.getInstance().getGafFile()));
                        } else if (hints != null && hints.length > 0) {
                            CheckAction.handleHints(hints, new File(GafCheckDialog.getInstance().getGafFile()));
                        } else {
                            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().message"), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().title"), 1);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while checking gaf profiles.", (Throwable)e);
                    }
                }
            };
            wdt.start();
        }
    }

    public static void handleErrors(String[] errors, File errorPath) throws IOException {
        CheckAction.handleCheckResults(errors, true, errorPath);
    }

    public static void handleHints(String[] hints, File errorPath) throws IOException {
        CheckAction.handleCheckResults(hints, false, errorPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleCheckResults(String[] hints, boolean errors, File errorPath) throws IOException {
        String fileName = errorPath.getName();
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.indexOf("."));
        }
        if (fileName.equals("")) {
            fileName = WatergisApp.getDIRECTORYPATH_WATERGIS() + "/gaf";
        }
        errorPath = errorPath.getParentFile();
        File errorFile = new File(errorPath, fileName + (errors ? "-fehler.txt" : "-hinweise.txt"));
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new FileWriter(errorFile));
            for (String error : hints) {
                bw.write(error + System.lineSeparator());
            }
        }
        if (errors) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().error.message"), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().error.title"), 1);
        } else {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().hints.message"), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().hints.title"), 1);
        }
        DownloadManager.instance().add((Download)new FakeFileDownload(errorFile, "Pr\u00fcfergebnis"));
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

