/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.gaf;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.GafProfReportDialog;
import de.cismet.watergis.gui.panels.GafProf;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ReportAction.class);

    public ReportAction() {
        String tooltip = NbBundle.getMessage(ReportAction.class, (String)"ReportAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(ReportAction.class, (String)"ReportAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(ReportAction.class, (String)"ReportAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-contact-businesscard.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StaticSwingTools.showDialog((JDialog)GafProfReportDialog.getInstance());
        if (!GafProfReportDialog.getInstance().isCancelled()) {
            final ArrayList<FeatureServiceFeature> features = new ArrayList<FeatureServiceFeature>();
            if (GafProfReportDialog.getInstance().isObjectRestrictionSelected()) {
                features.addAll(FeatureServiceHelper.getSelectedCidsLayerFeatures("qp"));
            }
            if (!features.isEmpty()) {
                WaitingDialogThread<Boolean> wdt = new WaitingDialogThread<Boolean>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(ReportAction.class, (String)"ReportAction.actionPerformed.waitingDialog"), null, 100, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected Boolean doInBackground() throws Exception {
                        if (features.isEmpty()) {
                            CidsLayer layer = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp"));
                            layer.initAndWait();
                            features.addAll(layer.getFeatureFactory().createFeatures((Object)layer.getQuery(), null, null, 0, 0, null));
                        }
                        this.wd.setMax(features.size());
                        int i = 0;
                        this.wd.setText(NbBundle.getMessage(ReportAction.class, (String)"ReportAction.actionPerformed.progress", (Object)i, (Object)features.size()));
                        int selectedOptions = 0;
                        if (GafProfReportDialog.getInstance().isBasisSelected()) {
                            ++selectedOptions;
                        }
                        if (GafProfReportDialog.getInstance().isLawaSelected()) {
                            ++selectedOptions;
                        }
                        if (GafProfReportDialog.getInstance().isWithoutSelected()) {
                            ++selectedOptions;
                        }
                        boolean createFolder = selectedOptions > 1;
                        File basisPath = new File(GafProfReportDialog.getInstance().getPath(), "Basis");
                        File lawaPath = new File(GafProfReportDialog.getInstance().getPath(), "Lawa");
                        File withoutPath = new File(GafProfReportDialog.getInstance().getPath(), "ohne");
                        HashMap<String, Boolean> fileNames = new HashMap<String, Boolean>();
                        if (createFolder) {
                            if (GafProfReportDialog.getInstance().isBasisSelected() && !basisPath.exists()) {
                                basisPath.mkdirs();
                            }
                            if (GafProfReportDialog.getInstance().isLawaSelected() && !lawaPath.exists()) {
                                lawaPath.mkdirs();
                            }
                            if (GafProfReportDialog.getInstance().isWithoutSelected() && !withoutPath.exists()) {
                                withoutPath.mkdirs();
                            }
                        }
                        ReportAction.prepareFileNames(fileNames, features, basisPath, lawaPath);
                        for (FeatureServiceFeature feature : features) {
                            try {
                                String fileName;
                                if (Thread.interrupted() || this.canceled) {
                                    Boolean bl = false;
                                    return bl;
                                }
                                if (GafProfReportDialog.getInstance().isBasisSelected() && feature.getProperty("ba_cd") != null) {
                                    fileName = GafProf.getBasicReportFileName((CidsLayerFeature)feature);
                                    File basisFile = new File(basisPath, fileName);
                                    fileName = ReportAction.toValidFileName(fileNames, basisFile.getAbsolutePath(), feature);
                                    basisFile = new File(fileName);
                                    basisPath.mkdirs();
                                    ReportAction.createReport((CidsLayerFeature)feature, basisFile);
                                }
                                if (GafProfReportDialog.getInstance().isLawaSelected() && feature.getProperty("la_cd") != null) {
                                    fileName = GafProf.getLawaReportFileName((CidsLayerFeature)feature);
                                    File lawaFile = new File(lawaPath, fileName);
                                    fileName = ReportAction.toValidFileName(fileNames, lawaFile.getAbsolutePath(), feature);
                                    lawaFile = new File(fileName);
                                    lawaPath.mkdirs();
                                    ReportAction.createReport((CidsLayerFeature)feature, lawaFile);
                                }
                                if (!GafProfReportDialog.getInstance().isWithoutSelected() || feature.getProperty("ba_cd") != null) continue;
                                String nr = String.valueOf(feature.getProperty("qp_nr"));
                                String fileName2 = "gaf_ohne___" + nr + ".pdf";
                                File withoutFile = new File(withoutPath, fileName2);
                                fileName2 = ReportAction.toValidFileName(fileNames, withoutFile.getAbsolutePath(), feature);
                                withoutFile = new File(fileName2);
                                withoutPath.mkdirs();
                                ReportAction.createReport((CidsLayerFeature)feature, withoutFile);
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Error while creating photo report", (Throwable)ex);
                            }
                            finally {
                                this.wd.setText(NbBundle.getMessage(ReportAction.class, (String)"ReportAction.actionPerformed.progress", (Object)(++i), (Object)features.size()));
                                this.wd.setProgress(this.wd.getProgress() + 1);
                            }
                        }
                        return true;
                    }

                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while create photo reports.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
    }

    private static void prepareFileNames(Map<String, Boolean> fileNames, List<FeatureServiceFeature> features, File basisPath, File lawaPath) throws Exception {
        for (FeatureServiceFeature feature : features) {
            Boolean multiStation;
            String fileName;
            if (GafProfReportDialog.getInstance().isBasisSelected() && feature.getProperty("ba_cd") != null) {
                fileName = GafProf.getBasicReportFileName((CidsLayerFeature)feature);
                File basisFile = new File(basisPath, fileName);
                multiStation = fileNames.get(basisFile.getAbsolutePath());
                if (multiStation == null) {
                    fileNames.put(basisFile.getAbsolutePath(), Boolean.FALSE);
                } else if (!multiStation.booleanValue()) {
                    fileNames.put(basisFile.getAbsolutePath(), Boolean.TRUE);
                }
            }
            if (!GafProfReportDialog.getInstance().isLawaSelected() || feature.getProperty("la_cd") == null) continue;
            fileName = GafProf.getLawaReportFileName((CidsLayerFeature)feature);
            File lawaFile = new File(lawaPath, fileName);
            multiStation = fileNames.get(lawaFile.getAbsolutePath());
            if (multiStation == null) {
                fileNames.put(lawaFile.getAbsolutePath(), Boolean.FALSE);
                continue;
            }
            if (multiStation.booleanValue()) continue;
            fileNames.put(lawaFile.getAbsolutePath(), Boolean.TRUE);
        }
    }

    public static String toValidFileName(Map<String, Boolean> fileNames, String fileName, FeatureServiceFeature feature) {
        Boolean multiStation = fileNames.get(fileName);
        if (multiStation == null || !multiStation.booleanValue()) {
            return fileName;
        }
        String ending = fileName.substring(fileName.lastIndexOf("."));
        return fileName.substring(0, fileName.lastIndexOf(".")) + "___" + feature.getProperty("qp_nr") + ending;
    }

    public static void createReport(CidsLayerFeature feature, File file) throws Exception {
        ReportAction.createReport(feature, null, file);
    }

    public static void createReport(Integer qpId, File file) throws Exception {
        ReportAction.createReport(null, qpId, file);
    }

    private static void createReport(CidsLayerFeature feature, Integer qpId, File file) throws Exception {
        CidsLayerFeature qpFeature = feature;
        if (feature == null) {
            List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp");
            CidsLayer layer = services == null || services.isEmpty() ? new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp")) : (CidsLayer)services.get(0);
            layer.initAndWait();
            List features = layer.getFeatureFactory().createFeatures((Object)("qp_nr = " + qpId.toString()), null, null, 0, 0, null);
            if (features != null && !features.isEmpty() && features.get(0) instanceof CidsLayerFeature) {
                qpFeature = (CidsLayerFeature)features.get(0);
            }
        }
        JasperPrint print = GafProf.fillreport(qpFeature);
        print.setOrientation(print.getOrientationValue());
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)out);
        out.close();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

