/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.commons.gui.ClipboardWaitDialog;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.ImageSelection;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ExportMapAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ExportMapAction.class);
    private ClipboardWaitDialog clipboarder;

    public ExportMapAction() {
        String text = NbBundle.getMessage(ExportMapAction.class, (String)"ExportMapAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(ExportMapAction.class, (String)"ExportMapAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        String tooltip = NbBundle.getMessage(ExportMapAction.class, (String)"ExportMapAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-copy.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.clipboarder == null) {
            this.clipboarder = new ClipboardWaitDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ImageSelection imgSel = new ImageSelection(AppBroker.getInstance().getMappingComponent().getImage());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
                return null;
            }

            @Override
            protected void done() {
            }
        }.execute();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

