/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class PasteObjectAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(PasteObjectAction.class);

    public PasteObjectAction() {
        String tooltip = NbBundle.getMessage(PasteObjectAction.class, (String)"PasteObjectAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(PasteObjectAction.class, (String)"PasteObjectAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(PasteObjectAction.class, (String)"PasteObjectAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-pastealt.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ThemeLayerWidget tree = (ThemeLayerWidget)AppBroker.getInstance().getComponent(ComponentName.TREE);
        TreePath[] tps = tree.getSelectionPath();
        if (tps != null && tps.length == 1) {
            AbstractFeatureService service = (AbstractFeatureService)tps[0].getLastPathComponent();
            AttributeTable table = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeatureService(service);
            table.pasteSelectedFeaturesfromClipboard();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

