/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.commons.features.DrawingSLDStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.watergis.broker.AppBroker;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class RemoveDrawingModeAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(RemoveDrawingModeAction.class);

    public RemoveDrawingModeAction() {
        this.setEnabled(false);
        String tooltip = NbBundle.getMessage(RemoveDrawingModeAction.class, (String)"RemoveDrawingModeAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(RemoveDrawingModeAction.class, (String)"RemoveDrawingModeAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(RemoveDrawingModeAction.class, (String)"RemoveDrawingModeAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-selectionintersect.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"remiove selected features");
        }
        MappingComponent map = AppBroker.getInstance().getMappingComponent();
        List<DrawingSLDStyledFeature> selectedFeatures = RemoveDrawingModeAction.getSelectedDrawings();
        for (Feature feature : selectedFeatures) {
            map.getFeatureCollection().removeFeature(feature);
            PNotificationCenter pn = PNotificationCenter.defaultCenter();
            pn.postNotification("FEATURE_DELETE_REQUEST_NOTIFICATION", (Object)this);
        }
    }

    public static List<DrawingSLDStyledFeature> getSelectedDrawings() {
        ArrayList<DrawingSLDStyledFeature> drawings = new ArrayList<DrawingSLDStyledFeature>();
        MappingComponent map = AppBroker.getInstance().getMappingComponent();
        ArrayList selectedFeatures = new ArrayList(map.getFeatureCollection().getSelectedFeatures());
        for (Feature f : selectedFeatures) {
            if (!(f instanceof DrawingSLDStyledFeature)) continue;
            drawings.add((DrawingSLDStyledFeature)f);
        }
        return drawings;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

