/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.dialog.GerinneGeschlFlaechenReportDialog;
import de.cismet.watergis.reports.GerinneGFlReport;
import de.cismet.watergis.reports.types.Flaeche;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class GerinneGFlReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GerinneGFlReportAction.class);

    public GerinneGFlReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-analytics-piechart.png");
        String text = "Fl\u00e4chenthema";
        String tooltiptext = "Fl\u00e4chenthemaauswertung";
        String mnemonic = "F";
        try {
            text = NbBundle.getMessage(GerinneGFlReportAction.class, (String)"GerinneGFlReportAction.text");
            tooltiptext = NbBundle.getMessage(GerinneGFlReportAction.class, (String)"GerinneGFlReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(GerinneGFlReportAction.class, (String)"GerinneGFlReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StaticSwingTools.showDialog((JDialog)GerinneGeschlFlaechenReportDialog.getInstance());
            if (!GerinneGeschlFlaechenReportDialog.getInstance().isCancelled()) {
                WaitingDialogThread<File> wdt = new WaitingDialogThread<File>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

                    protected File doInBackground() throws Exception {
                        Flaeche fl;
                        ArrayList<Integer> baCdList = new ArrayList<Integer>();
                        ArrayList<Flaeche> flList = new ArrayList<Flaeche>();
                        if (GerinneGeschlFlaechenReportDialog.getInstance().isSelectionGew()) {
                            for (FeatureServiceFeature feature : GerinneGeschlFlaechenReportDialog.getInstance().getSelectedGew()) {
                                baCdList.add((Integer)feature.getProperty("id"));
                            }
                        }
                        if (GerinneGeschlFlaechenReportDialog.getInstance().isSelectionFl()) {
                            for (FeatureServiceFeature feature : GerinneGeschlFlaechenReportDialog.getInstance().getSelectedFl()) {
                                fl = new Flaeche();
                                fl.setGeom(feature.getGeometry());
                                fl.setAttr1(feature.getProperty(GerinneGeschlFlaechenReportDialog.getInstance().getAttr1()));
                                fl.setAttr2(feature.getProperty(GerinneGeschlFlaechenReportDialog.getInstance().getAttr2()));
                                flList.add(fl);
                            }
                        } else {
                            AbstractFeatureService service = GerinneGeschlFlaechenReportDialog.getInstance().getFlaechenService();
                            service.initAndWait();
                            List features = service.getFeatureFactory().createFeatures(service.getQuery(), null, null, 0, 0, null);
                            for (FeatureServiceFeature feature : features) {
                                fl = new Flaeche();
                                fl.setGeom(feature.getGeometry());
                                fl.setAttr1(feature.getProperty(GerinneGeschlFlaechenReportDialog.getInstance().getAttr1()));
                                fl.setAttr2(feature.getProperty(GerinneGeschlFlaechenReportDialog.getInstance().getAttr2()));
                                flList.add(fl);
                            }
                        }
                        GerinneGFlReport gr = new GerinneGFlReport();
                        int[] gew = new int[baCdList.size()];
                        if (baCdList.isEmpty()) {
                            gew = null;
                        } else {
                            for (int i = 0; i < baCdList.size(); ++i) {
                                gew[i] = (Integer)baCdList.get(i);
                            }
                        }
                        return gr.createFlaechenReport(flList.toArray(new Flaeche[flList.size()]), gew);
                    }

                    protected void done() {
                        try {
                            DownloadManager.instance().add((Download)new FakeFileDownload((File)this.get(), "Statistik: Gerinne (geschlossen)->Fl\u00e4chen"));
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while performing the geschlossene Gerinne report.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating gemeinden report", (Throwable)ex);
        }
    }
}

