/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.dialog.GerinneOGewaesserReportDialog;
import de.cismet.watergis.reports.GerinneOGewaesserReport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class GerinneOGewReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GerinneOGewReportAction.class);

    public GerinneOGewReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-analytics-piechart.png");
        String text = "Gew\u00e4sser";
        String tooltiptext = "Gew\u00e4sserauswertung";
        String mnemonic = "W";
        try {
            text = NbBundle.getMessage(GerinneOGewReportAction.class, (String)"GerinneOGewReportAction.text");
            tooltiptext = NbBundle.getMessage(GerinneOGewReportAction.class, (String)"GerinneOGewReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(GerinneOGewReportAction.class, (String)"GerinneOGewReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StaticSwingTools.showDialog((JDialog)GerinneOGewaesserReportDialog.getInstance());
            if (!GerinneOGewaesserReportDialog.getInstance().isCancelled()) {
                WaitingDialogThread<File> wdt = new WaitingDialogThread<File>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

                    protected File doInBackground() throws Exception {
                        ArrayList<Integer> baCdList = new ArrayList<Integer>();
                        if (GerinneOGewaesserReportDialog.getInstance().isSelectionGew()) {
                            for (FeatureServiceFeature feature : GerinneOGewaesserReportDialog.getInstance().getSelectedGew()) {
                                baCdList.add((Integer)feature.getProperty("id"));
                            }
                        }
                        GerinneOGewaesserReport gr = new GerinneOGewaesserReport();
                        int[] gew = new int[baCdList.size()];
                        if (baCdList.isEmpty()) {
                            gew = null;
                        } else {
                            for (int i = 0; i < baCdList.size(); ++i) {
                                gew[i] = (Integer)baCdList.get(i);
                            }
                        }
                        return gr.createGewaesserReport(gew);
                    }

                    protected void done() {
                        try {
                            DownloadManager.instance().add((Download)new FakeFileDownload((File)this.get(), "Statistik: Gerinne (offen)->Gew\u00e4sser"));
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Bei der Erstellung der Auswertung ist ein Fehler aufgetreten.\nEine Fehlerbeschreibung kann dem Logging entnommen werden", "Fehler", 0);
                            LOG.error((Object)"Error while performing the offene Gerinne gewaesser report.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating gerinne offen gewaesser report", (Throwable)ex);
        }
    }
}

