/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllRoutes;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.actions.ExportAction;
import de.cismet.watergis.gui.dialog.GewaesserReportDialog;
import de.cismet.watergis.reports.GewaesserReport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class GewaesserReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GewaesserReportAction.class);
    private static final MetaClass FG_BA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
    private ExportAction export;

    public GewaesserReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-contact-businesscard.png");
        String text = "GU";
        String tooltiptext = "Gew\u00e4sserauswertung";
        String mnemonic = "G";
        try {
            text = NbBundle.getMessage(GewaesserReportAction.class, (String)"GewaesserReportAction.text");
            tooltiptext = NbBundle.getMessage(GewaesserReportAction.class, (String)"GewaesserReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(GewaesserReportAction.class, (String)"GewaesserReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("ShortDescription", tooltiptext);
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StaticSwingTools.showDialog((JDialog)GewaesserReportDialog.getInstance());
            if (!GewaesserReportDialog.getInstance().isCancelled()) {
                WaitingDialogThread<Boolean> wdt = new WaitingDialogThread<Boolean>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

                    protected Boolean doInBackground() throws Exception {
                        Object f;
                        ArrayList<String> baCdList = new ArrayList<String>();
                        if (GewaesserReportDialog.getInstance().isSelection()) {
                            for (FeatureServiceFeature feature : GewaesserReportDialog.getInstance().getSelectedFeatures()) {
                                baCdList.add((String)feature.getProperty("ba_cd"));
                            }
                        } else {
                            SessionManager.getSession().getUser();
                            String owner = AppBroker.getInstance().getOwner();
                            if (!owner.equalsIgnoreCase("Administratoren")) {
                                MetaClass FG_BA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
                                CidsLayer cl = new CidsLayer(FG_BA);
                                cl.initAndWait();
                                String query = "dlm25wPk_ww_gr1.owner  = '" + owner + "'";
                                List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, null);
                                Iterator iterator = featureList.iterator();
                                while (iterator.hasNext()) {
                                    f = (CidsLayerFeature)iterator.next();
                                    baCdList.add((String)f.getProperty("ba_cd"));
                                }
                            } else {
                                AllRoutes search = new AllRoutes();
                                User user = SessionManager.getSession().getUser();
                                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
                                if (attributes != null && !attributes.isEmpty()) {
                                    for (ArrayList f2 : attributes) {
                                        baCdList.add((String)f2.get(0));
                                    }
                                }
                            }
                        }
                        GewaesserReport gr = new GewaesserReport();
                        int index = 0;
                        int listSize = baCdList.size();
                        ArrayList<FakeFileDownload> downloads = new ArrayList<FakeFileDownload>();
                        this.wd.setMax(listSize);
                        for (String baCd : baCdList) {
                            this.wd.setProgress(index);
                            this.wd.setText("Erstelle " + index++ + " / " + listSize);
                            f = gr.createReport(baCd);
                            if (Thread.interrupted() || this.canceled) break;
                            if (f == null) continue;
                            downloads.add(new FakeFileDownload((File)f));
                        }
                        if (downloads.size() > 1) {
                            MultipleDownload d = new MultipleDownload(downloads, "Gew\u00e4sser");
                            DownloadManager.instance().add((Download)d);
                        } else if (downloads.size() == 1) {
                            DownloadManager.instance().add((Download)downloads.get(0));
                        }
                        gr.cleanup();
                        return true;
                    }

                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while performing the gewaesser report.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating gewaesser report", (Throwable)ex);
        }
    }

    public void setExport(ExportAction export) {
        this.export = export;
    }
}

