/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.WsgRechtSearch;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.reports.GerinneGGewaesserReportAction;
import de.cismet.watergis.gui.dialog.FgGerogaRsDialog;
import de.cismet.watergis.gui.dialog.WsgRechtDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class RechtsgrundlageAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GerinneGGewaesserReportAction.class);
    private static final ConnectionContext cc = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"WsgAction");
    private FgGerogaRsDialog dialog;

    public RechtsgrundlageAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-spiderweb.png");
        String text = "Rechtsgrundlage";
        String tooltiptext = "Rechtsgrundlage";
        String mnemonic = "R";
        try {
            text = NbBundle.getMessage(RechtsgrundlageAction.class, (String)"RechtsgrundlageAction.text");
            tooltiptext = NbBundle.getMessage(RechtsgrundlageAction.class, (String)"RechtsgrundlageAction.toolTipText");
            mnemonic = NbBundle.getMessage(RechtsgrundlageAction.class, (String)"RechtsgrundlageAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("ShortDescription", tooltiptext);
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WaitingDialogThread<WsgRechtDialog> wdt = new WaitingDialogThread<WsgRechtDialog>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

            protected WsgRechtDialog doInBackground() throws Exception {
                WsgRechtSearch search = new WsgRechtSearch();
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search, cc);
                int wsgCount = ((Long)attributes.get(0)).intValue();
                double wsgTotal = ((BigDecimal)attributes.get(1)).doubleValue();
                int brdCount = ((Long)attributes.get(2)).intValue();
                int ddrCount = ((Long)attributes.get(3)).intValue();
                double brdTotal = (Double)attributes.get(4);
                double ddrTotal = (Double)attributes.get(5);
                WsgRechtDialog dialog = new WsgRechtDialog(AppBroker.getInstance().getWatergisApp(), true, wsgCount, wsgTotal, brdCount, ddrCount, brdTotal, ddrTotal);
                return dialog;
            }

            protected void done() {
                try {
                    WsgRechtDialog dialog = (WsgRechtDialog)this.get();
                    if (dialog != null) {
                        StaticSwingTools.centerWindowOnScreen((Window)dialog);
                        ActiveLayerModel model = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
                        MetaClass wsgMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.wr_sg_wsg_rgl");
                        CidsLayer layer = new CidsLayer(wsgMc);
                        model.removeLayer((RetrievalServiceLayer)layer);
                        model.addLayer((RetrievalServiceLayer)layer);
                    }
                }
                catch (Exception e) {
                    ErrorInfo info = new ErrorInfo("Fehler bei der Auswertung", e.getMessage(), null, null, (Throwable)e, Level.SEVERE, null);
                    JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), (ErrorInfo)info);
                }
            }
        };
        wdt.start();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

