/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.actions.ExportAction;
import de.cismet.watergis.gui.dialog.WkFgReportDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class WkFgReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(WkFgReportAction.class);
    private static final MetaClass FG_BA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
    private ExportAction export;

    public WkFgReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-contact-businesscard.png");
        String text = "FG";
        String tooltiptext = "Wasserk\u00f6rperauswerung";
        String mnemonic = "F";
        try {
            text = NbBundle.getMessage(WkFgReportAction.class, (String)"WkFgReportAction.text");
            tooltiptext = NbBundle.getMessage(WkFgReportAction.class, (String)"WkFgReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(WkFgReportAction.class, (String)"WkFgReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StaticSwingTools.showDialog((JDialog)WkFgReportDialog.getInstance());
            if (!WkFgReportDialog.getInstance().isCancelled()) {
                WaitingDialogThread<Boolean> wdt = new WaitingDialogThread<Boolean>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "lade Steckbriefe", null, 100, true){

                    protected Boolean doInBackground() throws Exception {
                        TreeSet<String> wkNrList = new TreeSet<String>();
                        if (WkFgReportDialog.getInstance().isSelection()) {
                            for (FeatureServiceFeature feature : WkFgReportDialog.getInstance().getSelectedFeatures()) {
                                wkNrList.add((String)feature.getProperty("wk_nr"));
                            }
                        } else {
                            MetaClass fgLaWkMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_wk");
                            CidsLayer cl = new CidsLayer(fgLaWkMc);
                            cl.initAndWait();
                            List features = cl.getFeatureFactory().createFeatures((Object)cl.getQuery(), null, null, 0, 0, null);
                            if (features != null && !features.isEmpty()) {
                                for (FeatureServiceFeature f : features) {
                                    String wkNr = (String)f.getProperty("wk_nr");
                                    if (wkNr == null) continue;
                                    wkNrList.add(wkNr);
                                }
                            }
                        }
                        int index = 0;
                        int listSize = wkNrList.size();
                        ArrayList<FakeFileDownload> downloads = new ArrayList<FakeFileDownload>();
                        this.wd.setMax(listSize);
                        for (String wkk : wkNrList) {
                            this.wd.setProgress(index);
                            this.wd.setText("Lade " + index++ + " / " + listSize);
                            try {
                                int ans;
                                String path = WkFgReportDialog.getInstance().getPath();
                                File fileToSaveTo = new File(path, wkk + ".pdf");
                                if (fileToSaveTo.exists() && (ans = JOptionPane.showConfirmDialog((Component)this.wd, NbBundle.getMessage(WkFgReportAction.class, (String)"WkFgReportAction.actionPerformed().fileExists.text", (Object)fileToSaveTo.getAbsolutePath()), NbBundle.getMessage(WkFgReportAction.class, (String)"WkFgReportAction.actionPerformed().fileExists.title"), 0)) != 0) continue;
                                WkFgReportAction.downloadDocumentFromWebDav(WatergisDefaultRuleSet.WK_FG_WEBDAV_PATH, WatergisDefaultRuleSet.addExtension(wkk.toUpperCase(), "pdf"), fileToSaveTo);
                                downloads.add(new FakeFileDownload(fileToSaveTo));
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Error while creating report", (Throwable)ex);
                            }
                            if (!Thread.interrupted() && !this.canceled) continue;
                            break;
                        }
                        if (downloads.size() > 1) {
                            MultipleDownload d = new MultipleDownload(downloads, "Gew\u00e4sser");
                            DownloadManager.instance().add((Download)d);
                        } else if (downloads.size() == 1) {
                            DownloadManager.instance().add((Download)downloads.get(0));
                        }
                        return true;
                    }

                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while performing the gewaesser report.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating gewaesser report", (Throwable)ex);
        }
    }

    public static void downloadDocumentFromWebDav(String path, String file, File fileToSave) throws Exception {
        int size;
        while (file.startsWith("/")) {
            file = file.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        WebDavClient webDavClient = WatergisDefaultRuleSet.createWebDavClient();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fileToSave));
        InputStream is = webDavClient.getInputStream(path + WebDavHelper.encodeURL((String)file));
        byte[] buffer = new byte[256];
        int totalSize = 0;
        while ((size = is.read(buffer)) != -1) {
            totalSize += size;
            os.write(buffer, 0, size);
        }
        is.close();
        os.close();
        if (totalSize < 800) {
            BufferedOutputStream tos = new BufferedOutputStream(new FileOutputStream(fileToSave));
            InputStream tis = WkFgReportAction.class.getResourceAsStream("/de/cismet/watergis/printing/Steckbrief-Template.pdf");
            while ((size = tis.read(buffer)) != -1) {
                tos.write(buffer, 0, size);
            }
            tis.close();
            tos.close();
        }
    }

    public void setExport(ExportAction export) {
        this.export = export;
    }
}

